/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.LocalFileSystemFileFinderKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/debugger/LocalFileSystemFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "<init>", "()V", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getRemoteUrls", "", "file", "intellij.javascript.debugger"})
public class LocalFileSystemFileFinder
implements DebuggableFileFinder {
    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        String projectBasePath;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        if (!OSAgnosticPathUtil.isAbsolute((String)path)) {
            return null;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file == null && (projectBasePath = project.getBasePath()) != null && FileUtil.isAncestor((String)projectBasePath, (String)path, (boolean)true)) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
        }
        VirtualFile virtualFile3 = file;
        if (virtualFile3 != null) {
            VirtualFile it = virtualFile3;
            boolean bl = false;
            virtualFile2 = (VirtualFile)ActionsKt.runReadAction(() -> LocalFileSystemFileFinder.findFile$lambda$1$lambda$0(project, it));
        } else {
            virtualFile2 = null;
        }
        if ((virtualFile = (file = virtualFile2)) == null) {
            virtualFile = LocalFileSystemFileFinderKt.findByRelativePath(path, project);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return CollectionsKt.listOf((Object)ScriptDebuggerUrls.newLocalFileUrl((String)string));
    }

    private static final VirtualFile findFile$lambda$1$lambda$0(Project $project, VirtualFile $it) {
        return ProjectRootUtil.findSymlinkedFileInContent((Project)$project, (VirtualFile)$it);
    }
}

