/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.apacheConfig.rewriting;

import com.intellij.lang.apacheConfig.psi.ACFile;
import com.intellij.lang.apacheConfig.rewriting.RewriteRule;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttributeValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UrlRewriteEngine {
    private final Project myProject;

    public static UrlRewriteEngine getInstance(Project p) {
        return (UrlRewriteEngine)p.getService(UrlRewriteEngine.class);
    }

    public UrlRewriteEngine(Project project) {
        this.myProject = project;
    }

    @Nullable
    public String applyRewriteRules(PsiElement psiElement) {
        String url;
        String string = url = psiElement instanceof XmlAttributeValue ? ((XmlAttributeValue)psiElement).getValue() : psiElement.getText();
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        List<ACFile> files = this.getHtaccessFiles(psiElement);
        for (ACFile file : files) {
            List<RewriteRule> l = file.getRewriteRules();
            for (RewriteRule rewriteRule : l) {
                try {
                    if (!rewriteRule.canBeApplied(url)) continue;
                    return rewriteRule.apply(url);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
            }
        }
        return null;
    }

    private List<ACFile> getHtaccessFiles(PsiElement psiElement) {
        ArrayList<ACFile> result = new ArrayList<ACFile>();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null || containingFile.getVirtualFile() == null) {
            return result;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)psiElement.getProject()).getFileIndex().getContentRootForFile(containingFile.getVirtualFile());
        for (PsiDirectory dir = containingFile.getParent(); dir != null; dir = dir.getParent()) {
            ACFile f = this.lookupForHtaccess(dir);
            if (f != null) {
                result.add(f);
            }
            if (dir.getVirtualFile().equals(contentRoot)) break;
        }
        return result;
    }

    private ACFile lookupForHtaccess(PsiDirectory dir) {
        for (PsiFile f : dir.getFiles()) {
            if (!(f instanceof ACFile)) continue;
            return (ACFile)f;
        }
        return null;
    }
}

