/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting.settings;

import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.highlighting.settings.DefaultSettingsStoreItems;
import com.intellij.ideolog.highlighting.settings.LogParsingPattern;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBIntSpinner;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.miginfocom.swing.MigLayout;
import org.intellij.lang.regexp.RegExpFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogParsingPatternSettingsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "item", "Lcom/intellij/ideolog/highlighting/settings/LogParsingPattern;", "<init>", "(Lcom/intellij/ideolog/highlighting/settings/LogParsingPattern;)V", "myNameText", "Lcom/intellij/ui/EditorTextField;", "myParsingPatternText", "myLineStartPatternText", "myTimePatternText", "myTimeColumnId", "Lcom/intellij/ui/JBIntSpinner;", "mySeverityColumnId", "myCategoryColumnId", "createCenterPanel", "Ljavax/swing/JComponent;", "getDatePreviewText", "", "format", "doOKAction", "", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogParsingPatternSettingsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogParsingPatternSettingsDialog.kt\ncom/intellij/ideolog/highlighting/settings/LogParsingPatternSettingsDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class LogParsingPatternSettingsDialog
extends DialogWrapper {
    @NotNull
    private final LogParsingPattern item;
    @Nullable
    private EditorTextField myNameText;
    @Nullable
    private EditorTextField myParsingPatternText;
    @Nullable
    private EditorTextField myLineStartPatternText;
    @Nullable
    private EditorTextField myTimePatternText;
    @Nullable
    private JBIntSpinner myTimeColumnId;
    @Nullable
    private JBIntSpinner mySeverityColumnId;
    @Nullable
    private JBIntSpinner myCategoryColumnId;

    public LogParsingPatternSettingsDialog(@NotNull LogParsingPattern item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        super(null, true, DialogWrapper.IdeModalityType.IDE);
        this.item = item;
        this.init();
        this.initValidation();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected JComponent createCenterPanel() {
        JBIntSpinner categorySpinner;
        JBIntSpinner severitySpinner;
        JBIntSpinner timeSpinner;
        void $this$createCenterPanel_u24lambda_u244_u24lambda_u243;
        HyperlinkLabel hyperlinkLabel;
        BorderLayoutPanel borderLayoutPanel;
        void $this$createCenterPanel_u24lambda_u242;
        EditorTextField timeFormatText;
        EditorTextField linePatternText;
        EditorTextField patternText;
        EditorTextField nameText;
        JLabel $this$createCenterPanel_u24lambda_u241_u24lambda_u240;
        HyperlinkLabel hyperlinkLabel2;
        BorderLayoutPanel borderLayoutPanel2;
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, wrap 2", "[right][fill]"));
        BorderLayoutPanel $this$createCenterPanel_u24lambda_u241 = borderLayoutPanel2 = new BorderLayoutPanel();
        boolean bl = false;
        HyperlinkLabel hyperlinkLabel3 = hyperlinkLabel2 = new HyperlinkLabel();
        Object object = $this$createCenterPanel_u24lambda_u241;
        boolean bl2 = false;
        $this$createCenterPanel_u24lambda_u241_u24lambda_u240.setHyperlinkText(IdeologBundle.message("link.wiki.custom.log.format", new Object[0]));
        $this$createCenterPanel_u24lambda_u241_u24lambda_u240.setHyperlinkTarget("https://github.com/JetBrains/ideolog/wiki/Custom-Log-Formats");
        object.add((Component)hyperlinkLabel2);
        BorderLayoutPanel wikiCustomLogFormats = borderLayoutPanel2;
        panel.add((Component)wikiCustomLogFormats, "span 2, left");
        panel.add(new JLabel(IdeologBundle.message("settings.dialog.label.name", new Object[0])));
        this.myNameText = nameText = new EditorTextField(this.item.getName());
        panel.add((Component)nameText);
        panel.add(new JLabel(IdeologBundle.message("settings.dialog.label.message.pattern", new Object[0])));
        this.myParsingPatternText = patternText = new EditorTextField(this.item.getPattern(), ProjectManager.getInstance().getDefaultProject(), (FileType)RegExpFileType.INSTANCE);
        panel.add((Component)patternText);
        panel.add(new JLabel(IdeologBundle.message("settings.dialog.label.message.start.pattern", new Object[0])));
        this.myLineStartPatternText = linePatternText = new EditorTextField(this.item.getLineStartPattern(), ProjectManager.getInstance().getDefaultProject(), (FileType)RegExpFileType.INSTANCE);
        panel.add((Component)linePatternText);
        panel.add(new JLabel(IdeologBundle.message("settings.dialog.label.time.format", new Object[0])));
        this.myTimePatternText = timeFormatText = new EditorTextField(this.item.getTimePattern());
        panel.add((Component)timeFormatText);
        $this$createCenterPanel_u24lambda_u241_u24lambda_u240 = new JLabel(IdeologBundle.message("settings.dialog.label.preview", new Object[0]));
        object = $this$createCenterPanel_u24lambda_u241_u24lambda_u240;
        JPanel jPanel = panel;
        boolean bl3 = false;
        $this$createCenterPanel_u24lambda_u242.setForeground(UIUtil.getLabelDisabledForeground());
        jPanel.add($this$createCenterPanel_u24lambda_u241_u24lambda_u240);
        JLabel timeFormatPreviewLabel = new JLabel(this.getDatePreviewText(this.item.getTimePattern()));
        MergingUpdateQueue queue = new MergingUpdateQueue("TimePreview", 500, true, MergingUpdateQueue.ANY_COMPONENT, this.myDisposable, null, false, 96, null);
        timeFormatText.getDocument().addDocumentListener(new DocumentListener(queue, timeFormatPreviewLabel, this){
            final /* synthetic */ MergingUpdateQueue $queue;
            final /* synthetic */ JLabel $timeFormatPreviewLabel;
            final /* synthetic */ LogParsingPatternSettingsDialog this$0;
            {
                this.$queue = $queue;
                this.$timeFormatPreviewLabel = $timeFormatPreviewLabel;
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$queue.queue(new Update(this.$timeFormatPreviewLabel, this.this$0, event){
                    final /* synthetic */ JLabel $timeFormatPreviewLabel;
                    final /* synthetic */ LogParsingPatternSettingsDialog this$0;
                    final /* synthetic */ DocumentEvent $event;
                    {
                        this.$timeFormatPreviewLabel = $timeFormatPreviewLabel;
                        this.this$0 = $receiver;
                        this.$event = $event;
                        super((Object)"typingTime", false, 0, 6, null);
                    }

                    public void run() {
                        String string = this.$event.getDocument().getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        this.$timeFormatPreviewLabel.setText(LogParsingPatternSettingsDialog.access$getDatePreviewText(this.this$0, string));
                    }
                });
            }
        }, this.myDisposable);
        panel.add(timeFormatPreviewLabel);
        panel.add(new JLabel());
        BorderLayoutPanel $this$createCenterPanel_u24lambda_u244 = borderLayoutPanel = new BorderLayoutPanel();
        boolean bl4 = false;
        HyperlinkLabel hyperlinkLabel4 = hyperlinkLabel = new HyperlinkLabel();
        BorderLayoutPanel borderLayoutPanel3 = $this$createCenterPanel_u24lambda_u244;
        boolean bl5 = false;
        $this$createCenterPanel_u24lambda_u244_u24lambda_u243.setHyperlinkText(IdeologBundle.message("link.label.documentation", new Object[0]));
        $this$createCenterPanel_u24lambda_u244_u24lambda_u243.setHyperlinkTarget("https://docs.oracle.com/javase/7/docs/api/java/text/SimpleDateFormat.html");
        borderLayoutPanel3.addToLeft((Component)hyperlinkLabel);
        BorderLayoutPanel linkLbl = borderLayoutPanel;
        panel.add((Component)linkLbl);
        panel.add(new JLabel(IdeologBundle.message("time.capture.group", new Object[0])));
        this.myTimeColumnId = timeSpinner = new JBIntSpinner(this.item.getTimeColumnId() + 1, 0, 100);
        panel.add((Component)timeSpinner);
        panel.add(new JLabel(IdeologBundle.message("severity.capture.group", new Object[0])));
        this.mySeverityColumnId = severitySpinner = new JBIntSpinner(this.item.getSeverityColumnId() + 1, 0, 100);
        panel.add((Component)severitySpinner);
        panel.add(new JLabel(IdeologBundle.message("category.capture.group", new Object[0])));
        this.myCategoryColumnId = categorySpinner = new JBIntSpinner(this.item.getCategoryColumnId() + 1, 0, 100);
        panel.add((Component)categorySpinner);
        return panel;
    }

    private final String getDatePreviewText(String format) {
        CharSequence charSequence;
        CharSequence charSequence2;
        try {
            charSequence2 = new SimpleDateFormat(format).format(new Date(629518620000L));
        }
        catch (Throwable throwable) {
            charSequence2 = "";
        }
        String parsedFormat = charSequence2;
        charSequence2 = parsedFormat;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "-";
        } else {
            charSequence = charSequence2;
        }
        return charSequence;
    }

    protected void doOKAction() {
        EditorTextField it;
        EditorTextField editorTextField = this.myNameText;
        if (editorTextField != null) {
            it = editorTextField;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.item.setName(string);
        }
        EditorTextField editorTextField2 = this.myParsingPatternText;
        if (editorTextField2 != null) {
            it = editorTextField2;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.item.setPattern(string);
        }
        EditorTextField editorTextField3 = this.myLineStartPatternText;
        if (editorTextField3 != null) {
            it = editorTextField3;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.item.setLineStartPattern(string);
        }
        EditorTextField editorTextField4 = this.myTimePatternText;
        if (editorTextField4 != null) {
            it = editorTextField4;
            boolean bl = false;
            String string = it.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.item.setTimePattern(string);
        }
        JBIntSpinner jBIntSpinner = this.myTimeColumnId;
        if (jBIntSpinner != null) {
            it = jBIntSpinner;
            boolean bl = false;
            this.item.setTimeColumnId(it.getNumber() - 1);
        }
        JBIntSpinner jBIntSpinner2 = this.mySeverityColumnId;
        if (jBIntSpinner2 != null) {
            it = jBIntSpinner2;
            boolean bl = false;
            this.item.setSeverityColumnId(it.getNumber() - 1);
        }
        JBIntSpinner jBIntSpinner3 = this.myCategoryColumnId;
        if (jBIntSpinner3 != null) {
            it = jBIntSpinner3;
            boolean bl = false;
            this.item.setCategoryColumnId(it.getNumber() - 1);
        }
        if (DefaultSettingsStoreItems.INSTANCE.getParsingPatternsUUIDs$intellij_ideolog().contains(this.item.getUuid())) {
            UUID uUID = UUID.randomUUID();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
            this.item.setUuid(uUID);
        }
        super.doOKAction();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        EditorTextField it;
        ArrayList<ValidationInfo> results = new ArrayList<ValidationInfo>();
        try {
            Pattern pattern;
            EditorTextField editorTextField = this.myParsingPatternText;
            if (editorTextField != null) {
                it = editorTextField;
                boolean bl = false;
                pattern = Pattern.compile(it.getText());
            } else {
                pattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            Serializable cfr_ignored_1 = Boolean.valueOf(results.add(new ValidationInfo(e.getLocalizedMessage(), (JComponent)this.myParsingPatternText)));
        }
        try {
            Pattern pattern;
            EditorTextField editorTextField = this.myLineStartPatternText;
            if (editorTextField != null) {
                it = editorTextField;
                boolean bl = false;
                pattern = Pattern.compile(it.getText());
            } else {
                pattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            Serializable cfr_ignored_3 = Boolean.valueOf(results.add(new ValidationInfo(e.getLocalizedMessage(), (JComponent)this.myLineStartPatternText)));
        }
        try {
            SimpleDateFormat simpleDateFormat;
            EditorTextField editorTextField = this.myTimePatternText;
            if (editorTextField != null) {
                it = editorTextField;
                boolean bl = false;
                simpleDateFormat = new SimpleDateFormat(it.getText());
            } else {
                simpleDateFormat = null;
            }
        }
        catch (IllegalArgumentException e) {
            Serializable cfr_ignored_5 = Boolean.valueOf(results.add(new ValidationInfo(e.getLocalizedMessage(), (JComponent)this.myTimePatternText)));
        }
        return results;
    }

    public static final /* synthetic */ String access$getDatePreviewText(LogParsingPatternSettingsDialog $this, String format) {
        return $this.getDatePreviewText(format);
    }
}

