/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting.settings;

import com.intellij.ideolog.highlighting.settings.LogColor;
import com.intellij.ideolog.highlighting.settings.LogColorConverter;
import com.intellij.ideolog.highlighting.settings.LogHighlightingAction;
import com.intellij.ideolog.highlighting.settings.UUIDConverter;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="LogHighlightingPattern")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000f\u001a\u00020\u0003\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014B\t\b\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0015J\b\u0010B\u001a\u00020\u0000H\u0016J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010E\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010F\u001a\u00020\tH\u00c6\u0003J\t\u0010G\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010H\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u0010I\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\t\u0010J\u001a\u00020\u0003H\u00c6\u0003J\t\u0010K\u001a\u00020\u0003H\u00c6\u0003J\t\u0010L\u001a\u00020\u0003H\u00c6\u0003J\t\u0010M\u001a\u00020\u0007H\u00c6\u0003J}\u0010N\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\b\u0002\u0010\u000f\u001a\u00020\u00032\b\b\u0002\u0010\u0010\u001a\u00020\u00032\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010O\u001a\u00020\u00032\b\u0010P\u001a\u0004\u0018\u00010QH\u00d6\u0003J\t\u0010R\u001a\u00020\tH\u00d6\u0001J\t\u0010S\u001a\u00020\u0005H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R \u0010\f\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R \u0010\u000e\u001a\u0004\u0018\u00010\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010+\"\u0004\b/\u0010-R\u001e\u0010\u000f\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0017\"\u0004\b1\u0010\u0019R\u001e\u0010\u0010\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u0017\"\u0004\b3\u0010\u0019R\u001e\u0010\u0011\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0017\"\u0004\b5\u0010\u0019R\u001e\u0010\u0012\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u001f\"\u0004\b7\u0010!R(\u0010:\u001a\u0004\u0018\u0001092\b\u00108\u001a\u0004\u0018\u0001098G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R(\u0010?\u001a\u0004\u0018\u0001092\b\u00108\u001a\u0004\u0018\u0001098G@GX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b@\u0010<\"\u0004\bA\u0010>\u00a8\u0006T"}, d2={"Lcom/intellij/ideolog/highlighting/settings/LogHighlightingPattern;", "", "enabled", "", "pattern", "", "formatId", "Ljava/util/UUID;", "captureGroup", "", "action", "Lcom/intellij/ideolog/highlighting/settings/LogHighlightingAction;", "fgRgb", "Lcom/intellij/ideolog/highlighting/settings/LogColor;", "bgRgb", "bold", "italic", "showOnStripe", "uuid", "<init>", "(ZLjava/lang/String;Ljava/util/UUID;ILcom/intellij/ideolog/highlighting/settings/LogHighlightingAction;Lcom/intellij/ideolog/highlighting/settings/LogColor;Lcom/intellij/ideolog/highlighting/settings/LogColor;ZZZLjava/util/UUID;)V", "()V", "getEnabled", "()Z", "setEnabled", "(Z)V", "getPattern", "()Ljava/lang/String;", "setPattern", "(Ljava/lang/String;)V", "getFormatId", "()Ljava/util/UUID;", "setFormatId", "(Ljava/util/UUID;)V", "getCaptureGroup", "()I", "setCaptureGroup", "(I)V", "getAction", "()Lcom/intellij/ideolog/highlighting/settings/LogHighlightingAction;", "setAction", "(Lcom/intellij/ideolog/highlighting/settings/LogHighlightingAction;)V", "getFgRgb", "()Lcom/intellij/ideolog/highlighting/settings/LogColor;", "setFgRgb", "(Lcom/intellij/ideolog/highlighting/settings/LogColor;)V", "getBgRgb", "setBgRgb", "getBold", "setBold", "getItalic", "setItalic", "getShowOnStripe", "setShowOnStripe", "getUuid", "setUuid", "value", "Ljava/awt/Color;", "foregroundColor", "getForegroundColor", "()Ljava/awt/Color;", "setForegroundColor", "(Ljava/awt/Color;)V", "backgroundColor", "getBackgroundColor", "setBackgroundColor", "clone", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "copy", "equals", "other", "", "hashCode", "toString", "intellij.ideolog"})
public final class LogHighlightingPattern
implements Cloneable {
    @Attribute(value="enabled")
    private boolean enabled;
    @Attribute(value="pattern")
    @NotNull
    private String pattern;
    @Attribute(value="formatId", converter=UUIDConverter.class)
    @Nullable
    private UUID formatId;
    @Attribute(value="captureGroup")
    private int captureGroup;
    @Attribute(value="action")
    @NotNull
    private LogHighlightingAction action;
    @Attribute(value="fg", converter=LogColorConverter.class)
    @Nullable
    private LogColor fgRgb;
    @Attribute(value="bg", converter=LogColorConverter.class)
    @Nullable
    private LogColor bgRgb;
    @Attribute(value="bold")
    private boolean bold;
    @Attribute(value="italic")
    private boolean italic;
    @Attribute(value="stripe")
    private boolean showOnStripe;
    @Attribute(value="uuid", converter=UUIDConverter.class)
    @NotNull
    private UUID uuid;

    public LogHighlightingPattern(boolean enabled, @Language(value="RegExp") @NotNull String pattern, @Nullable UUID formatId, int captureGroup, @NotNull LogHighlightingAction action, @Nullable LogColor fgRgb, @Nullable LogColor bgRgb, boolean bold, boolean italic, boolean showOnStripe, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.enabled = enabled;
        this.pattern = pattern;
        this.formatId = formatId;
        this.captureGroup = captureGroup;
        this.action = action;
        this.fgRgb = fgRgb;
        this.bgRgb = bgRgb;
        this.bold = bold;
        this.italic = italic;
        this.showOnStripe = showOnStripe;
        this.uuid = uuid;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @NotNull
    public final String getPattern() {
        return this.pattern;
    }

    public final void setPattern(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.pattern = string;
    }

    @Nullable
    public final UUID getFormatId() {
        return this.formatId;
    }

    public final void setFormatId(@Nullable UUID uUID) {
        this.formatId = uUID;
    }

    public final int getCaptureGroup() {
        return this.captureGroup;
    }

    public final void setCaptureGroup(int n) {
        this.captureGroup = n;
    }

    @NotNull
    public final LogHighlightingAction getAction() {
        return this.action;
    }

    public final void setAction(@NotNull LogHighlightingAction logHighlightingAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)logHighlightingAction), (String)"<set-?>");
        this.action = logHighlightingAction;
    }

    @Nullable
    public final LogColor getFgRgb() {
        return this.fgRgb;
    }

    public final void setFgRgb(@Nullable LogColor logColor) {
        this.fgRgb = logColor;
    }

    @Nullable
    public final LogColor getBgRgb() {
        return this.bgRgb;
    }

    public final void setBgRgb(@Nullable LogColor logColor) {
        this.bgRgb = logColor;
    }

    public final boolean getBold() {
        return this.bold;
    }

    public final void setBold(boolean bl) {
        this.bold = bl;
    }

    public final boolean getItalic() {
        return this.italic;
    }

    public final void setItalic(boolean bl) {
        this.italic = bl;
    }

    public final boolean getShowOnStripe() {
        return this.showOnStripe;
    }

    public final void setShowOnStripe(boolean bl) {
        this.showOnStripe = bl;
    }

    @NotNull
    public final UUID getUuid() {
        return this.uuid;
    }

    public final void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    public LogHighlightingPattern() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this(true, "", null, 0, LogHighlightingAction.HIGHLIGHT_FIELD, null, null, false, false, false, uUID);
    }

    @Transient
    @Nullable
    public final Color getForegroundColor() {
        LogColor logColor = this.fgRgb;
        return (Color)(logColor != null ? logColor.toJBColor() : null);
    }

    @Transient
    public final void setForegroundColor(@Nullable Color value) {
        LogColor logColor;
        if (this.fgRgb == null) {
            logColor = LogColor.Companion.fromColor(value);
        } else {
            LogColor logColor2 = this.fgRgb;
            logColor = logColor2 != null ? logColor2.updateWithColor(value) : null;
        }
        this.fgRgb = logColor;
    }

    @Transient
    @Nullable
    public final Color getBackgroundColor() {
        LogColor logColor = this.bgRgb;
        return (Color)(logColor != null ? logColor.toJBColor() : null);
    }

    @Transient
    public final void setBackgroundColor(@Nullable Color value) {
        LogColor logColor;
        if (this.bgRgb == null) {
            logColor = LogColor.Companion.fromColor(value);
        } else {
            LogColor logColor2 = this.bgRgb;
            logColor = logColor2 != null ? logColor2.updateWithColor(value) : null;
        }
        this.bgRgb = logColor;
    }

    @NotNull
    public LogHighlightingPattern clone() {
        return new LogHighlightingPattern(this.enabled, this.pattern, this.formatId, this.captureGroup, this.action, this.fgRgb, this.bgRgb, this.bold, this.italic, this.showOnStripe, this.uuid);
    }

    public final boolean component1() {
        return this.enabled;
    }

    @NotNull
    public final String component2() {
        return this.pattern;
    }

    @Nullable
    public final UUID component3() {
        return this.formatId;
    }

    public final int component4() {
        return this.captureGroup;
    }

    @NotNull
    public final LogHighlightingAction component5() {
        return this.action;
    }

    @Nullable
    public final LogColor component6() {
        return this.fgRgb;
    }

    @Nullable
    public final LogColor component7() {
        return this.bgRgb;
    }

    public final boolean component8() {
        return this.bold;
    }

    public final boolean component9() {
        return this.italic;
    }

    public final boolean component10() {
        return this.showOnStripe;
    }

    @NotNull
    public final UUID component11() {
        return this.uuid;
    }

    @NotNull
    public final LogHighlightingPattern copy(boolean enabled, @Language(value="RegExp") @NotNull String pattern, @Nullable UUID formatId, int captureGroup, @NotNull LogHighlightingAction action, @Nullable LogColor fgRgb, @Nullable LogColor bgRgb, boolean bold, boolean italic, boolean showOnStripe, @NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return new LogHighlightingPattern(enabled, pattern, formatId, captureGroup, action, fgRgb, bgRgb, bold, italic, showOnStripe, uuid);
    }

    public static /* synthetic */ LogHighlightingPattern copy$default(LogHighlightingPattern logHighlightingPattern, boolean bl, String string, UUID uUID, int n, LogHighlightingAction logHighlightingAction, LogColor logColor, LogColor logColor2, boolean bl2, boolean bl3, boolean bl4, UUID uUID2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = logHighlightingPattern.enabled;
        }
        if ((n2 & 2) != 0) {
            string = logHighlightingPattern.pattern;
        }
        if ((n2 & 4) != 0) {
            uUID = logHighlightingPattern.formatId;
        }
        if ((n2 & 8) != 0) {
            n = logHighlightingPattern.captureGroup;
        }
        if ((n2 & 0x10) != 0) {
            logHighlightingAction = logHighlightingPattern.action;
        }
        if ((n2 & 0x20) != 0) {
            logColor = logHighlightingPattern.fgRgb;
        }
        if ((n2 & 0x40) != 0) {
            logColor2 = logHighlightingPattern.bgRgb;
        }
        if ((n2 & 0x80) != 0) {
            bl2 = logHighlightingPattern.bold;
        }
        if ((n2 & 0x100) != 0) {
            bl3 = logHighlightingPattern.italic;
        }
        if ((n2 & 0x200) != 0) {
            bl4 = logHighlightingPattern.showOnStripe;
        }
        if ((n2 & 0x400) != 0) {
            uUID2 = logHighlightingPattern.uuid;
        }
        return logHighlightingPattern.copy(bl, string, uUID, n, logHighlightingAction, logColor, logColor2, bl2, bl3, bl4, uUID2);
    }

    @NotNull
    public String toString() {
        return "LogHighlightingPattern(enabled=" + this.enabled + ", pattern=" + this.pattern + ", formatId=" + this.formatId + ", captureGroup=" + this.captureGroup + ", action=" + this.action + ", fgRgb=" + this.fgRgb + ", bgRgb=" + this.bgRgb + ", bold=" + this.bold + ", italic=" + this.italic + ", showOnStripe=" + this.showOnStripe + ", uuid=" + this.uuid + ")";
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.enabled);
        result = result * 31 + this.pattern.hashCode();
        result = result * 31 + (this.formatId == null ? 0 : this.formatId.hashCode());
        result = result * 31 + Integer.hashCode(this.captureGroup);
        result = result * 31 + this.action.hashCode();
        result = result * 31 + (this.fgRgb == null ? 0 : this.fgRgb.hashCode());
        result = result * 31 + (this.bgRgb == null ? 0 : this.bgRgb.hashCode());
        result = result * 31 + Boolean.hashCode(this.bold);
        result = result * 31 + Boolean.hashCode(this.italic);
        result = result * 31 + Boolean.hashCode(this.showOnStripe);
        result = result * 31 + this.uuid.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogHighlightingPattern)) {
            return false;
        }
        LogHighlightingPattern logHighlightingPattern = (LogHighlightingPattern)other;
        if (this.enabled != logHighlightingPattern.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.pattern, (Object)logHighlightingPattern.pattern)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.formatId, (Object)logHighlightingPattern.formatId)) {
            return false;
        }
        if (this.captureGroup != logHighlightingPattern.captureGroup) {
            return false;
        }
        if (this.action != logHighlightingPattern.action) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fgRgb, (Object)logHighlightingPattern.fgRgb)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bgRgb, (Object)logHighlightingPattern.bgRgb)) {
            return false;
        }
        if (this.bold != logHighlightingPattern.bold) {
            return false;
        }
        if (this.italic != logHighlightingPattern.italic) {
            return false;
        }
        if (this.showOnStripe != logHighlightingPattern.showOnStripe) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.uuid, (Object)logHighlightingPattern.uuid);
    }
}

