/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.highlighting;

import com.intellij.ideolog.highlighting.LogParsingUtils;
import com.intellij.ideolog.lex.LogFileFormat;
import com.intellij.ideolog.lex.LogFileFormatsKt;
import com.intellij.ideolog.lex.LogToken;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.TrigramBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\"\u001a\u00020#J(\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u00112\u0016\u0010&\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001ej\b\u0012\u0004\u0012\u00020\u0005`\u001fH\u0002J\b\u0010'\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u000e\u0010\u001a\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0013R!\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u001ej\b\u0012\u0004\u0012\u00020\u0005`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006)"}, d2={"Lcom/intellij/ideolog/highlighting/LogEvent;", "", "rawText", "", "startOffset", "", "fileType", "Lcom/intellij/ideolog/lex/LogFileFormat;", "<init>", "(Ljava/lang/CharSequence;ILcom/intellij/ideolog/lex/LogFileFormat;)V", "getRawText", "()Ljava/lang/CharSequence;", "getStartOffset", "()I", "endOffset", "getEndOffset", "date", "", "getDate", "()Ljava/lang/String;", "rawLevel", "getRawLevel", "category", "getCategory", "message", "getMessage", "fullMessage", "level", "getLevel", "messageTrigrams", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "getMessageTrigrams", "()Ljava/util/HashSet;", "prepareTrigrams", "", "parseTrigrams", "text", "res", "toString", "Companion", "intellij.ideolog"})
@SourceDebugExtension(value={"SMAP\nLogEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogEvent.kt\ncom/intellij/ideolog/highlighting/LogEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n774#2:79\n865#2,2:80\n*S KotlinDebug\n*F\n+ 1 LogEvent.kt\ncom/intellij/ideolog/highlighting/LogEvent\n*L\n27#1:79\n27#1:80,2\n*E\n"})
public final class LogEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CharSequence rawText;
    private final int startOffset;
    private final int endOffset;
    @NotNull
    private final String date;
    @NotNull
    private final String rawLevel;
    @NotNull
    private final String category;
    @NotNull
    private final String message;
    @NotNull
    private final String fullMessage;
    @NotNull
    private final String level;
    @NotNull
    private final HashSet<Integer> messageTrigrams;

    /*
     * WARNING - void declaration
     */
    public LogEvent(@NotNull CharSequence rawText, int startOffset, @NotNull LogFileFormat fileType) {
        String string;
        Object object;
        Object object2;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)rawText, (String)"rawText");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.rawText = rawText;
        this.startOffset = startOffset;
        this.endOffset = this.startOffset + this.rawText.length();
        this.messageTrigrams = new HashSet();
        List tokens = new ArrayList();
        LogFileFormat.tokenize$default(fileType, this.rawText, tokens, false, 4, null);
        Iterable $this$filter$iv = tokens;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LogToken it = (LogToken)element$iv$iv;
            boolean bl = false;
            if (!(!it.isSeparator())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tokensFiltered = (List)destination$iv$iv;
        Object object3 = fileType.extractDate(tokensFiltered);
        if (object3 == null || (object3 = ((LogToken)object3).takeFrom(this.rawText)) == null || (object3 = StringsKt.trim((CharSequence)object3)) == null || (object3 = object3.toString()) == null) {
            object3 = this.date = "";
        }
        if ((object2 = fileType.extractSeverity(tokensFiltered)) == null || (object2 = ((LogToken)object2).takeFrom(this.rawText)) == null || (object2 = StringsKt.trim((CharSequence)object2)) == null || (object2 = object2.toString()) == null) {
            object2 = this.rawLevel = "";
        }
        if ((object = fileType.extractCategory(tokensFiltered)) == null || (object = ((LogToken)object).takeFrom(this.rawText)) == null || (object = StringsKt.trim((CharSequence)object)) == null || (object = object.toString()) == null) {
            object = "";
        }
        this.category = object;
        this.fullMessage = ((Object)StringsKt.trim((CharSequence)((Object)fileType.extractMessage(tokensFiltered).takeFrom(this.rawText)).toString())).toString();
        String string2 = this.rawLevel;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
        switch (string3) {
            case "E": {
                string = "ERROR";
                break;
            }
            case "W": {
                string = "WARN";
                break;
            }
            case "I": {
                string = "INFO";
                break;
            }
            case "V": {
                string = "VERBOSE";
                break;
            }
            case "D": {
                string = "DEBUG";
                break;
            }
            case "T": {
                string = "TRACE";
                break;
            }
            case "SEVERE": {
                string = "ERROR";
                break;
            }
            default: {
                string2 = this.rawLevel;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault(...)");
                String string4 = string2.toUpperCase(locale2);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toUpperCase(...)");
            }
        }
        this.level = string;
        Object object4 = new char[1];
        object4[0] = 10;
        this.message = ((Object)StringsKt.trim((CharSequence)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)this.fullMessage, (char[])object4, (boolean)false, (int)0, (int)6, null))))).toString();
    }

    @NotNull
    public final CharSequence getRawText() {
        return this.rawText;
    }

    public final int getStartOffset() {
        return this.startOffset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    @NotNull
    public final String getDate() {
        return this.date;
    }

    @NotNull
    public final String getRawLevel() {
        return this.rawLevel;
    }

    @NotNull
    public final String getCategory() {
        return this.category;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    @NotNull
    public final String getLevel() {
        return this.level;
    }

    @NotNull
    public final HashSet<Integer> getMessageTrigrams() {
        return this.messageTrigrams;
    }

    public final void prepareTrigrams() {
        this.parseTrigrams("\"" + this.message + "\"", this.messageTrigrams);
    }

    private final void parseTrigrams(String text, HashSet<Integer> res) {
        TrigramBuilder.processTrigrams((CharSequence)text, (TrigramBuilder.TrigramProcessor)new TrigramBuilder.TrigramProcessor(res){
            final /* synthetic */ HashSet<Integer> $res;
            {
                this.$res = $res;
            }

            public boolean consumeTrigramsCount(int count) {
                return true;
            }

            public boolean test(int value) {
                this.$res.add(value);
                return true;
            }
        });
    }

    @NotNull
    public String toString() {
        return "LogEvent(date=" + this.date + ", level=" + this.level + ", category=" + this.category + ", message=" + this.message + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/ideolog/highlighting/LogEvent$Companion;", "", "<init>", "()V", "fromEditor", "Lcom/intellij/ideolog/highlighting/LogEvent;", "e", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "intellij.ideolog"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogEvent fromEditor(@NotNull Editor e, int offset) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Pair<CharSequence, Integer> pair = LogParsingUtils.INSTANCE.getEvent(e, offset);
            CharSequence rawMessage = (CharSequence)pair.component1();
            int startOffset = ((Number)pair.component2()).intValue();
            return new LogEvent(rawMessage, startOffset, LogFileFormatsKt.detectLogFileFormat(e));
        }

        public static /* synthetic */ LogEvent fromEditor$default(Companion companion, Editor editor, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = editor.getCaretModel().getOffset();
            }
            return companion.fromEditor(editor, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

