/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ideolog.file;

import com.intellij.diagnostic.VMOptions;
import com.intellij.ideolog.IdeologBundle;
import com.intellij.ideolog.file.LogFileEditor;
import com.intellij.ideolog.file.LogFileFormatNotificationProviderKt;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import java.util.Locale;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0006\u001a\u0014\u0012\u0006\b\u0000\u0012\u00020\b\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ideolog/file/LogLargeFileNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "dontShowAgain", "", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.ideolog"})
public final class LogLargeFileNotificationProvider
implements EditorNotificationProvider {
    private boolean dontShowAgain;

    @NotNull
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return arg_0 -> LogLargeFileNotificationProvider.collectNotificationData$lambda$4(this, file, project, arg_0);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$0(VirtualFile $file, Project $project) {
        VMOptions.setOption((String)"idea.max.content.load.filesize", (String)"1000000");
        VMOptions.setOption((String)"idea.max.content.load.large.preview.size", (String)"1000000");
        VMOptions.setOption((String)"idea.max.intellisense.filesize", (String)"1000000");
        LogFileFormatNotificationProviderKt.update($file, $project);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$1(Editor $editor, VirtualFile $file, Project $project) {
        $editor.putUserData(LogFileFormatNotificationProviderKt.getHIDDEN_KEY(), (Object)"true");
        LogFileFormatNotificationProviderKt.update($file, $project);
    }

    private static final void collectNotificationData$lambda$4$lambda$3$lambda$2(LogLargeFileNotificationProvider this$0, VirtualFile $file, Project $project) {
        this$0.dontShowAgain = true;
        LogFileFormatNotificationProviderKt.update($file, $project);
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$4(LogLargeFileNotificationProvider this$0, VirtualFile $file, Project $project, FileEditor it) {
        EditorNotificationPanel editorNotificationPanel;
        boolean isSupported;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!(it instanceof LogFileEditor)) {
            return null;
        }
        Editor editor = ((TextEditor)it).getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        String string = ApplicationNamesInfo.getInstance().getProductName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProductName(...)");
        String string2 = string;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String productName = string3;
        String versionName = ApplicationInfo.getInstance().getMajorVersion();
        boolean bl = isSupported = Intrinsics.areEqual((Object)productName, (Object)"rider") && versionName.compareTo("2018") >= 0;
        if (editor2.getUserData(LogFileFormatNotificationProviderKt.getHIDDEN_KEY()) != null || this$0.dontShowAgain || !VirtualFileUtil.isTooLarge((VirtualFile)$file) || !isSupported) {
            return null;
        }
        EditorNotificationPanel $this$collectNotificationData_u24lambda_u244_u24lambda_u243 = editorNotificationPanel = new EditorNotificationPanel();
        boolean bl2 = false;
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(IdeologBundle.message("link.label.increase.limits.to.1gb", new Object[0]), () -> LogLargeFileNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$0($file, $project));
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(IdeologBundle.message("link.label.hide.notification", new Object[0]), () -> LogLargeFileNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$1(editor2, $file, $project));
        $this$collectNotificationData_u24lambda_u244_u24lambda_u243.createActionLabel(IdeologBundle.message("link.label.don.t.show.again", new Object[0]), () -> LogLargeFileNotificationProvider.collectNotificationData$lambda$4$lambda$3$lambda$2(this$0, $file, $project));
        EditorNotificationPanel panel = editorNotificationPanel;
        return panel.text(IdeologBundle.message("label.file.content.truncated.please.increase.limits", new Object[0]));
    }
}

