/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.php.performanceTesting;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodSettings;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PhpExtractMethodCommand
extends AbstractCommand {
    public static final String PREFIX = "%phpExtractMethod";

    public PhpExtractMethodCommand(@NotNull String text, int line) {
        if (text == null) {
            PhpExtractMethodCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            PhpExtractMethodCommand.$$$reportNull$$$0(1);
        }
        Project project = context.getProject();
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$_execute$0(project, (ActionCallback)actionCallback));
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            PhpExtractMethodCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private /* synthetic */ void lambda$_execute$0(final Project project, ActionCallback actionCallback) {
        final Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile != null) {
                final int errorsBefore = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)project).size();
                new ExtractMethodConfigurator(project).invoke(project, editor, psiFile, false);
                final Disposable listenerDisposable = Disposer.newDisposable();
                MessageBusConnection busConnection = project.getMessageBus().connect(listenerDisposable);
                busConnection.subscribe(DaemonCodeAnalyzer.DAEMON_EVENT_TOPIC, (Object)new DaemonCodeAnalyzer.DaemonListener(){

                    public void daemonFinished() {
                        int errorsAfter = DaemonCodeAnalyzerImpl.getHighlights((Document)editor.getDocument(), (HighlightSeverity)HighlightSeverity.ERROR, (Project)project).size();
                        if (errorsBefore > errorsAfter) {
                            throw new RuntimeException("Errors are found after refactoring");
                        }
                        Disposer.dispose((Disposable)listenerDisposable);
                    }
                });
                actionCallback.setDone();
            } else {
                actionCallback.reject("PSI file is null");
            }
        } else {
            actionCallback.reject("Editor is null");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class ExtractMethodConfigurator
    extends PhpExtractMethodHandler {
        private final Project myProject;

        private ExtractMethodConfigurator(Project project) {
            this.myProject = project;
        }

        @Override
        protected PhpExtractMethodSettings getSettings(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
            if (fragment == null) {
                ExtractMethodConfigurator.$$$reportNull$$$0(0);
            }
            if (inputVariables == null) {
                ExtractMethodConfigurator.$$$reportNull$$$0(1);
            }
            if (outputVariables == null) {
                ExtractMethodConfigurator.$$$reportNull$$$0(2);
            }
            return ExtractMethodConfigurator.getSettingsForBatchMode(this.myProject, Collections.singleton("dummy"), false, fragment, inputVariables, outputVariables);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fragment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inputVariables";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputVariables";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/php/performanceTesting/PhpExtractMethodCommand$ExtractMethodConfigurator";
            objectArray[2] = "getSettings";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

