/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.smarty;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.UriUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.smarty.lang.SmartyIncludeTag;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SmartyFileReferenceSet
extends FileReferenceSet {
    private final SmartyIncludeTag myIncludeElement;

    public SmartyFileReferenceSet(@NotNull SmartyIncludeTag element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            SmartyFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(UriUtil.trimLeadingSlashes((String)FileUtil.toSystemIndependentName((String)element.getFileName())), (PsiElement)element, element.getTextOffset() - element.getTextRange().getStartOffset(), provider, true);
        this.myIncludeElement = element;
    }

    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        if (this.isAbsolutePathReference()) {
            Collection collection = this.toFileSystemItems(ManagingFS.getInstance().getLocalRoots());
            if (collection == null) {
                SmartyFileReferenceSet.$$$reportNull$$$0(1);
            }
            return collection;
        }
        VirtualFile file = this.getElement().getContainingFile().getOriginalFile().getVirtualFile().getParent();
        if (file == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                SmartyFileReferenceSet.$$$reportNull$$$0(2);
            }
            return list;
        }
        Collection collection = this.toFileSystemItems(new VirtualFile[]{file});
        if (collection == null) {
            SmartyFileReferenceSet.$$$reportNull$$$0(3);
        }
        return collection;
    }

    public boolean isAbsolutePathReference() {
        if (super.isAbsolutePathReference()) {
            return true;
        }
        String pathString = this.myIncludeElement.getFileName();
        return SmartyFileReferenceSet.isAbsolutePathAllowFileProtocol(pathString);
    }

    public static boolean isAbsolutePathAllowFileProtocol(@Nullable String pathString) {
        if (pathString == null) {
            return false;
        }
        if (!((pathString = StringUtil.trimStart((String)pathString, (String)"file://")).isEmpty() || pathString.charAt(0) != '/' && pathString.charAt(0) != '\\')) {
            return true;
        }
        return FileUtil.isAbsolute((String)pathString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/smarty/SmartyFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/smarty/SmartyFileReferenceSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDefaultContexts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

