/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.util.connection;

import com.intellij.execution.ExecutionException;
import com.intellij.util.ThrowableRunnable;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.util.connection.PhpDebugConnectionException;
import com.jetbrains.php.util.connection.PhpDebugSocketDescriptor;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionsSocket;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpIncomingDebugConnectionsServerSocket
implements PhpIncomingDebugConnectionsSocket {
    private static final String LOCALHOST = "127.0.0.1";
    private ServerSocket myServerSocket;

    @Override
    public ThrowableRunnable<PhpDebugConnectionException> openConnection(int port) throws ExecutionException {
        try {
            this.myServerSocket = new ServerSocket(port);
        }
        catch (Exception e) {
            throw new ExecutionException(PhpBundle.message("connection.port.is.busy", String.valueOf(port)));
        }
        return EMPTY_INIT;
    }

    @Override
    public Socket waitForDebugSessionConnection() throws IOException {
        return this.myServerSocket.accept();
    }

    @Override
    @NotNull
    public PhpDebugSocketDescriptor getDescriptor() {
        int port = this.myServerSocket == null ? -1 : this.myServerSocket.getLocalPort();
        return new PhpDebugSocketDescriptor("", LOCALHOST, port);
    }

    @Override
    @NotNull
    @Nls
    public String getPresentableName() {
        String string = PhpBundle.message("xdebug.initializing.connection.debugger", new Object[0]);
        if (string == null) {
            PhpIncomingDebugConnectionsServerSocket.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public boolean isConnectionOpened() {
        return this.myServerSocket != null;
    }

    @Override
    public ThrowableRunnable<PhpDebugConnectionException> closeConnection() {
        ServerSocket serverSocket = this.myServerSocket;
        this.myServerSocket = null;
        return () -> {
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                throw new PhpDebugConnectionException(e.getMessage(), e);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/util/connection/PhpIncomingDebugConnectionsServerSocket", "getPresentableName"));
    }
}

