/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.uml;

import com.intellij.diagram.DiagramVfsResolver;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.uml.PhpUmlUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUmlVfsResolver
implements DiagramVfsResolver<PsiElement> {
    public String getQualifiedName(@Nullable PsiElement element) {
        return element != null ? PhpUmlUtil.getFQN(element) : null;
    }

    @Nullable
    public PsiElement resolveElementByFQN(@NotNull String fqn, @NotNull Project project) {
        if (fqn == null) {
            PhpUmlVfsResolver.$$$reportNull$$$0(0);
        }
        if (project == null) {
            PhpUmlVfsResolver.$$$reportNull$$$0(1);
        }
        return (PsiElement)ReadAction.compute(() -> {
            VirtualFile byPath;
            PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
            if (DumbService.isDumb((Project)project)) {
                return null;
            }
            Collection classesByFQN = phpIndex.getClassesByFQN(fqn);
            if (!classesByFQN.isEmpty()) {
                return (PsiNamedElement)classesByFQN.iterator().next();
            }
            Collection interfacesByFQN = phpIndex.getInterfacesByFQN(fqn);
            if (!interfacesByFQN.isEmpty()) {
                return (PsiNamedElement)interfacesByFQN.iterator().next();
            }
            VirtualFile virtualFile = byPath = ApplicationManager.getApplication().isUnitTestMode() ? TempFileSystem.getInstance().findFileByPath(fqn) : LocalFileSystem.getInstance().findFileByPath(fqn);
            if (byPath != null) {
                return PsiManager.getInstance((Project)project).findDirectory(byPath);
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fqn";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/uml/PhpUmlVfsResolver";
        objectArray[2] = "resolveElementByFQN";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

