/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.phpcs;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.ui.HideableDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpInvalidSdkTypeException;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolCustomSettings;
import com.jetbrains.php.tools.quality.QualityToolProcessCreator;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfigurableForm;
import com.jetbrains.php.tools.quality.phpcs.PhpCSConfiguration;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCSCustomOptionsForm
extends QualityToolCustomSettings {
    private final Project myProject;
    private final PhpCSConfiguration myConfiguration;
    private TextFieldWithBrowseButton myBeautifierPathField;
    private JPanel myPhpcsbfPanel;
    private JPanel myTopPanel;

    public PhpCSCustomOptionsForm(@NotNull Project project, PhpCSConfiguration configuration) {
        if (project == null) {
            PhpCSCustomOptionsForm.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withFileFilter(file -> PhpCSCustomOptionsForm.isValidBeautifierTool(file.getPath())).withTitle(PhpBundle.message("quality.tool.phpcbf.location", new Object[0])).withDescription(PhpBundle.message("quality.tool.phpcbf.location.descr", new Object[0]));
        if (configuration.isLocal()) {
            this.myBeautifierPathField.addBrowseFolderListener(null, descriptor);
        } else {
            PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
            assert (manager != null);
            try {
                PhpSdkAdditionalData data = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreterDataById(this.myConfiguration.getInterpreterId());
                if (data instanceof RemoteSdkAdditionalData) {
                    this.myBeautifierPathField.addActionListener(manager.createRemoteBrowserAction(this.myProject, data, "Select path", this.myBeautifierPathField.getTextField(), false));
                } else {
                    this.myBeautifierPathField.addBrowseFolderListener(null, descriptor);
                }
            }
            catch (PhpInvalidSdkTypeException e) {
                this.myBeautifierPathField.getButton().setVisible(false);
            }
        }
        HideableDecorator decorator = new HideableDecorator(this.myTopPanel, PhpBundle.message("quality.tool.phpcbf.settings", new Object[0]), false);
        decorator.setContentComponent((JComponent)this.myPhpcsbfPanel);
        decorator.setOn(!StringUtil.isEmpty((String)this.myConfiguration.getPhpCodeBeautifierPath()));
    }

    private static boolean isValidBeautifierTool(String path) {
        String fileName = PathUtil.getFileName((String)path);
        return fileName.equals("phpcbf") || fileName.equals("phpcbf.bat");
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return PhpBundle.message("quality.tool.phpcbf.settings", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        return this.myTopPanel;
    }

    public boolean isModified() {
        return !this.myConfiguration.getPhpCodeBeautifierPath().equals(this.myBeautifierPathField.getText());
    }

    public void reset() {
        this.myBeautifierPathField.setText(this.myConfiguration.getPhpCodeBeautifierPath());
    }

    public void apply() throws ConfigurationException {
        this.myConfiguration.setPhpCodeBeautifierPath(this.myBeautifierPathField.getText());
    }

    @Override
    @NotNull
    public Pair<Boolean, String> validate() {
        Pair<Boolean, String> pair;
        String path = this.myBeautifierPathField.getText();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            Pair pair2 = Pair.create((Object)true, (Object)"");
            if (pair2 == null) {
                PhpCSCustomOptionsForm.$$$reportNull$$$0(1);
            }
            return pair2;
        }
        if (!PhpCSCustomOptionsForm.isValidBeautifierTool(path)) {
            Pair pair3 = Pair.create((Object)false, (Object)PhpBundle.message("quality.tool.selected.file.is.not.phpcbf", new Object[0]));
            if (pair3 == null) {
                PhpCSCustomOptionsForm.$$$reportNull$$$0(2);
            }
            return pair3;
        }
        try {
            ProcessOutput output = QualityToolProcessCreator.getToolOutput(this.myProject, this.myConfiguration.getInterpreterId(), path, this.myConfiguration.getTimeout(), PhpBundle.message("validating1", new Object[0]), this.myTopPanel, "--version");
            String stdout = output.getStdout();
            pair = PhpCSConfigurableForm.doValidation(StringUtil.isEmpty((String)stdout) ? output.getStderr() : stdout);
        }
        catch (ExecutionException e) {
            Pair pair4 = Pair.create((Object)false, (Object)e.getMessage());
            if (pair4 == null) {
                PhpCSCustomOptionsForm.$$$reportNull$$$0(4);
            }
            return pair4;
        }
        if (pair == null) {
            PhpCSCustomOptionsForm.$$$reportNull$$$0(3);
        }
        return pair;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JPanel jPanel2;
        this.myTopPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        this.myPhpcsbfPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(5, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 7, 7, null, null, null, 0, true));
        this.myBeautifierPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpCSCustomOptionsForm.class).getString("quality.tool.phpcbf.path"));
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myTopPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/phpcs/PhpCSCustomOptionsForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/phpcs/PhpCSCustomOptionsForm";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

