/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualityToolsIgnoreFilesConfigurable
implements SearchableConfigurable {
    private final QualityToolBlackList myBlackList;
    private final QualityToolType<?> myQualityToolType;
    @NotNull
    private final Project myProject;
    private JPanel myIgnoreFilesPanel;
    private JPanel myBlackListToolbarPanel;
    private JBTable myBlackListTable;
    private final BlackListTableModel myBlackListTableModel;

    public QualityToolsIgnoreFilesConfigurable(@NotNull QualityToolType<?> qualityToolType, final @NotNull Project project) {
        if (qualityToolType == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(0);
        }
        if (project == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myBlackList = qualityToolType.getQualityToolBlackList(project);
        this.myQualityToolType = qualityToolType;
        this.myProject = project;
        this.myIgnoreFilesPanel.setMinimumSize(new Dimension(500, 500));
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(new AnAction(PhpBundle.message("action.add.file.s.to.list.text", new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel != null) {
                    QualityToolsIgnoreFilesConfigurable.this.doChooseFiles(project, (Consumer<? super List<VirtualFile>>)((Consumer)QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel::addAll));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$1", "actionPerformed"));
            }
        });
        group.add((AnAction)new DumbAwareAction(PhpBundle.message("quality.tool.action.remove.file.s.from.list.text", new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                QualityToolsIgnoreFilesConfigurable.this.removeSelectedFilesFromBlackList();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(QualityToolsIgnoreFilesConfigurable.this.myBlackListTable.getSelectedRows().length > 0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
                if (actionUpdateThread == null) {
                    2.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$2";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        });
        group.add(new AnAction(PhpBundle.message("quality.tool.action.clean.list.text", new Object[0]), null, AllIcons.Actions.Cancel){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel != null) {
                    QualityToolsIgnoreFilesConfigurable.this.myBlackListTableModel.clear();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$3", "actionPerformed"));
            }
        });
        this.myBlackListToolbarPanel.add((Component)ActionManager.getInstance().createActionToolbar("PhpQualityToolProjectConfigurable", (ActionGroup)group, true).getComponent(), "Center");
        this.myBlackListTableModel = this.createTableModel();
        this.myBlackListTable.setModel((TableModel)this.myBlackListTableModel);
        this.myIgnoreFilesPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpBundle.message("quality.tool.border.title.ignored.files", new Object[0])));
    }

    private void removeSelectedFilesFromBlackList() {
        if (this.myBlackListTableModel != null) {
            this.myBlackListTableModel.removeAll(this.myBlackListTable.getSelectedRows());
        }
    }

    private void doChooseFiles(@NotNull Project project, @NotNull Consumer<? super List<VirtualFile>> consumer) {
        if (project == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(3);
        }
        FileChooser.chooseFiles((FileChooserDescriptor)new FileChooserDescriptor(true, false, false, false, false, true), (Project)project, (Component)this.myIgnoreFilesPanel.getParent(), (VirtualFile)project.getBaseDir(), consumer);
    }

    public void apply() throws ConfigurationException {
        if (this.myBlackListTableModel != null) {
            this.myBlackListTableModel.commit();
        }
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    @Nullable
    public JComponent createComponent() {
        return this.myIgnoreFilesPanel;
    }

    public boolean isModified() {
        return this.myBlackListTableModel != null && this.myBlackListTableModel.isModified();
    }

    public void reset() {
        if (this.myBlackListTableModel != null) {
            this.myBlackListTableModel.reset();
        }
    }

    public void selectFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(4);
        }
        int index = 0;
        for (VirtualFile file : this.myBlackListTableModel.getEditableFileList()) {
            if (files.contains(file)) {
                this.myBlackListTable.addRowSelectionInterval(index, index);
            }
            ++index;
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return PhpBundle.message("quality.tool.ignored.files", this.myQualityToolType.getDisplayName());
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.getClass()) + this.myQualityToolType.getDisplayName();
        if (string == null) {
            QualityToolsIgnoreFilesConfigurable.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public BlackListTableModel createTableModel() {
        return new BlackListTableModel(this.myBlackList);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myIgnoreFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, new Dimension(500, 500), new Dimension(500, 500), null));
        this.myBlackListToolbarPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 1, 1, 7, 0, new Dimension(500, -1), new Dimension(500, -1), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, new Dimension(500, 500), new Dimension(500, 500), null));
        this.myBlackListTable = jBTable = new JBTable();
        jBScrollPane.setViewportView((Component)jBTable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualityToolType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doChooseFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectFiles";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class BlackListTableModel
    extends AbstractTableModel {
        private final List<VirtualFile> myFiles;
        private final QualityToolBlackList myBlackList;
        private final List<VirtualFile> myEditableFileList;
        private boolean myModifiedFlag;

        public BlackListTableModel(@NotNull QualityToolBlackList blackList) {
            if (blackList == null) {
                BlackListTableModel.$$$reportNull$$$0(0);
            }
            this.myEditableFileList = new ArrayList<VirtualFile>();
            this.myModifiedFlag = false;
            this.myBlackList = blackList;
            this.myFiles = new ArrayList<VirtualFile>(blackList.getFiles());
            this.myEditableFileList.addAll(blackList.getFiles());
        }

        @Override
        public int getRowCount() {
            return this.myEditableFileList.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return switch (columnIndex) {
                case 0 -> this.myEditableFileList.get(rowIndex).getPresentableName();
                case 1 -> this.myEditableFileList.get(rowIndex).getPath();
                default -> null;
            };
        }

        @Override
        public String getColumnName(int column) {
            return switch (column) {
                case 0 -> PhpBundle.message("name", new Object[0]);
                case 1 -> PhpBundle.message("include.path.column.info", new Object[0]);
                default -> null;
            };
        }

        public void reset() {
            this.myEditableFileList.clear();
            this.myEditableFileList.addAll(this.myFiles);
            this.myModifiedFlag = false;
            this.fireTableDataChanged();
        }

        public void commit() {
            this.myFiles.clear();
            this.myFiles.addAll(this.myEditableFileList);
            this.myBlackList.clear();
            this.myFiles.forEach(this.myBlackList::addFile);
            this.myModifiedFlag = false;
        }

        public boolean isModified() {
            return this.myModifiedFlag;
        }

        public void removeAll(int[] indices) {
            if (indices == null || indices.length == 0) {
                return;
            }
            ArrayList<VirtualFile> toRemove = new ArrayList<VirtualFile>();
            for (int i : indices) {
                toRemove.add(this.myEditableFileList.get(i));
            }
            this.myEditableFileList.removeAll(toRemove);
            this.myModifiedFlag = true;
            this.fireTableDataChanged();
        }

        public void addAll(List<VirtualFile> files) {
            this.myEditableFileList.addAll(ContainerUtil.filter(files, file -> !this.myEditableFileList.contains(file)));
            this.myModifiedFlag = true;
            this.fireTableDataChanged();
        }

        public void clear() {
            this.myEditableFileList.clear();
            this.myModifiedFlag = true;
            this.fireTableDataChanged();
        }

        public List<VirtualFile> getEditableFileList() {
            return this.myEditableFileList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blackList", "com/jetbrains/php/tools/quality/QualityToolsIgnoreFilesConfigurable$BlackListTableModel", "<init>"));
        }
    }
}

