/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.interpreters.PhpSdkFileTransfer;
import com.jetbrains.php.debug.xdebug.XdebugUtil;
import com.jetbrains.php.run.PhpConfigurationOption;
import com.jetbrains.php.run.PhpExecutionUtil;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.tools.quality.QualityToolAnnotatorInfo;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolMessageProcessor;
import com.jetbrains.php.tools.quality.QualityToolProcessHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class QualityToolProcessCreator {
    private static final Logger LOG = Logger.getInstance(QualityToolProcessCreator.class);
    static final ExecutorService QUALITY_TOOL_EXECUTOR = Executors.newFixedThreadPool(5, ConcurrencyUtil.newNamedThreadFactory((String)"PHP tool executor"));
    static final int FIFTEEN_MINUTES = 900000;
    public static final Key<? super Boolean> NO_PTY = Key.create((String)"NO_PTY");

    @NotNull
    public static ProcessOutput getToolOutput(@NotNull Project project, @Nullable String interpreterId, @NotNull String path, int timeout, @NlsContexts.ProgressTitle @NotNull String title, @Nullable JComponent component, String ... params) throws com.intellij.execution.ExecutionException {
        PhpCommandSettings command;
        String validate;
        if (project == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(0);
        }
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(1);
        }
        if (title == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(2);
        }
        if (params == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(3);
        }
        if (!TrustedProjects.isProjectTrusted((Project)project)) {
            throw new com.intellij.execution.ExecutionException(PhpBundle.message("dialog.message.execution.quality.tools.in.untrusted.project.prohibited", new Object[0]));
        }
        PhpSdkAdditionalData data = StringUtil.isNotEmpty((String)interpreterId) ? PhpInterpretersManagerImpl.getInstance(project).findInterpreterDataById(interpreterId) : null;
        String string = validate = data != null ? data.validate(project, null) : null;
        if (StringUtil.isNotEmpty((String)validate)) {
            throw new com.intellij.execution.ExecutionException(validate);
        }
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        if (interpreter == null || !path.contains("\\")) {
            command = PhpCommandSettings.createHelperCommand(project, path, PhpCommandLinePathProcessor.IDENTICAL, data);
        } else {
            command = PhpCommandSettings.createHelperCommand(project, Objects.requireNonNull(interpreter.getPathToPhpExecutable()), PhpCommandLinePathProcessor.IDENTICAL, data);
            command.addPathArgument(path);
            QualityToolProcessCreator.disableXDebugOptions(project, interpreter, command);
        }
        command.addEnv("XDEBUG_MODE", "off");
        Arrays.stream(params).forEach(command::addArgument);
        QualityToolProcessCreator.logProcessStart(path, "", params);
        ProcessOutput processOutput = PhpExecutionUtil.getProcessOutput(project, data, command.createGeneralCommandLine(), title, component, timeout);
        if (processOutput == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(4);
        }
        return processOutput;
    }

    static void disableXDebugOptions(@NotNull Project project, PhpInterpreter interpreter, PhpCommandSettings command) {
        List<String> xDebugOptions;
        if (project == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(5);
        }
        if (!(xDebugOptions = QualityToolProcessCreator.getXDebugOptions(interpreter, project)).isEmpty()) {
            command.addConfigurationOptions(ContainerUtil.map(xDebugOptions, i -> {
                String s = StringUtil.substringAfter((String)i, (String)"-d");
                assert (s != null);
                String[] split = s.split("=");
                assert (split.length == 2);
                return new PhpConfigurationOption(split[0], split[1]);
            }));
        }
    }

    public static void runToolProcess(@Nullable Project project, @Nullable String interpreterId, @NotNull String path, int timeout, @Nullable QualityToolBlackList blackList, @NotNull QualityToolMessageProcessor messageProcessor, @Nullable String workingDirectory, @Nullable VirtualFile originalFile, @Nullable PhpSdkFileTransfer transfer, @Nullable Map<String, String> environment, boolean isOnFly, String ... params) throws com.intellij.execution.ExecutionException {
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(6);
        }
        if (messageProcessor == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(7);
        }
        if (project != null && !TrustedProjects.isProjectTrusted((Project)project)) {
            LOG.info("Quality tools can't be run in untrusted project");
            return;
        }
        if (!ApplicationManager.getApplication().isActive()) {
            LOG.info("Don't run quality tools for background project");
            return;
        }
        Project activeProject = ProjectUtil.getActiveProject();
        if (activeProject != null && !activeProject.equals(project)) {
            LOG.info("Don't run quality tools for second project");
            return;
        }
        if (blackList != null && originalFile != null && blackList.containsFile(originalFile)) {
            return;
        }
        FileDocumentManager instance = FileDocumentManager.getInstance();
        if (originalFile != null) {
            ApplicationEx ex = ApplicationManagerEx.getApplicationEx();
            if (!isOnFly && instance.isFileModified(originalFile) && ex.isSaveAllowed()) {
                Document document = (Document)ReadAction.compute(() -> instance.getDocument(originalFile));
                ex.invokeAndWait(() -> instance.saveDocument(document));
            }
        }
        try {
            ProcessHandler handler = QUALITY_TOOL_EXECUTOR.submit(() -> {
                ProcessHandler handler1 = QualityToolProcessCreator.createProcessHandler(project, path, interpreterId, messageProcessor, workingDirectory, transfer, environment, params);
                handler1.startNotify();
                handler1.waitFor((long)timeout);
                return handler1;
            }).get(timeout, TimeUnit.MILLISECONDS);
            if (!handler.isProcessTerminated()) {
                handler.destroyProcess();
                messageProcessor.addInternalMessage(1, QualityToolProcessCreator.getHangupMessage(path, timeout, params), QualityToolMessageProcessor.ErrorMessageType.TIMEOUT);
            }
        }
        catch (TimeoutException e) {
            throw new com.intellij.execution.ExecutionException(StringUtil.isEmpty((String)e.getMessage()) ? PhpBundle.message("no.response.from.0.after.1.ms", path, timeout) : e.getMessage());
        }
        catch (InterruptedException | ExecutionException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
    }

    public static void runToolProcess(@NotNull QualityToolAnnotatorInfo info, @Nullable QualityToolBlackList blackList, @NotNull QualityToolMessageProcessor messageProcessor, @Nullable String workingDirectory, @Nullable PhpSdkFileTransfer transfer, @Nullable Map<String, String> environment, List<String> params) throws com.intellij.execution.ExecutionException {
        if (info == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(8);
        }
        if (messageProcessor == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(9);
        }
        QualityToolProcessCreator.runToolProcess(info.getProject(), info.getInterpreterId(), info.getToolPath(), info.isOnTheFly() ? info.getTimeout() : 900000, blackList, messageProcessor, workingDirectory, info.getOriginalFile(), transfer, environment, info.isOnTheFly(), ArrayUtilRt.toStringArray(params));
    }

    public static ProcessHandler createProcessHandler(@Nullable Project project, @NotNull String path, @Nullable String interpreterId, @NotNull QualityToolMessageProcessor messageProcessor, @Nullable String workingDirectory, @Nullable PhpSdkFileTransfer transfer, Map<String, String> environment, String ... params) throws com.intellij.execution.ExecutionException {
        if (path == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(10);
        }
        if (messageProcessor == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(11);
        }
        if (project != null && StringUtil.isNotEmpty((String)interpreterId)) {
            String executable;
            PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
            if (interpreter == null) {
                throw new com.intellij.execution.ExecutionException(PhpBundle.message("can.not.find.specified.interpreter", new Object[0]));
            }
            if (interpreter.isRemote()) {
                PhpCommandSettings command;
                PhpRemoteInterpreterManager manager = PhpRemoteInterpreterManager.getInstance();
                if (manager == null) {
                    throw new com.intellij.execution.ExecutionException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
                }
                PhpSdkAdditionalData data = interpreter.getPhpSdkAdditionalData();
                String validate = data.validate(project, null);
                if (StringUtil.isNotEmpty((String)validate)) {
                    throw new com.intellij.execution.ExecutionException(validate);
                }
                String executable2 = interpreter.getPathToPhpExecutable();
                if (executable2 != null && path.contains("\\")) {
                    command = PhpCommandSettingsBuilder.create(executable2, manager.createPathMapper(project, data), data);
                    command.setScript(path);
                    QualityToolProcessCreator.disableXDebugOptions(project, interpreter, command);
                } else {
                    command = PhpCommandSettingsBuilder.create(path, manager.createPathMapper(project, data), data);
                }
                for (String param : params) {
                    if (StringUtil.isEmpty((String)param)) continue;
                    command.addPathArgument(param);
                }
                if (StringUtil.isNotEmpty((String)workingDirectory)) {
                    command.setWorkingDir(workingDirectory);
                }
                if (transfer != null) {
                    transfer.updateCommand(command);
                }
                QualityToolProcessCreator.logProcessStart("", command.getWorkingDirectory(), ArrayUtil.toStringArray(command.getArguments()));
                GeneralCommandLine commandLine = command.createGeneralCommandLine();
                commandLine.withEnvironment(environment);
                commandLine.putUserData(NO_PTY, (Object)true);
                return manager.getRemoteToolProcessHandler(project, messageProcessor, data, commandLine, command.getAdditionalMappings());
            }
            GeneralCommandLine cl = new GeneralCommandLine();
            if (StringUtil.isNotEmpty((String)workingDirectory)) {
                cl.setWorkDirectory(workingDirectory);
            }
            if ((executable = interpreter.getPathToPhpExecutable()) != null) {
                cl.setExePath(executable);
                List<String> xDebugOptions = QualityToolProcessCreator.getXDebugOptions(interpreter, project);
                if (!xDebugOptions.isEmpty()) {
                    cl.addParameters(xDebugOptions);
                }
                cl.addParameter(path);
                cl.addParameters(params);
                cl.withEnvironment(environment);
                QualityToolProcessCreator.logProcessStart(path, workingDirectory, params);
                return new QualityToolProcessHandler(cl, messageProcessor);
            }
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        if (StringUtil.isNotEmpty((String)workingDirectory)) {
            cl.setWorkDirectory(workingDirectory);
        }
        cl.setExePath(path);
        cl.addParameters(params);
        cl.withEnvironment(environment);
        QualityToolProcessCreator.logProcessStart(path, workingDirectory, params);
        return new QualityToolProcessHandler(cl, messageProcessor);
    }

    private static List<String> getXDebugOptions(PhpInterpreter interpreter, @NotNull Project project) {
        if (project == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(12);
        }
        return XdebugUtil.getXDebugVersion(interpreter, project).getDisableSettings();
    }

    public static void logProcessStart(String path, String workingDir, String ... params) {
        QualityToolProcessCreator.logProcessStart(path, workingDir, false, params);
    }

    public static void logProcessStart(String path, String workingDir, boolean fix, String ... params) {
        StringBuilder buf = new StringBuilder();
        buf.append("Running quality tool").append(fix ? " (quick-fix) " : " ").append("from working dir: ").append(workingDir).append("\n");
        buf.append(path);
        Arrays.stream(params).forEach(param -> buf.append(' ').append((String)param));
        LOG.debug(buf.toString());
    }

    @NotNull
    @InspectionMessage
    public static String getHangupMessage(@Nullable String path, int timeout, String[] params) {
        LOG.info("No response from " + path + " after " + timeout + " ms");
        HtmlBuilder infoMessage = new HtmlBuilder();
        infoMessage.append(PhpBundle.message("can.not.correctly.run.the.tool.with.parameters", new Object[0])).append("\n");
        Arrays.stream(params).forEach(param -> infoMessage.append("  ").append(param).append("\n"));
        infoMessage.append(PhpBundle.message("possible.tool.process.hangup.after.0.sec", timeout / 1000));
        String string = infoMessage.toString();
        if (string == null) {
            QualityToolProcessCreator.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolProcessCreator";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolProcessCreator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHangupMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getToolOutput";
                break;
            }
            case 4: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "disableXDebugOptions";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runToolProcess";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getXDebugOptions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 13 -> new IllegalStateException(string);
        };
    }
}

