/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.tools.quality.QualityToolBlackList;
import com.jetbrains.php.tools.quality.QualityToolType;
import com.jetbrains.php.tools.quality.QualityToolsIgnoreFilesConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class QualityToolAddToIgnoredAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Collection<VirtualFile> selectedFiles = this.getSelectedFiles(dataContext);
        if (selectedFiles.isEmpty()) {
            return;
        }
        if (project != null) {
            QualityToolBlackList blackList = this.getQualityToolType(project).getQualityToolBlackList(project);
            selectedFiles.forEach(blackList::addFile);
            this.showConfigurable(project, selectedFiles);
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        if (this.getSelectedFiles(e.getDataContext()).isEmpty()) {
            presentation.setVisible(false);
            return;
        }
        presentation.setVisible(true);
        Project project = e.getProject();
        if (project != null) {
            presentation.setText(this.getQualityToolType(project).getDisplayName());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    private Collection<VirtualFile> getSelectedFiles(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(3);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                QualityToolAddToIgnoredAction.$$$reportNull$$$0(4);
            }
            return list;
        }
        ArrayList<VirtualFile> filteredFiles = new ArrayList<VirtualFile>();
        VirtualFile[] selectedFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        QualityToolBlackList blackList = this.getQualityToolType(project).getQualityToolBlackList(project);
        if (selectedFiles != null) {
            for (VirtualFile file : selectedFiles) {
                if (blackList.containsFile(file) || !FileTypeRegistry.getInstance().isFileOfType(file, (FileType)PhpFileType.INSTANCE)) continue;
                filteredFiles.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = filteredFiles;
        if (arrayList == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    @NlsActions.ActionText
    protected abstract QualityToolType getQualityToolType(Project var1);

    private void showConfigurable(@NotNull Project project, @NotNull Collection<VirtualFile> selectedFiles) {
        if (project == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(6);
        }
        if (selectedFiles == null) {
            QualityToolAddToIgnoredAction.$$$reportNull$$$0(7);
        }
        QualityToolsIgnoreFilesConfigurable ignoredFilesConfigurable = new QualityToolsIgnoreFilesConfigurable(this.getQualityToolType(project), project);
        ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)ignoredFilesConfigurable, () -> ignoredFilesConfigurable.selectFiles(selectedFiles));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/QualityToolAddToIgnoredAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/QualityToolAddToIgnoredAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedFiles";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showConfigurable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }
}

