/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework.run;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettingsValidator;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDefaultTestRunnerSettingsValidator
implements PhpTestRunnerSettingsValidator {
    private final List<String> myTypes;
    private final List<? extends FileType> myFileTypes;
    private final PhpTestMethodFinder myMethodFinder;
    private final boolean mySupportEmptyDir;
    private final boolean myShouldBeRelative;

    public PhpDefaultTestRunnerSettingsValidator(@NotNull List<? extends FileType> fileTypes, @NotNull PhpTestMethodFinder finder, boolean supportEmptyDir, boolean shouldBeRelative) {
        if (fileTypes == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(0);
        }
        if (finder == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(1);
        }
        this(fileTypes, Collections.emptyList(), finder, supportEmptyDir, shouldBeRelative);
    }

    public PhpDefaultTestRunnerSettingsValidator(@NotNull List<? extends FileType> fileTypes, @NotNull List<String> types, @NotNull PhpTestMethodFinder finder, boolean supportEmptyDir, boolean shouldBeRelative) {
        if (fileTypes == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(2);
        }
        if (types == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(3);
        }
        if (finder == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(4);
        }
        this.myFileTypes = fileTypes;
        this.myTypes = types;
        this.myMethodFinder = finder;
        this.mySupportEmptyDir = supportEmptyDir;
        this.myShouldBeRelative = shouldBeRelative;
    }

    @Override
    public boolean isEmptyDirectoryValid() {
        return this.mySupportEmptyDir;
    }

    @Override
    @NlsContexts.DialogMessage
    @Nullable
    public String isTypeValid(@Nullable String type) {
        if (StringUtil.isEmpty((String)type)) {
            return PhpBundle.message("php.test.framework.validation.run.configuration.no.type", new Object[0]);
        }
        if (!this.myTypes.contains(type)) {
            return PhpBundle.message("php.test.framework.validation.run.configuration.unsupported.type", type);
        }
        return null;
    }

    @Override
    @NlsContexts.DialogMessage
    @Nullable
    public String isDirectoryValid(@Nullable VirtualFile directory, @NotNull VirtualFile workingDirectory) {
        if (workingDirectory == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            return PhpBundle.message("validation.value.is.not.specified.or.invalid", "Directory");
        }
        if (this.myShouldBeRelative && !FileUtil.isAncestor((String)workingDirectory.getPath(), (String)directory.getPath(), (boolean)false)) {
            String path = FileUtil.toSystemDependentName((String)workingDirectory.getPath());
            return PhpBundle.message("php.test.framework.validation.run.configuration.working.directory", path);
        }
        return null;
    }

    @Override
    @NlsContexts.DialogMessage
    @Nullable
    public String isFileValid(@Nullable PsiFile file, @NotNull VirtualFile workingDirectory) {
        if (workingDirectory == null) {
            PhpDefaultTestRunnerSettingsValidator.$$$reportNull$$$0(6);
        }
        if (file == null || !this.myFileTypes.contains(file.getFileType())) {
            return PhpBundle.message("validation.value.is.not.specified.or.invalid", "File");
        }
        if (!FileUtil.isAncestor((String)workingDirectory.getPath(), (String)file.getVirtualFile().getPath(), (boolean)false)) {
            String path = FileUtil.toSystemDependentName((String)workingDirectory.getPath());
            return PhpBundle.message("php.test.framework.validation.run.configuration.file.working.directory", path);
        }
        return null;
    }

    @Override
    @NlsContexts.DialogMessage
    @Nullable
    public String isMethodValid(@Nullable PsiFile file, @Nullable String methodName) {
        if (file == null || !this.myFileTypes.contains(file.getFileType())) {
            return PhpBundle.message("validation.value.is.not.specified.or.invalid", "File");
        }
        if (StringUtil.isEmpty((String)methodName)) {
            return PhpBundle.message("validation.value.is.not.specified.or.invalid", "Method");
        }
        if (!this.myMethodFinder.find(file, methodName)) {
            return PhpBundle.message("php.test.framework.validation.run.configuration.method", methodName, file.getName());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypes";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/testFramework/run/PhpDefaultTestRunnerSettingsValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isDirectoryValid";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileValid";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface PhpTestMethodFinder {
        public boolean find(@NotNull PsiFile var1, @NotNull String var2);
    }
}

