/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.composer.configData.ComposerConfigManager;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.lib.ComposerLibraryServiceFactory;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import com.jetbrains.php.testFramework.run.PhpTestRunConfiguration;
import com.jetbrains.php.testFramework.run.PhpTestRunConfigurationSettings;
import com.jetbrains.php.testFramework.run.PhpTestRunnerSettings;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkComposerConfig
extends PackageComposerConfigClient {
    private final PhpTestFrameworkType myFrameworkType;

    public PhpTestFrameworkComposerConfig(@NotNull PhpTestFrameworkType frameworkType, @NotNull String frameworkPackage, @NotNull String relativePath) {
        if (frameworkType == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(0);
        }
        if (frameworkPackage == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(1);
        }
        if (relativePath == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(2);
        }
        super(frameworkPackage, relativePath);
        this.myFrameworkType = frameworkType;
    }

    @Override
    public boolean isAccept(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(3);
        }
        if (virtualFile == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    public void consume(@Nullable String version, @NotNull Project project, @NotNull VirtualFile config) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(5);
        }
        if (config == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)version)) {
            return;
        }
        String interpreterId = ComposerDataService.getInstance(project).getComposerExecution().getInterpreterId();
        PhpInterpreter interpreter = PhpInterpretersManagerImpl.getInstance(project).findInterpreterById(interpreterId);
        this.updateSettings(project, interpreter, config);
    }

    @Override
    public void updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, @Nullable VirtualFile config) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(7);
        }
        this.updateSettings(project, interpreter, true, config);
    }

    @Nullable
    public PhpTestFrameworkConfiguration updateSettings(@NotNull Project project, @Nullable PhpInterpreter interpreter, boolean withRunConfig, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(8);
        }
        PhpTestFrameworkConfiguration configuration = PhpTestFrameworkSettingsManager.getInstance(project).getConfigByInterpreter(this.myFrameworkType, interpreter, composerConfig);
        VirtualFile configFile = (VirtualFile)ReadAction.compute(() -> this.findConfigurationFile(project, composerConfig));
        if (withRunConfig) {
            this.updateConfigurations(project, configFile, composerConfig);
        }
        if (PhpTestFrameworkComposerConfig.isEnabledForComposerConfig(project, composerConfig, this.myFrameworkType) && (configuration == null || StringUtil.isEmpty((String)configuration.getExecutablePath()))) {
            String executable = this.findFromComposerVendor(project, composerConfig);
            if (StringUtil.isEmpty((String)executable) || !FileUtil.exists((String)executable)) {
                return null;
            }
            PhpTestFrameworkConfiguration newConfig = PhpTestFrameworkSettingsManager.getInstance(project).getOrCreateByInterpreter(this.myFrameworkType, interpreter, composerConfig);
            newConfig.setExecutablePath(interpreter == null || !interpreter.isRemote() ? PathUtil.toSystemDependentName((String)executable) : executable);
            ApplicationManager.getApplication().invokeLater(() -> this.updateRunConfigurations(project, newConfig, configFile, withRunConfig));
            this.notify(project, newConfig);
            return newConfig;
        }
        return null;
    }

    protected void updateConfigurations(@NotNull Project project, @Nullable VirtualFile configFile, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(9);
        }
    }

    protected static boolean isEnabledForComposerConfig(@NotNull Project project, @Nullable VirtualFile composerConfig, @NotNull PhpTestFrameworkType frameworkType) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(10);
        }
        if (frameworkType == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(11);
        }
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter") || composerConfig == null) {
            return ComposerDataService.getInstance(project).getSynchronizationState() == ComposerDataService.SynchronizationState.SYNCHRONIZE && ComposerDataService.getInstance(project).isTestFrameworkSyncEnabled(frameworkType);
        }
        return composerConfig.equals(ComposerConfigManager.getInstance(project).getMainConfig());
    }

    protected static boolean isEnabledForTestFrameworkConfig(@NotNull Project project, @Nullable VirtualFile testFrameworkConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(12);
        }
        if (Registry.is((String)"php.multiple.testframework.configs.per.interpreter")) {
            return true;
        }
        if (testFrameworkConfig == null) {
            return false;
        }
        ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(project);
        return Objects.equals(composerConfigManager.getConfig(testFrameworkConfig), composerConfigManager.getMainConfig());
    }

    protected static boolean isControlledByComposer(@NotNull Project project, @NotNull String path, @Nullable VirtualFile composerConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(13);
        }
        if (path == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(14);
        }
        if (composerConfig == null) {
            return false;
        }
        ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(project);
        if (composerConfigManager.getAllConfigs().size() <= 1) {
            return true;
        }
        VirtualFile file = ComposerUtils.refreshAndFindFileByPath(path);
        return file != null && Objects.equals(composerConfigManager.getConfig(file), composerConfig);
    }

    protected static boolean isDefaultTestRootAllowedByComposer(@NotNull Project project, @NotNull VirtualFile composerConfig, @NotNull String defaultTestRootPath) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(15);
        }
        if (composerConfig == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(16);
        }
        if (defaultTestRootPath == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(17);
        }
        VirtualFile composerConfigByTestRoot = PhpTestFrameworkComposerConfig.getComposerConfig(project, defaultTestRootPath);
        ComposerDataService.SynchronizationState synchronizationState = ComposerDataService.getInstance(project).getSynchronizationState();
        return composerConfig.equals(composerConfigByTestRoot) && (synchronizationState == ComposerDataService.SynchronizationState.DONT_SYNCHRONIZE || synchronizationState == ComposerDataService.SynchronizationState.SYNCHRONIZE && !ComposerConfigUtils.containsSection(composerConfig, "autoload-dev"));
    }

    protected static VirtualFile getComposerConfig(@NotNull Project project, @NotNull String path) {
        VirtualFile file;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(18);
        }
        if (path == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(19);
        }
        if ((file = ComposerUtils.refreshAndFindFileByPath(path)) == null) {
            return null;
        }
        return ComposerConfigManager.getInstance(project).getConfig(file);
    }

    protected void updateRunConfigurations(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable VirtualFile configFile, boolean withRunConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(20);
        }
        if (configuration == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(21);
        }
        if (configFile == null) {
            return;
        }
        this.updateByConfigurationFile(project, configuration, configFile);
        if (withRunConfig) {
            ConfigurationFactory[] factories = this.getConfigurationType().getConfigurationFactories();
            if (factories == null || factories.length != 1) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            String runConfigName = Registry.is((String)"php.multiple.testframework.configs.per.interpreter") ? configuration.getPresentableName(project) : configFile.getName();
            RunnerAndConfigurationSettings settings = runManager.createConfiguration(runConfigName, factories[0]);
            PhpTestRunnerSettings testRunnerSettings = ((PhpTestRunConfigurationSettings)((PhpTestRunConfiguration)settings.getConfiguration()).getSettings()).getRunnerSettings();
            testRunnerSettings.setScope(PhpTestRunnerSettings.Scope.ConfigurationFile);
            testRunnerSettings.setUseAlternativeConfigurationFile(true);
            testRunnerSettings.setConfigurationFilePath(configFile.getPath());
            runManager.addConfiguration(settings);
        }
    }

    @Nullable
    protected VirtualFile findConfigurationFile(@NotNull Project project, @Nullable VirtualFile composerConfig) {
        VirtualFile projectDir;
        VirtualFile composerDir;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(22);
        }
        VirtualFile virtualFile = composerDir = composerConfig != null ? composerConfig.getParent() : null;
        if (composerDir != null) {
            VirtualFile file;
            VirtualFile vendorDir = ComposerLibraryServiceFactory.getInstance(project, composerConfig).getVendorDir();
            if (vendorDir == null) {
                vendorDir = VfsUtil.findRelativeFile((VirtualFile)composerConfig, (String[])new String[]{FileUtil.toCanonicalPath((String)"vendor")});
            }
            if ((file = this.findConfigurationFile(project, composerDir, composerConfig, vendorDir)) != null) {
                return file;
            }
        }
        return (projectDir = ProjectUtil.guessProjectDir((Project)project)) != null ? this.findConfigurationFile(project, projectDir, null, null) : null;
    }

    @Nullable
    private VirtualFile findConfigurationFile(@NotNull Project project, @NotNull VirtualFile baseDir, @Nullable VirtualFile composerConfig, @Nullable VirtualFile vendorDir) {
        Collection<VirtualFile> configs;
        VirtualFile configInBaseDir;
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(23);
        }
        if (baseDir == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(24);
        }
        if ((configInBaseDir = (VirtualFile)ContainerUtil.find(configs = PhpTestFrameworkComposerConfig.findConfigurationFiles(project, this.getDefaultConfigName(), baseDir, composerConfig, vendorDir), c -> baseDir.equals(c.getParent()))) != null) {
            return configInBaseDir;
        }
        Collection<VirtualFile> distConfigs = PhpTestFrameworkComposerConfig.findConfigurationFiles(project, this.getDefaultConfigName() + ".dist", baseDir, composerConfig, vendorDir);
        VirtualFile distConfigInBaseDir = (VirtualFile)ContainerUtil.find(distConfigs, c -> baseDir.equals(c.getParent()));
        if (distConfigInBaseDir != null) {
            return distConfigInBaseDir;
        }
        if (!configs.isEmpty()) {
            return configs.stream().min(Comparator.comparingInt(c -> c.getPath().length())).get();
        }
        if (!distConfigs.isEmpty()) {
            return distConfigs.stream().min(Comparator.comparingInt(c -> c.getPath().length())).get();
        }
        return null;
    }

    private static Collection<VirtualFile> findConfigurationFiles(@NotNull Project project, @NotNull String configName, @NotNull VirtualFile baseDir, @Nullable VirtualFile composerConfig, @Nullable VirtualFile vendorDir) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(25);
        }
        if (configName == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(26);
        }
        if (baseDir == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(27);
        }
        GlobalSearchScope scope = GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)baseDir, (boolean)true);
        ComposerConfigManager composerConfigManager = ComposerConfigManager.getInstance(project);
        Collection configs = FilenameIndex.getVirtualFilesByName((String)configName, (GlobalSearchScope)scope);
        return configs.stream().filter(f -> !ProjectCoreUtil.isProjectOrWorkspaceFile((VirtualFile)f)).filter(f -> Objects.equals(composerConfigManager.getConfig((VirtualFile)f), composerConfig)).filter(f -> vendorDir == null || !VfsUtilCore.isAncestor((VirtualFile)vendorDir, (VirtualFile)f, (boolean)true)).toList();
    }

    protected void updateByConfigurationFile(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration configuration, @NotNull VirtualFile file) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(28);
        }
        if (configuration == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(29);
        }
        if (file == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(30);
        }
        configuration.setUseConfigurationFile(true);
        configuration.setConfigurationFilePath(file.getPath());
    }

    @NotNull
    public Collection<String> getTestRoots(@NotNull Project project) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(31);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    protected abstract String getDefaultConfigName();

    @NotNull
    protected abstract ConfigurationType getConfigurationType();

    protected void notify(@NotNull Project project, @NotNull PhpTestFrameworkConfiguration newConfig) {
        if (project == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(33);
        }
        if (newConfig == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(34);
        }
        this.notify(project, newConfig.getFrameworkType().getDisplayName(), ComposerLogMessageBuilder.Settings.TEST_FRAMEWORKS);
    }

    @Nullable
    public static PhpTestFrameworkComposerConfig getTestFrameworkComposerConfig(PhpTestFrameworkType frameworkType) {
        for (ComposerConfigClient client : (ComposerConfigClient[])EP_NAME.getExtensions()) {
            PhpTestFrameworkComposerConfig config = (PhpTestFrameworkComposerConfig)ObjectUtils.tryCast((Object)client, PhpTestFrameworkComposerConfig.class);
            if (config == null || config.myFrameworkType != frameworkType) continue;
            return config;
        }
        return null;
    }

    @NotNull
    public static Collection<PhpTestFrameworkComposerConfig> getTestExtensions() {
        List list = ContainerUtil.filterIsInstance((Object[])ComposerConfigClient.EP_NAME.getExtensions(), PhpTestFrameworkComposerConfig.class);
        if (list == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(35);
        }
        return list;
    }

    @Override
    @Nullable
    public ComposerLogMessageBuilder.Settings getSettings() {
        return ComposerLogMessageBuilder.Settings.TEST_FRAMEWORKS;
    }

    @NotNull
    public PhpTestFrameworkType getFrameworkType() {
        PhpTestFrameworkType phpTestFrameworkType = this.myFrameworkType;
        if (phpTestFrameworkType == null) {
            PhpTestFrameworkComposerConfig.$$$reportNull$$$0(36);
        }
        return phpTestFrameworkType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 32, 35, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkPackage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 28: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerConfig";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultTestRootPath";
                break;
            }
            case 21: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configName";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 35: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkComposerConfig";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkComposerConfig";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestExtensions";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAccept";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "consume";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateSettings";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateConfigurations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForComposerConfig";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledForTestFrameworkConfig";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isControlledByComposer";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultTestRootAllowedByComposer";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getComposerConfig";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateRunConfigurations";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationFile";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findConfigurationFiles";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateByConfigurationFile";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
            case 32: 
            case 35: 
            case 36: {
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 32, 35, 36 -> new IllegalStateException(string);
        };
    }
}

