/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettings;
import com.jetbrains.php.testFramework.PhpTestFrameworkStateListener;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTestFrameworkBaseSettingsManager
implements PersistentStateComponent<State>,
Disposable {
    protected final Project myProject;
    protected State myState;
    private final List<PhpTestFrameworkStateListener> myStateListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public PhpTestFrameworkBaseSettingsManager() {
        this(null);
    }

    public PhpTestFrameworkBaseSettingsManager(@Nullable Project project) {
        this.myProject = project;
        this.myState = new State(this.myProject);
        if (this.myProject != null) {
            this.myProject.getMessageBus().connect((Disposable)this).subscribe(PhpInterpretersManagerImpl.PhpInterpreterConflictResolveListener.TOPIC, (Object)new PhpInterpretersManagerImpl.PhpInterpreterConflictResolveListener(){

                @Override
                public void resolveInterpreterConflict(@NotNull Map<String, String> oldInterpreterIdToNew) {
                    if (oldInterpreterIdToNew == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    for (PhpTestFrameworkSettings settings : PhpTestFrameworkBaseSettingsManager.this.myState.getSettings().values()) {
                        for (PhpTestFrameworkConfiguration configuration : settings.getConfigurations()) {
                            String oldInterpreterId;
                            if (!(configuration instanceof PhpSdkDependentConfiguration) || !oldInterpreterIdToNew.containsKey(oldInterpreterId = ((PhpSdkDependentConfiguration)((Object)configuration)).getInterpreterId())) continue;
                            ((PhpSdkDependentConfiguration)((Object)configuration)).setInterpreterId(oldInterpreterIdToNew.get(oldInterpreterId));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldInterpreterIdToNew", "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager$1", "resolveInterpreterConflict"));
                }
            });
        }
    }

    @NotNull
    public Set<PhpTestFrameworkType> getFrameworks() {
        Set<String> tools = this.myState.getSettings().keySet();
        if (tools.isEmpty()) {
            Set<PhpTestFrameworkType> set = Collections.emptySet();
            if (set == null) {
                PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<PhpTestFrameworkType> frameworkTypes = new HashSet<PhpTestFrameworkType>(tools.size());
        frameworkTypes.addAll(ContainerUtil.filter((Object[])PhpTestFrameworkType.getTestFrameworkTypes(), i -> tools.contains(i.getID())));
        HashSet<PhpTestFrameworkType> hashSet = frameworkTypes;
        if (hashSet == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    public abstract List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull PhpTestFrameworkType var1);

    public abstract void setConfigurations(@NotNull PhpTestFrameworkType var1, @NotNull List<PhpTestFrameworkConfiguration> var2);

    @Nullable
    protected PhpTestFrameworkConfiguration getConfigById(@NotNull PhpTestFrameworkType frameworkType, @NotNull String id) {
        if (frameworkType == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(2);
        }
        if (id == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(3);
        }
        for (PhpTestFrameworkConfiguration configuration : this.getConfigurations(frameworkType)) {
            if (!StringUtil.equals((CharSequence)configuration.getId(this.myProject), (CharSequence)id)) continue;
            return configuration;
        }
        return null;
    }

    protected void onSettingsUpdate() {
        for (PhpTestFrameworkStateListener listener : this.myStateListeners) {
            listener.onSettingsUpdate();
        }
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull PhpTestFrameworkStateListener listener) {
        if (parentDisposable == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(4);
        }
        if (listener == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(5);
        }
        ContainerUtil.add((Object)listener, this.myStateListeners, (Disposable)parentDisposable);
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpTestFrameworkBaseSettingsManager.$$$reportNull$$$0(6);
        }
        if (state.getProject() == null && this.myProject != null) {
            state.setProject(this.myProject);
        }
        this.myState = state;
        this.onSettingsUpdate();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameworkType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworks";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigById";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    public static class State {
        private Map<String, PhpTestFrameworkSettings> mySettings = new ConcurrentHashMap<String, PhpTestFrameworkSettings>();
        @Nullable
        private Project myProject;

        private State() {
            this(null);
        }

        public State(@Nullable Project project) {
            this.myProject = project;
        }

        @Tag(value="test_tools")
        @MapAnnotation(surroundWithTag=false, keyAttributeName="tool_name", entryTagName="tool", surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, PhpTestFrameworkSettings> getSettings() {
            return this.mySettings;
        }

        public void setSettings(Map<String, PhpTestFrameworkSettings> settings) {
            for (PhpTestFrameworkType type : PhpTestFrameworkType.getTestFrameworkTypes()) {
                Map.Entry settingsEntry = (Map.Entry)ContainerUtil.find(settings.entrySet(), entry -> ((String)entry.getKey()).equals(type.getID()));
                if (settingsEntry == null) continue;
                ((PhpTestFrameworkSettings)settingsEntry.getValue()).getConfigurations().forEach(config -> config.setFrameworkType(type));
            }
            this.mySettings = settings;
        }

        @NotNull
        public List<PhpTestFrameworkConfiguration> getConfigurationsByKey(@NotNull String key) {
            if (key == null) {
                State.$$$reportNull$$$0(0);
            }
            List<PhpTestFrameworkConfiguration> list = this.mySettings.containsKey(key) ? this.mySettings.get(key).getConfigurations() : Collections.emptyList();
            if (list == null) {
                State.$$$reportNull$$$0(1);
            }
            return list;
        }

        public PhpTestFrameworkConfiguration addIfAbsent(@NotNull String key, @Nullable Project project, @NotNull PhpTestFrameworkConfiguration configuration, @Nullable String interpreterId, @Nullable VirtualFile locationContext) {
            if (key == null) {
                State.$$$reportNull$$$0(2);
            }
            if (configuration == null) {
                State.$$$reportNull$$$0(3);
            }
            this.mySettings.putIfAbsent(key, new PhpTestFrameworkSettings());
            return this.mySettings.get(key).addIfAbsent(project != null ? project : this.myProject, configuration, interpreterId, locationContext);
        }

        public void setConfigurationsByKey(@NotNull String key, @NotNull List<PhpTestFrameworkConfiguration> configurations, @Nullable Project project) {
            if (key == null) {
                State.$$$reportNull$$$0(4);
            }
            if (configurations == null) {
                State.$$$reportNull$$$0(5);
            }
            this.mySettings.putIfAbsent(key, new PhpTestFrameworkSettings());
            this.mySettings.get(key).setConfigurations(configurations, project);
        }

        public void removeConfigurations(@NotNull String key) {
            if (key == null) {
                State.$$$reportNull$$$0(6);
            }
            this.mySettings.remove(key);
        }

        @Nullable
        Project getProject() {
            return this.myProject;
        }

        void setProject(@NotNull Project project) {
            if (project == null) {
                State.$$$reportNull$$$0(7);
            }
            this.myProject = project;
            for (Map.Entry<String, PhpTestFrameworkSettings> entry : this.mySettings.entrySet()) {
                entry.getValue().setConfigurations(entry.getValue().getConfigurations(), project);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager$State";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurations";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/testFramework/PhpTestFrameworkBaseSettingsManager$State";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationsByKey";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurationsByKey";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addIfAbsent";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setConfigurationsByKey";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeConfigurations";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setProject";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

