/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.surroundWith;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.surroundWith.PhpExpressionSurrounder;
import org.jetbrains.annotations.NotNull;

public abstract class PhpWithControlStatementExpressionSurrounder
extends PhpExpressionSurrounder {
    @Override
    protected boolean isApplicable(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpWithControlStatementExpressionSurrounder.$$$reportNull$$$0(0);
        }
        if (expression.getContainingFile() == null || !expression.isValid()) {
            return false;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof Statement && !PhpLangUtil.isShortEchoTagStatement(parent)) {
            return parent.getTextRange().equals((Object)expression.getTextRange());
        }
        return false;
    }

    @NotNull
    protected abstract String getStatementTemplate();

    @Override
    @NotNull
    protected TextRange surroundExpression(@NotNull Project project, @NotNull Editor editor, @NotNull PhpExpression phpExpression) {
        if (project == null) {
            PhpWithControlStatementExpressionSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            PhpWithControlStatementExpressionSurrounder.$$$reportNull$$$0(2);
        }
        if (phpExpression == null) {
            PhpWithControlStatementExpressionSurrounder.$$$reportNull$$$0(3);
        }
        ControlStatement controlStatement = (ControlStatement)PhpPsiElementFactory.createStatement(project, this.getStatementTemplate());
        controlStatement.getCondition().replace((PsiElement)phpExpression);
        controlStatement = (ControlStatement)phpExpression.getParent().replace((PsiElement)controlStatement);
        GroupStatement controlStatementBody = (GroupStatement)controlStatement.getStatement();
        assert (controlStatementBody != null);
        assert (controlStatementBody.isValid()) : controlStatement.getText();
        Statement firstStatement = (Statement)PsiTreeUtil.findChildOfType((PsiElement)controlStatementBody, Statement.class);
        Document document = editor.getDocument();
        RangeMarker statementMarker = document.createRangeMarker(firstStatement.getTextRange());
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        TextRange range = statementMarker.getTextRange();
        statementMarker.dispose();
        int startOffset = range.getStartOffset();
        document.deleteString(startOffset, range.getEndOffset());
        TextRange textRange = TextRange.create((int)startOffset, (int)startOffset);
        if (textRange == null) {
            PhpWithControlStatementExpressionSurrounder.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpExpression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/surroundWith/PhpWithControlStatementExpressionSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/surroundWith/PhpWithControlStatementExpressionSurrounder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "surroundExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "surroundExpression";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

