/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.structuralsearch;

import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.structuralsearch.PredefinedConfigurationUtil;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.util.TriConsumer;
import com.jetbrains.php.lang.PhpFileType;
import java.util.ArrayList;
import java.util.Collection;

public final class PhpPredefinedConfigurations {
    private static final String GENERAL_CATEGORY = "PHP/General";
    private static final String EXPRESSIONS_CATEGORY = "PHP/Expressions";
    private static final String SUSPICIOUS_CATEGORY = "PHP/Suspicious";

    private PhpPredefinedConfigurations() {
    }

    public static Configuration[] createPredefinedTemplates() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        configurations.addAll(PhpPredefinedConfigurations.createGeneralConfigurations());
        configurations.addAll(PhpPredefinedConfigurations.createExpressionsConfigurations());
        configurations.addAll(PhpPredefinedConfigurations.createMiscConfigurations());
        return configurations.toArray(Configuration.EMPTY_ARRAY);
    }

    private static Collection<Configuration> createGeneralConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        TriConsumer addGeneralTemplate = (name, refName, template) -> configurations.add(PredefinedConfigurationUtil.createLegacyConfiguration((String)name, (String)refName, (String)template, (String)GENERAL_CATEGORY, (LanguageFileType)PhpFileType.INSTANCE));
        addGeneralTemplate.accept((Object)"Class", (Object)"Class", (Object)"class 'a {}");
        addGeneralTemplate.accept((Object)"All public fields of the class", (Object)"All public fields of the class", (Object)"class '_a {public 'b+;}");
        addGeneralTemplate.accept((Object)"All public methods of the class", (Object)"All public methods of the class", (Object)"class '_a {public function 'b+()}");
        addGeneralTemplate.accept((Object)"All constants of the class", (Object)"All constants of the class", (Object)"class '_a {const 'b+}");
        addGeneralTemplate.accept((Object)"Interface", (Object)"Interface", (Object)"interface 'a {}");
        addGeneralTemplate.accept((Object)"Trait", (Object)"Trait", (Object)"trait 'a {}");
        addGeneralTemplate.accept((Object)"Class that extends another", (Object)"Class that extends another", (Object)"class 'a extends '_b {}");
        addGeneralTemplate.accept((Object)"Class that implements two interfaces", (Object)"Class that implements two interfaces", (Object)"class 'a implements '_b{2,2} {}");
        return configurations;
    }

    private static Collection<Configuration> createExpressionsConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        TriConsumer addExpressionTemplate = (name, refName, template) -> configurations.add(PredefinedConfigurationUtil.createLegacyConfiguration((String)name, (String)refName, (String)template, (String)EXPRESSIONS_CATEGORY, (LanguageFileType)PhpFileType.INSTANCE));
        addExpressionTemplate.accept((Object)"Assignment", (Object)"Assignment", (Object)"'_a = '_b");
        addExpressionTemplate.accept((Object)"Function call with 2 parameters", (Object)"Function call with 2 parameters", (Object)"'a('_p{2,2})");
        addExpressionTemplate.accept((Object)"Instance method call", (Object)"Instance method call", (Object)"'_a->'_b()");
        addExpressionTemplate.accept((Object)"Static method call", (Object)"Static method call", (Object)"'_a::'_b()");
        addExpressionTemplate.accept((Object)"Field access", (Object)"Field access", (Object)"'_a->'_b");
        addExpressionTemplate.accept((Object)"Constructor call", (Object)"Constructor call", (Object)"new '_b()");
        addExpressionTemplate.accept((Object)"Instanceof", (Object)"Instanceof", (Object)"'_a instanceof '_b");
        return configurations;
    }

    private static Collection<Configuration> createMiscConfigurations() {
        ArrayList<Configuration> configurations = new ArrayList<Configuration>();
        TriConsumer addMiscTemplate = (name, refName, template) -> configurations.add(PredefinedConfigurationUtil.createLegacyConfiguration((String)name, (String)refName, (String)template, (String)SUSPICIOUS_CATEGORY, (LanguageFileType)PhpFileType.INSTANCE));
        addMiscTemplate.accept((Object)"Old style constructor", (Object)"Old style constructor", (Object)"class '_a{1,1} {function '_a()}");
        addMiscTemplate.accept((Object)"Empty 'if' statement", (Object)"Empty 'if' statement", (Object)"if () {'_s{0,0}}");
        addMiscTemplate.accept((Object)"Explicit magic method call", (Object)"Explicit magic method call", (Object)"'_a->'_b:[regex( ^__.+$ )]()");
        addMiscTemplate.accept((Object)"Final method inside final class", (Object)"Final method inside final class", (Object)"final class '_a {public final function 'b+()}");
        addMiscTemplate.accept((Object)"Assigning the return value of new by reference", (Object)"Assigning the return value of new by reference", (Object)"'_a = &new '_b");
        addMiscTemplate.accept((Object)"'parse_str(...)' call without second parameter", (Object)"'parse_str(...)' call without second parameter", (Object)"parse_str('_a{0,1})");
        addMiscTemplate.accept((Object)"'fopen(...)' call without binary safe modifier", (Object)"'fopen(...)' call without binary safe modifier", (Object)"fopen('_a, \"'_b:[!regex( ^.*b$ )]\", '_c{0,1}, '_d{0,1})");
        addMiscTemplate.accept((Object)"'error_reporting(...)' without predefined constant as argument", (Object)"'error_reporting(...)' without predefined constant as argument", (Object)"error_reporting('_a:[!ref( \"define(\\''_b:[regex( E_STRICT|E_DEPRECATED|E_USER_DEPRECATED|E_RECOVERABLE_ERROR|E_STRICT|E_ALL )]\\', '_c) \" )])");
        return configurations;
    }
}

