/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.internal.statistic.eventLog.validator.rules.EventContext;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.CustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.config.PhpRuntimeConfiguration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PhpExtensionsUsagesCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("php.stubs", 3);
    private static final EventId ALL_EXTENSIONS_DEFAULT = GROUP.registerEvent("all.extensions.default");
    private static final EventId2<Boolean, String> EXTENSION = GROUP.registerEvent("extension", (EventField)EventFields.Enabled, (EventField)EventFields.StringValidatedByCustomRule((String)"name", PhpExtensionValidator.class));

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        Map<String, Boolean> extensions;
        if (project == null) {
            PhpExtensionsUsagesCollector.$$$reportNull$$$0(0);
        }
        if ((extensions = PhpRuntimeConfiguration.getInstance(project).getState().getExtensions()).isEmpty()) {
            Set<MetricEvent> set = Collections.singleton(ALL_EXTENSIONS_DEFAULT.metric());
            if (set == null) {
                PhpExtensionsUsagesCollector.$$$reportNull$$$0(1);
            }
            return set;
        }
        Set set = StreamEx.of(extensions.entrySet()).map(entry -> EXTENSION.metric((Object)((Boolean)entry.getValue()), (Object)((String)entry.getKey()))).toSet();
        if (set == null) {
            PhpExtensionsUsagesCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/statistics/PhpExtensionsUsagesCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/statistics/PhpExtensionsUsagesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    public static final class PhpExtensionValidator
    extends CustomValidationRule {
        @NotNull
        public String getRuleId() {
            return "php_stub_extension";
        }

        @NotNull
        protected ValidationResultType doValidate(@NotNull String data, @NotNull EventContext context) {
            if (data == null) {
                PhpExtensionValidator.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpExtensionValidator.$$$reportNull$$$0(1);
            }
            if (PhpProjectConfigurableForm.getExtensionToCategory().containsKey(data) || PhpRuntimeConfiguration.WHITE_LISTED_THIRD_PARTY_EXTENSIONS.contains(data)) {
                ValidationResultType validationResultType = ValidationResultType.ACCEPTED;
                if (validationResultType == null) {
                    PhpExtensionValidator.$$$reportNull$$$0(2);
                }
                return validationResultType;
            }
            ValidationResultType validationResultType = ValidationResultType.THIRD_PARTY;
            if (validationResultType == null) {
                PhpExtensionValidator.$$$reportNull$$$0(3);
            }
            return validationResultType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/statistics/PhpExtensionsUsagesCollector$PhpExtensionValidator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/statistics/PhpExtensionsUsagesCollector$PhpExtensionValidator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doValidate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "doValidate";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

