/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRunConfigurationInterpreterCombobox
extends PhpInterpreterComboBox {
    public PhpRunConfigurationInterpreterCombobox(@Nullable Project project, @Nullable Condition<? super PhpSdkAdditionalData> filter) {
        super(project, filter);
        this.setNoItemText(PhpBundle.message("framework.composer.interpreters.combo.default.project.interpreter", new Object[0]));
        this.getComboBox().addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                PhpRunConfigurationInterpreterCombobox.this.updateItems(PhpRunConfigurationInterpreterCombobox.this.getSelectedItemName());
            }
        });
    }

    @Override
    public void reset(@Nullable String selectedItemName) {
        this.updateItems(selectedItemName);
    }

    protected void updateItems(@Nullable String selectedItemName) {
        List items = this.getItems();
        RunnerAndConfigurationSettings configuration = RunManager.getInstance((Project)this.myProject).getSelectedConfiguration();
        if (configuration != null && configuration.isShared()) {
            items = ContainerUtil.filter(items, PhpInterpreter::isProjectLevel);
        }
        this.setModel(ContainerUtil.map(items, PhpInterpreter::getName), selectedItemName, configuration);
    }

    public void setModel(@NotNull List<String> items, @Nullable String selectedItemName, @Nullable RunnerAndConfigurationSettings runnerAndConfigurationSettings) {
        PhpInterpreterComboBox.MyRegularNamedItem selected;
        if (items == null) {
            PhpRunConfigurationInterpreterCombobox.$$$reportNull$$$0(0);
        }
        PhpInterpreter selectedInterpreter = PhpInterpretersManagerImpl.getInstance(this.myProject).findInterpreter(selectedItemName);
        PhpInterpreterComboBox.MyRegularNamedItem noItem = this.isNoItemAllowed() ? new PhpInterpreterComboBox.MyRegularNamedItem(this, null, null) : new PhpInterpreterComboBox.MyRegularNamedItem(this, null, SimpleTextAttributes.ERROR_ATTRIBUTES, null);
        LinkedList<PhpInterpreterComboBox.MyRegularNamedItem> myItems = new LinkedList<PhpInterpreterComboBox.MyRegularNamedItem>();
        if (selectedItemName != null) {
            selected = selectedInterpreter != null && runnerAndConfigurationSettings != null && runnerAndConfigurationSettings.isShared() && !selectedInterpreter.isProjectLevel() ? new PhpInterpreterComboBox.MyRegularNamedItem(this, selectedItemName, SimpleTextAttributes.ERROR_ATTRIBUTES, null) : (selectedInterpreter != null ? new PhpInterpreterComboBox.MyRegularNamedItem(this, selectedItemName, selectedInterpreter.getPhpSdkAdditionalData().getDecorator()) : new PhpInterpreterComboBox.MyRegularNamedItem(this, selectedItemName, SimpleTextAttributes.ERROR_ATTRIBUTES, null));
            if (this.isNoItemAllowed()) {
                myItems.add(noItem);
            }
        } else {
            selected = noItem;
        }
        myItems.addFirst(selected);
        for (String interpreterName : items) {
            if (interpreterName.equals(selectedItemName)) continue;
            myItems.add(new PhpInterpreterComboBox.MyRegularNamedItem(this, interpreterName, null));
        }
        this.getComboBox().setModel(new CollectionComboBoxModel(myItems, (Object)selected));
        this.getComboBox().setSelectedItem(selected);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/jetbrains/php/run/PhpRunConfigurationInterpreterCombobox", "setModel"));
    }
}

