/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.run;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.run.PhpInterpreterSettings;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="CommandLine")
public class PhpCommandLineSettings
implements Cloneable {
    private String myWorkingDirectory = null;
    @NotNull
    private List<String> myEnvFiles = new ArrayList<String>();
    private String myParameters = null;
    @NotNull
    private Map<String, String> myEnvs = new HashMap<String, String>();
    private boolean myPassParentEnvs = true;
    @NotNull
    private PhpInterpreterSettings myInterpreterSettings = new PhpInterpreterSettings();

    @Property(surroundWithTag=false)
    @NotNull
    public PhpInterpreterSettings getInterpreterSettings() {
        PhpInterpreterSettings phpInterpreterSettings = this.myInterpreterSettings;
        if (phpInterpreterSettings == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(0);
        }
        return phpInterpreterSettings;
    }

    public void setInterpreterSettings(@NotNull PhpInterpreterSettings interpreterSettings) {
        if (interpreterSettings == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(1);
        }
        this.myInterpreterSettings = interpreterSettings;
    }

    @Transient
    @Nullable
    @NlsSafe
    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    @Transient
    public void setWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = StringUtil.nullize((String)workingDirectory);
    }

    @Attribute(value="workingDirectory")
    @Nullable
    public String getSerializedWorkingDirectory() {
        return PhpConfigurationUtil.serializePath(this.myWorkingDirectory);
    }

    public void setSerializedWorkingDirectory(@Nullable String workingDirectory) {
        this.myWorkingDirectory = PhpConfigurationUtil.deserializePath(workingDirectory);
    }

    @Attribute(value="parameters")
    @Nullable
    @NlsSafe
    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(@NotNull String parameters) {
        if (parameters == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(2);
        }
        this.myParameters = StringUtil.nullize((String)parameters);
    }

    @Tag(value="envs")
    @MapAnnotation(surroundWithTag=false, surroundKeyWithTag=false, surroundValueWithTag=false, entryTagName="env", keyAttributeName="name", valueAttributeName="value")
    @NotNull
    public Map<String, String> getSerializedEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(3);
        }
        return map;
    }

    public void setSerializedEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(4);
        }
        this.myEnvs = envs;
    }

    @Transient
    @NotNull
    public Map<String, String> getEnvs() {
        Map<String, String> map = this.myEnvs;
        if (map == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            PhpCommandLineSettings.$$$reportNull$$$0(6);
        }
        this.myEnvs.clear();
        this.myEnvs.putAll(envs);
    }

    @Attribute(value="pass_parent_envs")
    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PhpCommandLineSettings that = (PhpCommandLineSettings)o;
        if (this.myPassParentEnvs != that.myPassParentEnvs) {
            return false;
        }
        if (!this.myEnvs.equals(that.myEnvs)) {
            return false;
        }
        if (this.myParameters != null ? !this.myParameters.equals(that.myParameters) : that.myParameters != null) {
            return false;
        }
        if (this.myWorkingDirectory != null ? !this.myWorkingDirectory.equals(that.myWorkingDirectory) : that.myWorkingDirectory != null) {
            return false;
        }
        return Objects.equals(this.myInterpreterSettings, that.myInterpreterSettings);
    }

    public int hashCode() {
        int result = this.myWorkingDirectory != null ? this.myWorkingDirectory.hashCode() : 0;
        result = 31 * result + (this.myParameters != null ? this.myParameters.hashCode() : 0);
        result = 31 * result + this.myEnvs.hashCode();
        result = 31 * result + (this.myPassParentEnvs ? 1 : 0);
        result = 31 * result + this.myInterpreterSettings.hashCode();
        return result;
    }

    public PhpCommandLineSettings clone() {
        PhpCommandLineSettings commandLineSettings = new PhpCommandLineSettings();
        if (StringUtil.isNotEmpty((String)this.myWorkingDirectory)) {
            commandLineSettings.setWorkingDirectory(this.myWorkingDirectory);
        }
        if (StringUtil.isNotEmpty((String)this.myParameters)) {
            commandLineSettings.setParameters(this.myParameters);
        }
        if (!this.myEnvs.isEmpty()) {
            HashMap<String, String> envs = new HashMap<String, String>(this.myEnvs);
            commandLineSettings.setEnvs(envs);
        }
        commandLineSettings.setPassParentEnvs(this.myPassParentEnvs);
        commandLineSettings.setInterpreterSettings(this.myInterpreterSettings);
        commandLineSettings.setEnvFiles(this.myEnvFiles);
        return commandLineSettings;
    }

    @XCollection(style=XCollection.Style.v2, elementName="find", valueAttributeName="")
    public List<String> getEnvFiles() {
        return this.myEnvFiles;
    }

    public void setEnvFiles(List<String> envFiles) {
        this.myEnvFiles = envFiles;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/run/PhpCommandLineSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterSettings";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/run/PhpCommandLineSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerializedEnvs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterSettings";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setParameters";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSerializedEnvs";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 6 -> new IllegalArgumentException(string);
        };
    }
}

