/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocTemplateParameter;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.For;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInplaceRenamer
extends VariableInplaceRenamer {
    @Nls
    private static final String CLOSEST_SCOPE = PhpBundle.message("closest.scope", new Object[0]);
    @Nls
    private static final String VALUES = PhpBundle.message("all.values", new Object[0]);
    private Set<CharSequence> myUsedVariableNames;

    public PhpVariableInplaceRenamer(PsiNamedElement rename, Editor editor) {
        super(rename, editor);
        this.collectVariables(rename);
    }

    public PhpVariableInplaceRenamer(PsiNamedElement elementToRename, Editor editor, Project project, String initialName, String oldName) {
        super(elementToRename, editor, project, initialName, oldName);
        this.collectVariables(elementToRename);
    }

    protected boolean buildTemplateAndStart(@NotNull Collection<PsiReference> refs, @NotNull Collection<Pair<PsiElement, TextRange>> stringUsages, @NotNull PsiElement scope, @NotNull PsiFile containingFile) {
        PsiReference referenceAtCaret;
        if (refs == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(0);
        }
        if (stringUsages == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(3);
        }
        if ((referenceAtCaret = PhpRefactoringUtil.getReferenceAtCaret(scope, this.myEditor)) != null) {
            PsiElement element = referenceAtCaret.getElement();
            PhpRefactoringUtil.adjustCaretOffsetToIdentifierRange(this.myEditor, element, referenceAtCaret.getRangeInElement());
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                Collection<PsiReference> refsInClosestScope;
                if (StartMarkAction.canStart((Editor)this.myEditor) == null && element instanceof Variable && !(refsInClosestScope = PhpVariableInplaceRenamer.filterRefsInNearestScope((Variable)element, refs)).isEmpty() && refsInClosestScope.size() != refs.size()) {
                    this.chooseScope(refs, stringUsages, scope, containingFile, refsInClosestScope);
                    return true;
                }
            } else if (PhpRefactoringSettings.getInstance().RENAME_SEARCH_VARIABLE_IN_CLOSEST_SCOPE) {
                Collection<PsiReference> refsInClosestScope = PhpVariableInplaceRenamer.filterRefsInNearestScope((Variable)element, refs);
                return super.buildTemplateAndStart(refsInClosestScope, stringUsages, scope, containingFile);
            }
        }
        return super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
    }

    protected boolean appendAdditionalElement(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        if (this.myElementToRename instanceof PhpDocTemplateParameter) {
            return true;
        }
        return super.appendAdditionalElement(refs, stringUsages);
    }

    private void chooseScope(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages, PsiElement scope, PsiFile containingFile, Collection<PsiReference> refsInNearestScope) {
        final HashSet rangeHighlighters = new HashSet();
        JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(CLOSEST_SCOPE, VALUES)).setItemSelectedCallback(selectedValue -> {
            if (selectedValue == null) {
                return;
            }
            PhpVariableInplaceRenamer.dropHighlighters(rangeHighlighters);
            for (PsiReference reference : selectedValue.equals(CLOSEST_SCOPE) ? refsInNearestScope : refs) {
                TextRange textRange = reference.getAbsoluteRange();
                RangeHighlighter rangeHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
                rangeHighlighters.add(rangeHighlighter);
            }
        }).setTitle(PhpBundle.message("popup.title.multiple.write.scopes.found", new Object[0])).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", key -> key)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedValue -> {
            if (selectedValue.equals(CLOSEST_SCOPE)) {
                this.setElementToRename((PsiNamedElement)((Variable)ContainerUtil.getFirstItem((Collection)refsInNearestScope)));
                super.buildTemplateAndStart(refsInNearestScope, stringUsages, scope, containingFile);
            } else {
                super.buildTemplateAndStart(refs, stringUsages, scope, containingFile);
            }
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                PhpVariableInplaceRenamer.dropHighlighters(rangeHighlighters);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    @NotNull
    public static Collection<PsiReference> filterRefsInNearestScope(Variable variableAtCaret, Collection<PsiReference> references) {
        PsiElement nearestScope = PhpVariableInplaceRenamer.findNearestScopeWithDefiningVariable(variableAtCaret);
        if (nearestScope != null) {
            List list = ContainerUtil.filter(references, r -> PsiTreeUtil.isAncestor((PsiElement)nearestScope, (PsiElement)r.getElement(), (boolean)false));
            if (list == null) {
                PhpVariableInplaceRenamer.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection<PsiReference> collection = references;
        if (collection == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public static PsiElement findNearestScopeWithDefiningVariable(Variable variable) {
        ForeachStatement statement = PhpPsiUtil.getParentOfClass((PsiElement)variable, true, ForeachStatement.class);
        if (statement != null && (PhpVariableInplaceRenamer.isSameVariable((PsiElement)statement.getKey(), variable) || PhpVariableInplaceRenamer.isSameVariable((PsiElement)statement.getValue(), variable))) {
            return statement;
        }
        Catch phpCatch = PhpPsiUtil.getParentOfClass((PsiElement)variable, true, Catch.class);
        if (phpCatch != null && PhpVariableInplaceRenamer.isSameVariable((PsiElement)phpCatch.getException(), variable)) {
            return phpCatch;
        }
        For phpFor = PhpPsiUtil.getParentOfClass((PsiElement)variable, true, For.class);
        if (phpFor != null && ContainerUtil.exists((Object[])phpFor.getInitialExpressions(), i -> i instanceof AssignmentExpression && PhpVariableInplaceRenamer.isSameVariable((PsiElement)((AssignmentExpression)i).getVariable(), variable))) {
            return phpFor;
        }
        return null;
    }

    private static boolean isSameVariable(@Nullable PsiElement candidate, @NotNull Variable variable) {
        if (variable == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(6);
        }
        return candidate instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)candidate).getName(), variable.getName());
    }

    private static void dropHighlighters(Collection<RangeHighlighter> rangeHighlighters) {
        for (RangeHighlighter highlight : rangeHighlighters) {
            highlight.dispose();
        }
    }

    private void collectVariables(PsiNamedElement elementToRename) {
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations((PsiElement)elementToRename, true, null);
        this.myUsedVariableNames = new HashSet<CharSequence>();
        for (PhpNamedElement phpNamedElement : declarations) {
            this.myUsedVariableNames.add(phpNamedElement.getNameCS());
        }
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        if (element == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(7);
        }
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(new TextRange(0, element.getTextLength()), element);
        if (textRange == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiReference reference) {
        if (reference == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(9);
        }
        PsiElement element = reference.getElement();
        TextRange textRange = PhpRefactoringUtil.getVariableIdentifierRange(reference.getRangeInElement(), element);
        if (textRange == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    protected boolean performRefactoring() {
        if (!PhpLangUtil.equalsVariableNames(this.myOldName, this.myInsertedName) && this.myUsedVariableNames.contains(this.myInsertedName)) {
            CommonRefactoringUtil.showErrorHint((Project)this.myProject, (Editor)this.myEditor, (String)PhpBundle.message("conflict.variable.with.same.name.already.exists", new Object[0]), (String)"", null);
        }
        return super.performRefactoring();
    }

    @NotNull
    protected VariableInplaceRenamer createInplaceRenamerToRestart(PsiNamedElement variable, Editor editor, String initialName) {
        return new PhpVariableInplaceRenamer(variable, editor, this.myProject, initialName, this.myOldName);
    }

    @Nullable
    protected PsiElement checkLocalScope() {
        if (this.myElementToRename instanceof Parameter) {
            PhpClass clazz = PhpPsiUtil.getParentOfClass((PsiElement)this.myElementToRename, PhpClass.class);
            return clazz == null ? this.myElementToRename.getContainingFile() : null;
        }
        if (this.myElementToRename instanceof PhpGotoLabel) {
            Function function = PhpPsiUtil.getParentOfClass((PsiElement)this.myElementToRename, Function.class);
            if (function != null) {
                return function;
            }
            return this.myElementToRename.getContainingFile();
        }
        return super.checkLocalScope();
    }

    protected PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, @NotNull Collection<? extends PsiReference> refs, @NotNull Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset) {
        PsiElement element;
        if (refs == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(11);
        }
        if (stringUsages == null) {
            PhpVariableInplaceRenamer.$$$reportNull$$$0(12);
        }
        if ((element = PhpVariableInplaceRenamer.getSelectedInEditorElementInternal(nameIdentifier, refs, stringUsages, offset)) == null) {
            LOG.error(String.valueOf(nameIdentifier) + " by " + ((Object)((Object)this)).getClass().getName());
        }
        return element;
    }

    @Nullable
    static PsiElement getSelectedInEditorElementInternal(@Nullable PsiElement nameIdentifier, Collection<? extends PsiReference> refs, Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset) {
        TextRange range;
        for (PsiReference psiReference : refs) {
            PsiElement element = psiReference.getElement();
            if (!PhpVariableInplaceRenamer.checkRangeContainsOffset(offset, psiReference.getRangeInElement(), element, element.getTextOffset(), nameIdentifier)) continue;
            return element;
        }
        if (nameIdentifier != null && PhpVariableInplaceRenamer.checkRangeContainsOffset(offset, range = new TextRange(0, nameIdentifier.getTextLength()), nameIdentifier, nameIdentifier.getTextOffset(), nameIdentifier)) {
            return nameIdentifier;
        }
        for (Pair pair : stringUsages) {
            if (!PhpVariableInplaceRenamer.checkRangeContainsOffset(offset, (TextRange)pair.second, (PsiElement)pair.first, ((PsiElement)pair.first).getTextOffset(), nameIdentifier)) continue;
            return (PsiElement)pair.first;
        }
        return null;
    }

    protected boolean checkRangeContainsOffset(int offset, TextRange textRange, PsiElement element, int shiftOffset) {
        return PhpVariableInplaceRenamer.checkRangeContainsOffset(offset, textRange, element, shiftOffset, this.getNameIdentifier());
    }

    static boolean checkRangeContainsOffset(int offset, TextRange textRange, PsiElement element, int shiftOffset, PsiElement identifier) {
        PsiLanguageInjectionHost initialInjectedHost;
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject());
        PsiLanguageInjectionHost injectionHost = injectedLanguageManager.getInjectionHost(element);
        if (injectionHost == null) {
            return textRange.shiftRight(shiftOffset).containsOffset(offset);
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = initialInjectedHost = identifier != null ? injectedLanguageManager.getInjectionHost(identifier) : null;
        if (initialInjectedHost != null && initialInjectedHost != injectionHost) {
            return false;
        }
        int hostOffset = injectedLanguageManager.injectedToHost(element, shiftOffset);
        return textRange.shiftRight(hostOffset).containsOffset(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringUsages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpVariableInplaceRenamer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRefsInNearestScope";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToRename";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateAndStart";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSameVariable";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToRename";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedInEditorElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 10 -> new IllegalStateException(string);
        };
    }
}

