/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenameHandler;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpTraitUseRuleImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.rename.inplace.PhpMemberInplaceRenamer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMemberInplaceRenameHandler
extends MemberInplaceRenameHandler {
    protected boolean isAvailable(@Nullable PsiElement element, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            PhpMemberInplaceRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpMemberInplaceRenameHandler.$$$reportNull$$$0(1);
        }
        if (!editor.getSettings().isVariableInplaceRenameEnabled()) {
            return false;
        }
        if (element instanceof Field && ((Field)element).isConstant() || element instanceof Constant) {
            return true;
        }
        if (element instanceof PhpEnumCase) {
            return true;
        }
        if (element instanceof Method && ((Method)element).getMethodType(true) == Method.MethodType.CONSTRUCTOR) {
            int offset = editor.getCaretModel().getOffset();
            PsiElement identifier = ((Method)element).getNameIdentifier();
            if (identifier != null && identifier.getTextRange().containsOffset(offset)) {
                return false;
            }
        }
        if (element instanceof PhpTraitUseRuleImpl.TraitUseRuleRenameableFakePsiElement) {
            return false;
        }
        if (element instanceof Function && !((Function)element).isClosure()) {
            PsiReference reference = PhpRefactoringUtil.getReferenceAtCaret(element, editor);
            if (reference instanceof PhpCallbackReferenceBase) {
                return PhpLangUtil.equalsFunctionNames(((PhpNamedElement)element).getName(), reference.getCanonicalText());
            }
            return true;
        }
        if (element instanceof PhpClass && !((PhpClass)element).isAnonymous()) {
            PsiReference reference = PhpRefactoringUtil.getReferenceAtCaret(element, editor);
            String text = PhpMemberInplaceRenameHandler.getReferenceText(reference);
            return text == null || PhpLangUtil.equalsClassNames(((PhpNamedElement)element).getName(), text);
        }
        return element instanceof PhpUse && ((PhpUse)element).getAliasName() != null;
    }

    @Nullable
    private static String getReferenceText(@Nullable PsiReference reference) {
        if (reference instanceof PhpCallbackReferenceBase) {
            return reference.getCanonicalText();
        }
        if (reference instanceof ClassReference) {
            return ((ClassReference)reference).getName();
        }
        if (reference instanceof Variable) {
            return ((Variable)reference).getName();
        }
        return null;
    }

    @NotNull
    protected MemberInplaceRenamer createMemberRenamer(@NotNull PsiElement element, @NotNull PsiNameIdentifierOwner elementToRename, @NotNull Editor editor) {
        if (element == null) {
            PhpMemberInplaceRenameHandler.$$$reportNull$$$0(2);
        }
        if (elementToRename == null) {
            PhpMemberInplaceRenameHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            PhpMemberInplaceRenameHandler.$$$reportNull$$$0(4);
        }
        return new PhpMemberInplaceRenamer((PsiNamedElement)(PhpMemberInplaceRenameHandler.isConstructor(element, elementToRename) ? (PsiNamedElement)element : elementToRename), element, editor);
    }

    private static boolean isConstructor(@NotNull PsiElement substituted, PsiNameIdentifierOwner elementAtCaret) {
        if (substituted == null) {
            PhpMemberInplaceRenameHandler.$$$reportNull$$$0(5);
        }
        if (substituted instanceof PhpClass) {
            return elementAtCaret instanceof Method && ((Method)elementAtCaret).getMethodType(true) == Method.MethodType.CONSTRUCTOR;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRename";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substituted";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/rename/inplace/PhpMemberInplaceRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberRenamer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstructor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

