/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.rename;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.rename.PhpClassMemberRenameProcessor;
import com.jetbrains.php.refactoring.rename.PhpParameterRenameProcessor;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpFieldRenameProcessor
extends PhpClassMemberRenameProcessor {
    public boolean canProcessElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(0);
        }
        return element.isValid() && element instanceof Field && !(element instanceof PhpDocProperty);
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        Field field;
        PhpClass phpClass;
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(1);
        }
        if (newName == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(2);
        }
        if (conflicts == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(3);
        }
        if ((phpClass = (field = (Field)element).getContainingClass()) == null) {
            return;
        }
        for (Field ownField : phpClass.getOwnFields()) {
            String ownFieldName = ownField.getName();
            if (ownField == field) continue;
            if (field.isConstant() && ownField.isConstant() && PhpLangUtil.equalsConstantNames(newName, ownFieldName)) {
                conflicts.putValue((Object)ownField, (Object)PhpBundle.message("conflict.class.constant.with.same.name.already.exists", new Object[0]));
                return;
            }
            if (field.isConstant() || ownField.isConstant() || !PhpLangUtil.equalsFieldNames(newName, ownFieldName)) continue;
            conflicts.putValue((Object)ownField, (Object)PhpBundle.message("conflict.field.with.same.name.already.exists", new Object[0]));
            return;
        }
        if (element instanceof PhpPromotedFieldParameterImpl) {
            PhpParameterRenameProcessor.findExistingParameterNamesConflicts(element, newName, conflicts);
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(4);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FIELD;
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(5);
        }
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(6);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_NON_CODE_FOR_FIELD = enabled;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(7);
        }
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = enabled;
    }

    @Override
    protected boolean isSearchInGlobalScope() {
        return PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_GLOBAL_SCOPE_FOR_FIELD;
    }

    @Override
    protected void setSearchInGlobalScope(boolean enabled) {
        PhpRefactoringSettings.getInstance().RENAME_SEARCH_IN_GLOBAL_SCOPE_FOR_FIELD = enabled;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        PhpDocVariable variable;
        PhpDocComment comment;
        if (element == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(8);
        }
        if (searchScope == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(9);
        }
        Set references = super.findReferences(element, searchScope, searchInCommentsAndStrings);
        if (element instanceof Field && (comment = ((Field)element).getDocComment()) != null && (variable = (PhpDocVariable)PhpPsiUtil.getChildByCondition((PsiElement)comment.getVarTag(), (Condition<? super PsiElement>)PhpDocVariable.INSTANCEOF)) != null && PhpLangUtil.equalsVariableNames(variable.getNameCS(), ((Field)element).getNameCS())) {
            if (references.isEmpty()) {
                return new SmartList((Object)variable);
            }
            references = ContainerUtil.union(references, Set.of(variable));
        }
        if (element instanceof PhpPromotedFieldParameterImpl) {
            Set set = ContainerUtil.union(references, PhpParameterRenameProcessor.findReferencesFromNamedArguments(element));
            if (set == null) {
                PhpFieldRenameProcessor.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set set = references;
        if (set == null) {
            PhpFieldRenameProcessor.$$$reportNull$$$0(11);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/rename/PhpFieldRenameProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/rename/PhpFieldRenameProcessor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canProcessElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11 -> new IllegalStateException(string);
        };
    }
}

