/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.namespace;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.move.MoveCallback;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.refactoring.move.PhpMoveDelegateBase;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceDialog;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveNamespaceDelegate
extends PhpMoveDelegateBase {
    public static final String MOVE_NAMESPACE_ID = "move.namespace";

    public boolean canMove(PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable PsiReference reference) {
        if (elements.length == 1 && elements[0] instanceof PhpNamespace) {
            return targetContainer == null || super.canMove(elements, targetContainer, reference);
        }
        return false;
    }

    @Override
    public String getRefactoringName() {
        return PhpMoveNamespaceDelegate.getRefactoringNameText();
    }

    public void doMove(Project project, PsiElement[] elements, @Nullable PsiElement targetContainer, @Nullable MoveCallback callback) {
        if (elements.length == 1 && elements[0] instanceof PhpNamespace) {
            PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(project, MOVE_NAMESPACE_ID);
            PhpMoveNamespaceDialog dialog = new PhpMoveNamespaceDialog(project, (PhpNamespace)elements[0], false);
            if (!dialog.showAndGet()) {
                PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(project, MOVE_NAMESPACE_ID);
                return;
            }
            BaseRefactoringProcessor processor2 = dialog.createMoveProcessor();
            if (processor2 != null) {
                boolean previewUsages = dialog.isPreviewUsages();
                processor2.setPreviewUsages(previewUsages);
                processor2.run();
            }
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    @Nullable
    public String getActionName(PsiElement @NotNull [] elements) {
        if (elements == null) {
            PhpMoveNamespaceDelegate.$$$reportNull$$$0(0);
        }
        return PhpBundle.message("refactoring.move.namespace.action.name", new Object[0]);
    }

    @Nls
    static String getRefactoringNameText() {
        return PhpBundle.message("refactoring.move.namespace.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/jetbrains/php/refactoring/move/namespace/PhpMoveNamespaceDelegate", "getActionName"));
    }
}

