/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance.makeStaticThenMove;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.move.MoveToClassChooser;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDialog;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodProcessor;
import com.jetbrains.php.refactoring.move.member.instance.makeStaticThenMove.PhpMakeStaticThenMoveMethodProcessor;
import com.jetbrains.php.refactoring.move.statistics.PhpMoveRefactoringUsageCollector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveInstanceMethodDialog
extends RefactoringDialog {
    @NotNull
    private final Method myMethod;
    private MoveToClassChooser myChooser;
    private final MoveInstanceMethodActionType myMoveInstanceMethodActionType;

    public PhpMoveInstanceMethodDialog(@NotNull Method method, boolean makeStatic) {
        if (method == null) {
            PhpMoveInstanceMethodDialog.$$$reportNull$$$0(0);
        }
        super(method.getProject(), true);
        this.myMethod = method;
        this.myMoveInstanceMethodActionType = makeStatic ? MoveInstanceMethodActionType.MAKE_STATIC_THEN_MOVE : MoveInstanceMethodActionType.MOVE_UNUSED_INSTANCE_METHOD;
        this.setTitle(PhpBundle.message("refactoring.move.instance.method", new Object[0]));
        this.init();
    }

    protected void doAction() {
        Collection classes;
        String targetClassName = this.myChooser.getClassText();
        if (!this.validateInputData(targetClassName, classes = PhpIndex.getInstance((Project)this.myProject).getClassesByFQN(targetClassName))) {
            return;
        }
        PhpClass targetClass = (PhpClass)ContainerUtil.getOnlyItem((Collection)classes);
        if (targetClass == null) {
            return;
        }
        if (this.myMoveInstanceMethodActionType == MoveInstanceMethodActionType.MAKE_STATIC_THEN_MOVE) {
            this.invokeRefactoring(new PhpMakeStaticThenMoveMethodProcessor(this.myProject, this.myMethod, targetClass));
        } else if (this.myMoveInstanceMethodActionType == MoveInstanceMethodActionType.MOVE_UNUSED_INSTANCE_METHOD) {
            this.invokeRefactoring(new PhpMoveInstanceMethodProcessor(this.myProject, this.myMethod, null, targetClass, "AS_IS", this.getParameterName()));
        }
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringFinished(this.myProject, this.myMoveInstanceMethodActionType.myFusActionId);
    }

    private String getParameterName() {
        return this.myMethod.getContainingClass() != null ? "$" + StringUtil.decapitalize((String)this.myMethod.getContainingClass().getName()) : null;
    }

    public void doCancelAction() {
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringCancelled(this.myProject, this.myMoveInstanceMethodActionType.myFusActionId);
        super.doCancelAction();
    }

    public void show() {
        PhpMoveRefactoringUsageCollector.triggerMoveRefactoringStarted(this.myProject, this.myMoveInstanceMethodActionType.myFusActionId);
        super.show();
    }

    private boolean validateInputData(@NotNull String targetClassName, @NotNull Collection<PhpClass> classes) {
        String message;
        PhpClass fromClass;
        if (targetClassName == null) {
            PhpMoveInstanceMethodDialog.$$$reportNull$$$0(1);
        }
        if (classes == null) {
            PhpMoveInstanceMethodDialog.$$$reportNull$$$0(2);
        }
        if ((fromClass = this.myMethod.getContainingClass()) == null) {
            return false;
        }
        String string = message = targetClassName.isEmpty() ? PhpBundle.message("refactoring.move.members.is.not.a.valid.class.name", "") : PhpMoveMemberDialog.validateClassNames(fromClass, targetClassName, classes);
        if (message == null) {
            return true;
        }
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
        return false;
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.moveInstMethod";
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myChooser.getPreferredFocusedComponent();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 5));
        this.myChooser = new MoveToClassChooser(this.myProject, this.getDisposable(), (Condition<? super PhpClass>)((Condition)clazz -> !clazz.isInterface()), PhpBundle.message("refactoring.make.static.then.move.method.select", this.myMethod.getName()));
        panel.add((Component)this.myChooser.createPanel(), "North");
        if (this.myMoveInstanceMethodActionType == MoveInstanceMethodActionType.MOVE_UNUSED_INSTANCE_METHOD) {
            return panel;
        }
        String warnMessage = PhpBundle.message("refactoring.make.static.then.move.method.message", this.myMethod.getName());
        JBLabel warnLabel = new JBLabel(warnMessage, UIUtil.getBalloonWarningIcon(), 10);
        panel.add((Component)warnLabel, "South");
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/move/member/instance/makeStaticThenMove/PhpMoveInstanceMethodDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateInputData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum MoveInstanceMethodActionType {
        MAKE_STATIC_THEN_MOVE("make.static.then.move"),
        MOVE_UNUSED_INSTANCE_METHOD("move.unused.instance.method");

        public String myFusActionId;

        private MoveInstanceMethodActionType(String fusActionId) {
            this.myFusActionId = fusActionId;
        }
    }
}

