/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.member.instance.makeStaticThenMove;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpBaseRefactoringProcessor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodProcessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpMakeStaticThenMoveMethodProcessor
extends PhpBaseRefactoringProcessor {
    @NotNull
    private final Method myMethod;
    @NotNull
    private final PhpClass myTargetClass;
    @NotNull
    private final Set<PsiFile> myAffectedFiles;

    public PhpMakeStaticThenMoveMethodProcessor(@NotNull Project project, @NotNull Method method, @NotNull PhpClass targetClass) {
        if (project == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(0);
        }
        if (method == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(1);
        }
        if (targetClass == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(2);
        }
        super(project);
        this.myMethod = method;
        this.myTargetClass = targetClass;
        this.myAffectedFiles = new HashSet<PsiFile>();
    }

    @Override
    protected void performMainRefactoring(UsageInfo[] usages) {
        Method staticMethod = PhpMakeStaticProcessor.doMakeStaticWithDefaultSettings(this.myProject, this.myMethod, usages);
        PhpMoveMemberProcessor.performRefactoring(this.myProject, usages, Collections.singletonList(staticMethod), this.myTargetClass, staticMethod.getContainingClass());
        this.optimizeImports(this.myAffectedFiles);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(3);
        }
        UsageViewDescriptor usageViewDescriptor = PhpMoveInstanceMethodProcessor.createMoveInstanceMethodUsageViewDescriptor(this.myMethod);
        if (usageViewDescriptor == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(4);
        }
        return usageViewDescriptor;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(5);
        }
        this.myAffectedFiles.addAll(ContainerUtil.map((Object[])((UsageInfo[])refUsages.get()), UsageInfo::getFile));
        this.myAffectedFiles.add(this.myMethod.getContainingFile());
        this.myAffectedFiles.add(this.myTargetClass.getContainingFile());
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)this.myProject, this.myAffectedFiles, (boolean)true)) {
            return false;
        }
        PhpMoveMemberConflicts conflicts = new PhpMoveMemberConflicts(Collections.singleton(this.myMethod), this.myMethod.getContainingClass(), this.myTargetClass);
        conflicts.checkAlreadyDefinedMembers(this.myTargetClass);
        conflicts.checkFinalMethods(this.myTargetClass);
        conflicts.checkUsagesForConflicts((UsageInfo[])refUsages.get());
        conflicts.checkInternalReferences(this.myMethod);
        return this.showConflicts(conflicts.getConflicts(), (UsageInfo[])refUsages.get());
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = PhpMoveMemberProcessor.findUsages(Collections.singleton(this.myMethod));
        if (usageInfoArray == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(6);
        }
        return usageInfoArray;
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpBundle.message("refactoring.move.instance.method", new Object[0]);
        if (string == null) {
            PhpMakeStaticThenMoveMethodProcessor.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/member/instance/makeStaticThenMove/PhpMakeStaticThenMoveMethodProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/member/instance/makeStaticThenMove/PhpMakeStaticThenMoveMethodProcessor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

