/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.dnd;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpFileCreationInfo;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.PhpRefactoringSettings;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropHandlerDelegate;
import com.jetbrains.php.refactoring.move.dnd.PhpMoveClassesDragAndDropProcessor;
import com.jetbrains.php.refactoring.move.namespace.PhpMoveNamespaceDialog;
import com.jetbrains.php.refactoring.validation.PhpFilePathValidationException;
import com.jetbrains.php.roots.ui.PhpPsrDirectoryComboBox;
import com.jetbrains.php.roots.ui.PhpPsrNamespacePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpMoveClassesDragAndDropDialog
extends RefactoringDialog {
    private final PhpPsrNamespacePanel myDirectoryChoosePanel;
    private JCheckBox myCbSearchInComments;
    private JCheckBox myCbSearchTextOccurrences;
    private final Collection<PsiFileSystemItem> myElementsToMove;

    PhpMoveClassesDragAndDropDialog(@NotNull Project project, @NotNull Collection<PsiFileSystemItem> elementsToMove, @NotNull String suggestedNamespace, @NotNull VirtualFile target) {
        boolean hasClasses;
        if (project == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(0);
        }
        if (elementsToMove == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(1);
        }
        if (suggestedNamespace == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(2);
        }
        if (target == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(3);
        }
        super(project, false);
        this.myElementsToMove = elementsToMove;
        this.setTitle(PhpBundle.message("refactoring.move.classes.dnd.name", new Object[0]));
        boolean hasNamespace = ContainerUtil.find(this.myElementsToMove, PsiFileSystemItem::isDirectory) != null;
        boolean bl = hasClasses = ContainerUtil.find(this.myElementsToMove, PhpFile.class::isInstance) != null;
        int choice = hasNamespace && hasClasses ? 2 : (hasNamespace ? 1 : 0);
        String namespaceLabelText = PhpBundle.message("refactoring.move.classes.dnd.title", choice);
        this.myDirectoryChoosePanel = PhpMoveClassesDragAndDropDialog.getNamespacePanel(project, elementsToMove, suggestedNamespace, target, namespaceLabelText, JBUI.insets((int)2));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myDirectoryChoosePanel);
        this.init();
    }

    @NotNull
    public static PhpPsrNamespacePanel getNamespacePanel(@NotNull Project prj, @NotNull Collection<PsiFileSystemItem> elementsToMove, final @NotNull String suggestedNamespace, final @NotNull VirtualFile target, final @Nls String namespaceLabelText, @NotNull JBInsets insets) {
        if (prj == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(4);
        }
        if (elementsToMove == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(5);
        }
        if (suggestedNamespace == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(6);
        }
        if (target == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(7);
        }
        if (insets == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(8);
        }
        return new PhpPsrNamespacePanel(prj, suggestedNamespace, (PsiFileSystemItem)ContainerUtil.getFirstItem(elementsToMove), insets){

            @Override
            @NotNull
            protected JComponent createDirectoryPanel(@NotNull Project project, @NotNull PsiFileSystemItem fileOrDir) {
                PsiDirectory directory;
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fileOrDir == null) {
                    1.$$$reportNull$$$0(1);
                }
                PsiDirectory psiDirectory = directory = fileOrDir instanceof PsiDirectory ? (PsiDirectory)fileOrDir : ((PsiFile)fileOrDir).getContainingDirectory();
                assert (directory != null);
                this.myDirectoryField = new PhpPsrDirectoryComboBox(project){

                    @Override
                    @NotNull
                    public List<String> suggestDirectories(@NotNull String namespace, @NotNull VirtualFile directory) {
                        if (namespace == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (directory == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        List<String> list = Collections.singletonList(target.getPresentableUrl());
                        if (list == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 2 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "namespace";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "directory";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropDialog$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropDialog$1$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "suggestDirectories";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "suggestDirectories";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 2 -> new IllegalStateException(string);
                        };
                    }
                };
                this.myDirectoryField.init(directory.getVirtualFile(), suggestedNamespace);
                this.myDirectoryField.updateDirectories(this.getNamespaceName());
                JPanel subPanel = new JPanel(new BorderLayout());
                JBLabel label = new JBLabel(PhpBundle.message("refactoring.common.ui.target.directory.label", new Object[0]));
                label.setLabelFor((Component)((Object)this.myDirectoryField));
                subPanel.add((Component)label, "North");
                subPanel.add((Component)((Object)this.myDirectoryField), "Center");
                JBLabel completionLabel = new JBLabel(PhpBundle.message("refactoring.common.ui.target.directory.edit", new Object[0]), UIUtil.ComponentStyle.MINI);
                subPanel.add((Component)completionLabel, "South");
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)subPanel, "Center");
                JPanel jPanel = panel;
                if (jPanel == null) {
                    1.$$$reportNull$$$0(2);
                }
                return jPanel;
            }

            @Override
            @NotNull
            public String getNamespaceLabelText() {
                String string = namespaceLabelText;
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileOrDir";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropDialog$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropDialog$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createDirectoryPanel";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getNamespaceLabelText";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createDirectoryPanel";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    protected void doAction() {
        String newNamespaceName;
        this.rememberSettings();
        if (this.myCbSearchInComments.isSelected() || this.myCbSearchTextOccurrences.isSelected()) {
            this.setPreviewResults(true);
        }
        if (StringUtil.isNotEmpty((String)(newNamespaceName = PhpLangUtil.toPresentableFQN(this.myDirectoryChoosePanel.getNamespaceName()))) && !PhpNameUtil.isValidNamespaceFullName(newNamespaceName, PhpLanguageLevel.current((Project)this.myProject))) {
            this.showErrorMessage(PhpBundle.message("refactoring.common.validation.namespace.name", newNamespaceName));
            return;
        }
        try {
            this.invokeRefactoring(PhpMoveClassesDragAndDropDialog.createProcessor(this.myProject, this.myElementsToMove, newNamespaceName, this.myDirectoryChoosePanel.getSelectedDirectory(), this.myCbSearchInComments.isSelected(), this.myCbSearchTextOccurrences.isSelected()));
        }
        catch (PhpFilePathValidationException e) {
            this.showErrorMessage(e.getMessage());
        }
    }

    public static PhpMoveClassesDragAndDropProcessor createProcessor(Project project, Collection<PsiFileSystemItem> elementsToMove, String newNamespaceName, String targetDir, boolean searchInComments, boolean searchInTextOccurrences) throws PhpFilePathValidationException {
        HashMap<String, PhpMoveClassSettings> classFqnToSettings = new HashMap<String, PhpMoveClassSettings>();
        HashMap<PsiFile, PhpFileCreationInfo> nonPhpFilesToMove = new HashMap<PsiFile, PhpFileCreationInfo>();
        ArrayList<PhpClass> classesToMove = new ArrayList<PhpClass>();
        ArrayList<PsiDirectory> sourceDirs = new ArrayList<PsiDirectory>();
        for (PsiFileSystemItem elementToMove : elementsToMove) {
            Object relativePath;
            ArrayList<PsiFile> nonPhpFilesToMoveFromCurrentSelection = new ArrayList<PsiFile>();
            for (PhpClass clazz : PhpMoveClassesDragAndDropHandlerDelegate.extractClasses((PsiElement)elementToMove, nonPhpFilesToMoveFromCurrentSelection)) {
                relativePath = "";
                if (elementToMove instanceof PsiDirectory) {
                    relativePath = "/" + PhpMoveClassesDragAndDropHandlerDelegate.getRelativePath(elementToMove, clazz);
                }
                String fileName = clazz.getName() + "." + PhpFileType.INSTANCE.getDefaultExtension();
                PhpFileCreationInfo newFileConfiguration = PhpMoveClassesDragAndDropDialog.createNewFileConfig(project, fileName, targetDir, (String)relativePath);
                String destinationNamespace = PhpMoveClassesDragAndDropDialog.calculateDestinationNamespace(newNamespaceName, (String)relativePath);
                classFqnToSettings.put(clazz.getFQN(), new PhpMoveClassSettings(clazz, destinationNamespace, newFileConfiguration, false, true));
                classesToMove.add(clazz);
            }
            if (elementToMove instanceof PsiDirectory) {
                sourceDirs.add((PsiDirectory)elementToMove);
            }
            for (PsiFile file : nonPhpFilesToMoveFromCurrentSelection) {
                relativePath = "/" + PhpMoveNamespaceDialog.getRelativePath(elementToMove.getVirtualFile().getParent(), file.getVirtualFile().getParent().getPath());
                nonPhpFilesToMove.put(file, PhpMoveClassesDragAndDropDialog.createNewFileConfig(project, file.getName(), targetDir, (String)relativePath));
            }
        }
        return new PhpMoveClassesDragAndDropProcessor(project, sourceDirs, classesToMove, classFqnToSettings, nonPhpFilesToMove, (SearchScope)GlobalSearchScope.projectScope((Project)project), searchInComments, searchInTextOccurrences);
    }

    @NotNull
    private static String calculateDestinationNamespace(String newNamespaceName, String relativePath) {
        String destinationNamespace;
        String string = destinationNamespace = relativePath.isEmpty() ? newNamespaceName : newNamespaceName + relativePath.replace("/", "\\");
        if (PhpLangUtil.isGlobalNamespaceName(newNamespaceName)) {
            destinationNamespace = PhpLangUtil.toPresentableFQN(destinationNamespace);
        }
        String string2 = destinationNamespace;
        if (string2 == null) {
            PhpMoveClassesDragAndDropDialog.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private void rememberSettings() {
        PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_COMMENTS_AND_STRINGS = this.myCbSearchInComments.isSelected();
        PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_TEXT_OCCURRENCES = this.myCbSearchTextOccurrences.isSelected();
    }

    private static PhpFileCreationInfo createNewFileConfig(Project project, String fileName, String targetDir, String relativeDir) throws PhpFilePathValidationException {
        String directory = targetDir + relativeDir;
        return PhpFileCreationInfo.generateConfiguration(project, directory, fileName);
    }

    private void showErrorMessage(@NlsContexts.DialogMessage String message) {
        CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)message, (String)this.getHelpId(), (Project)this.myProject);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insetsBottom((int)8);
        gbConstraints.gridwidth = 2;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 1.0;
        gbConstraints.fill = 1;
        panel.add((Component)this.myDirectoryChoosePanel, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridwidth = 1;
        gbConstraints.gridx = 0;
        gbConstraints.weightx = 1.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.fill = 2;
        this.myCbSearchInComments = new NonFocusableCheckBox();
        this.myCbSearchInComments.setText(RefactoringBundle.getSearchInCommentsAndStringsText());
        this.myCbSearchInComments.setSelected(PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_COMMENTS_AND_STRINGS);
        panel.add((Component)this.myCbSearchInComments, gbConstraints);
        gbConstraints.insets = JBUI.insetsBottom((int)4);
        gbConstraints.gridwidth = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 2;
        this.myCbSearchTextOccurrences = new NonFocusableCheckBox();
        this.myCbSearchTextOccurrences.setText(RefactoringBundle.getSearchForTextOccurrencesText());
        this.myCbSearchTextOccurrences.setSelected(PhpRefactoringSettings.getInstance().MOVE_CLASS_SEARCH_IN_TEXT_OCCURRENCES);
        panel.add((Component)this.myCbSearchTextOccurrences, gbConstraints);
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDirectoryChoosePanel.getPreferredFocusedComponent();
    }

    @Nullable
    protected String getHelpId() {
        return "refactoring.moveclass.dnd";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToMove";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedNamespace";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prj";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/dnd/PhpMoveClassesDragAndDropDialog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDestinationNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNamespacePanel";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }
}

