/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.constant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantDelegate;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveFileConstantProcessor
extends BaseRefactoringProcessor {
    @NotNull
    private final Collection<Constant> myConstants;
    @NotNull
    private final PhpClass myTargetClass;

    public PhpMoveFileConstantProcessor(@NotNull Collection<Constant> constants, @NotNull PhpClass targetClass) {
        if (constants == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(0);
        }
        if (targetClass == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(1);
        }
        super(targetClass.getProject());
        this.myConstants = constants;
        this.myTargetClass = targetClass;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(2);
        }
        return new UsageViewDescriptor(){

            public PsiElement @NotNull [] getElements() {
                if (PsiElement.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PsiElement.EMPTY_ARRAY;
            }

            public String getProcessedElementsHeader() {
                return PhpBundle.message("refactoring.move.constant.label.text.field", "");
            }

            @NotNull
            public String getCodeReferencesText(int usagesCount, int filesCount) {
                String string = PhpBundle.message("refactoring.move.constant.label.text.field", UsageViewBundle.getReferencesString((int)usagesCount, (int)filesCount));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantProcessor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElements";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCodeReferencesText";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    protected UsageInfo @NotNull [] findUsages() {
        UsageInfo[] usageInfoArray = (UsageInfo[])StreamEx.of(this.myConstants).flatMap(constant -> PhpMoveFileConstantProcessor.findUsages(constant).stream()).toArray(UsageInfo.class);
        if (usageInfoArray == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(3);
        }
        return usageInfoArray;
    }

    @NotNull
    public static Collection<UsageInfo> findUsages(Constant constant) {
        List list = ContainerUtil.map((Collection)ReferencesSearch.search((PsiElement)constant).findAll(), UsageInfo::new);
        if (list == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(5);
        }
        SmartList possibleReferencesToMovedConstants = new SmartList();
        for (Constant constant : this.myConstants) {
            Field field = PhpMoveFileConstantProcessor.copyConstantToClass(this.myProject, constant, this.myTargetClass);
            if (field == null || field.getDefaultValue() == null) continue;
            possibleReferencesToMovedConstants.add(new UsageInfo(field.getDefaultValue()));
        }
        for (Constant constant : this.myConstants) {
            PhpMoveFileConstantProcessor.replaceUsages(ContainerUtil.concat(Arrays.asList(usages), (List)possibleReferencesToMovedConstants), constant, this.myTargetClass);
            PhpMoveFileConstantProcessor.deleteOriginalConstantDeclaration(constant);
        }
    }

    public static void deleteOriginalConstantDeclaration(Constant constant) {
        if (constant instanceof PhpDefine) {
            Statement statement = PhpPsiUtil.getParentOfClass((PsiElement)constant, false, Statement.class);
            if (statement != null) {
                statement.delete();
            }
        } else {
            PhpPsiElement constantsWrapper = (PhpPsiElement)PhpPsiUtil.getParentByCondition((PsiElement)constant, false, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.CONSTANTS)));
            assert (constantsWrapper != null);
            if (PhpPsiUtil.getChildren((PsiElement)constantsWrapper, (Condition<? super PsiElement>)Constant.INSTANCEOF).size() == 1) {
                constantsWrapper.delete();
            } else {
                PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)constant, PhpTokenTypes.opCOMMA);
            }
        }
    }

    @Nullable
    public static Field copyConstantToClass(Project project, Constant constant, PhpClass targetClass) {
        PhpPsiElement value = (PhpPsiElement)ObjectUtils.tryCast((Object)constant.getValue(), PhpPsiElement.class);
        if (value != null) {
            value = PhpMoveFileConstantProcessor.importReferences(project, value, targetClass);
        }
        PhpModifier modifier = PhpLanguageFeature.CLASS_CONSTANT_VISIBILITY.isSupported(project) ? PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC : null;
        PhpPsiElement classConstant = PhpPsiElementFactory.createClassConstant(project, modifier, constant.getName(), value != null ? value.getText() : "");
        PhpCodeEditUtil.insertClassMember(targetClass, (PsiElement)classConstant);
        return targetClass.findOwnFieldByName((CharSequence)constant.getName(), true);
    }

    private static PhpPsiElement importReferences(Project project, @NotNull PhpPsiElement value, PhpClass targetClass) {
        if (value == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(6);
        }
        List<PhpReference> classReferences = PhpPsiUtil.getChildren((PsiElement)value, (Condition<? super PsiElement>)PhpReference.INSTANCEOF);
        for (PhpReference reference : classReferences) {
            PhpMoveFileConstantProcessor.replaceReferenceWithResolvedImport(project, (PhpPsiElement)targetClass, reference);
        }
        if (value instanceof ConstantReference) {
            return PhpMoveFileConstantProcessor.replaceReferenceWithResolvedImport(project, (PhpPsiElement)targetClass, (PhpReference)((ConstantReference)value));
        }
        return value;
    }

    public static PhpPsiElement replaceReferenceWithResolvedImport(Project project, PhpPsiElement usageElement, PhpReference reference) {
        PsiElement resolved = reference.resolve();
        if (reference instanceof ClassReference && resolved instanceof Method && ((Method)resolved).getMethodType(true) == Method.MethodType.CONSTRUCTOR) {
            resolved = ((Method)resolved).getContainingClass();
        }
        if (resolved instanceof PhpClass) {
            String importedClassName = PhpMoveMemberProcessor.importClassAndGetName(usageElement, Collections.emptyList(), ((PhpClass)resolved).getFQN());
            return (PhpPsiElement)reference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, ClassReference.class, String.format("<?php new %s()", importedClassName)));
        }
        if (resolved instanceof Constant) {
            String name = PhpMoveMemberProcessor.addImportStatementAndGetName(usageElement, PhpGroupUseElement.PhpUseKeyword.CONSTANT, ((Constant)resolved).getFQN());
            return (PhpPsiElement)reference.replace((PsiElement)PhpPsiElementFactory.createConstantReference(project, name));
        }
        return reference;
    }

    public static void replaceUsages(@NotNull Collection<UsageInfo> usages, Constant constant, PhpClass targetClass) {
        if (usages == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(7);
        }
        SmartList usesToDelete = new SmartList();
        for (UsageInfo usage : usages) {
            PsiElement element = usage.getElement();
            if (!(element instanceof PhpReference) || !((PhpReference)element).isReferenceTo((PsiElement)constant)) continue;
            PhpUse use = PhpPsiUtil.getParentOfClass(element, PhpUse.class);
            if (use != null) {
                usesToDelete.add(use);
                continue;
            }
            String importedClassName = PhpMoveMemberProcessor.importClassAndGetName((PhpPsiElement)element, Collections.emptyList(), targetClass.getFQN());
            PhpMoveFileConstantProcessor.replaceWithConstantReference(element, importedClassName, constant.getName());
        }
        usesToDelete.forEach(PhpCodeEditUtil::deleteUse);
    }

    private static void replaceWithConstantReference(PsiElement element, String className, String constantName) {
        ClassConstantReference classConstantReference = PhpPsiElementFactory.createPhpPsiFromText(element.getProject(), ClassConstantReference.class, String.format("%s::%s", className, constantName));
        element.replace((PsiElement)classConstantReference);
    }

    @NotNull
    protected String getCommandName() {
        String string = PhpMoveFileConstantDelegate.getRefactoringNameText();
        if (string == null) {
            PhpMoveFileConstantProcessor.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constants";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantProcessor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/constant/PhpMoveFileConstantProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "importReferences";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "replaceUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 8 -> new IllegalStateException(string);
        };
    }
}

