/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.introduce.introduceVariable;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.intentions.PhpConvertShortArrowFunctionToClosureIntention;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.refactoring.PhpRefactoringUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodHandler;
import com.jetbrains.php.refactoring.introduce.PhpBaseInplaceIntroducer;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceContext;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableDialog;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableNameSuggestionProvider;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariablePresenter;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpIntroduceVariableSettings;
import com.jetbrains.php.refactoring.introduce.introduceVariable.PhpVariableInplaceIntroducer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpIntroduceVariableHandler
extends PhpIntroduceBaseHandler<PhpIntroduceVariableSettings, PhpIntroduceVariablePresenter> {
    protected static final Logger LOG = Logger.getInstance(PhpIntroduceVariableHandler.class);

    @NotNull
    public static Statement getVariableDeclaration(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings, String elementDeclarationText) {
        Statement statement = PhpPsiElementFactory.createStatement(introduceContext.getProject(), "$" + settings.getName() + "=" + elementDeclarationText + ";\n");
        if (statement == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(0);
        }
        return statement;
    }

    @NotNull
    private static PsiElement getNewExpressionForOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        Variable variable = PhpPsiElementFactory.createVariable(introduceContext.getProject(), settings.getName(), true);
        if (variable == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(1);
        }
        return variable;
    }

    @NotNull
    public static PsiElement getNewExpressionForOriginalElement(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        if (introduceContext.isPhysical() || introduceContext.getPhysicalElement() instanceof NewExpression) {
            return PhpIntroduceVariableHandler.getNewExpressionForOccurrences(introduceContext, settings);
        }
        if (introduceContext.getPhysicalElement() instanceof BinaryExpression) {
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoBinaryExpression((BinaryExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(2);
            }
            return phpPsiElement;
        }
        if (PhpPsiUtil.isOfType(introduceContext.getPhysicalElement(), PhpElementTypes.STRING)) {
            if (settings.isEmbedVariable()) {
                PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoStringByEmbeding((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
                if (phpPsiElement == null) {
                    PhpIntroduceVariableHandler.$$$reportNull$$$0(3);
                }
                return phpPsiElement;
            }
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoStringByConcatenation((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(4);
            }
            return phpPsiElement;
        }
        if (PhpPsiUtil.isOfType(introduceContext.getPhysicalElement(), PhpElementTypes.HEREDOC)) {
            PhpPsiElement phpPsiElement = PhpIntroduceVariableHandler.insertIntoHeredoc((StringLiteralExpression)introduceContext.getPhysicalElement(), introduceContext.getLogicalElementRange(), "$" + settings.getName());
            if (phpPsiElement == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(5);
            }
            return phpPsiElement;
        }
        assert (false);
        if (null == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(6);
        }
        return null;
    }

    @Nullable
    private static Statement getParentStatement(@NotNull PsiElement element) {
        if (element == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(7);
        }
        for (PsiElement curElement = element; curElement != null; curElement = curElement.getParent()) {
            if (!(curElement instanceof Statement) || curElement instanceof ElseIf || curElement instanceof Include || curElement instanceof PhpYield) continue;
            return (Statement)curElement;
        }
        return null;
    }

    @Nullable
    private static PsiElement isDeleteSelf(@NotNull PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings) {
        IElementType grandParentNodeType;
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(8);
        }
        if (!introduceContext.isPhysical() || settings.getReplaceChoice() != OccurrencesChooser.ReplaceChoice.NO) {
            return null;
        }
        PsiElement anchor = introduceContext.getPhysicalElement();
        PsiElement parent = anchor.getParent();
        IElementType parentNodeType = PsiUtilCore.getElementType((PsiElement)parent);
        IElementType iElementType = grandParentNodeType = parent == null ? null : PsiUtilCore.getElementType((PsiElement)parent.getParent());
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentNodeType)) {
            return anchor;
        }
        if (PhpElementTypes.STATEMENT == parentNodeType && PhpElementTypes.ANY_GROUP_STATEMENT.contains(grandParentNodeType)) {
            return parent;
        }
        return null;
    }

    @Override
    @NotNull
    protected List<PsiElement> collectIntroducibleElements(PhpIntroduceContext context) {
        int offset = context.getEditor().getCaretModel().getOffset();
        PhpExpression expression = PhpExtractMethodHandler.getExtractableExpressionFromAssignmentRHS(offset, context.getPhysicalElement());
        if (expression != null) {
            List<PhpExpression> list = Collections.singletonList(expression);
            if (list == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(9);
            }
            return list;
        }
        List<PsiElement> list = super.collectIntroducibleElements(context);
        if (list == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static void replaceOccurrences(PhpIntroduceContext introduceContext, PhpIntroduceVariableSettings settings, PsiElement expressionForOriginalElement) {
        if (settings.getReplaceChoice() != OccurrencesChooser.ReplaceChoice.NO) {
            PsiElement expressionForOccurrences = introduceContext.isPhysical() ? expressionForOriginalElement : PhpIntroduceVariableHandler.getNewExpressionForOccurrences(introduceContext, settings);
            for (PsiElement occurrence : introduceContext.getOccurrences(settings.getReplaceChoice())) {
                occurrence.replace(expressionForOccurrences);
            }
        }
    }

    @Override
    @Nls
    public String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.variable.name", new Object[0]);
    }

    @Override
    protected String getFeatureId() {
        return "refactoring.introduceVariable";
    }

    @Override
    @Nullable
    protected PsiElement findScope(@NotNull PsiElement element) {
        PsiNamedElement scope;
        if (element == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(11);
        }
        if ((scope = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PhpClass.class, PhpFile.class, Function.class, Method.class, PhpNamespace.class})) instanceof PhpClass) {
            return null;
        }
        return scope;
    }

    @Override
    protected boolean isSupportedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(12);
        }
        return !PhpPsiUtil.isOfType(expression, PhpElementTypes.HASH_ARRAY_ELEMENT);
    }

    @Override
    protected boolean isSupportedScope(@Nullable PsiElement scope, @NotNull PsiElement expression) {
        if (expression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(13);
        }
        return scope != null;
    }

    @Override
    protected boolean isSupportedContext(@NotNull PsiElement context, @NotNull PsiElement logicalExpression, @NotNull PsiElement physicalExpression) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(14);
        }
        if (logicalExpression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(15);
        }
        if (physicalExpression == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(16);
        }
        if (context instanceof Parameter) {
            return false;
        }
        if (context instanceof Constant) {
            return context instanceof PhpDefine;
        }
        return PhpPsiUtil.getParentOfClass(physicalExpression, PhpAttribute.class) == null;
    }

    @Override
    protected Collection<PsiElement> getOccurrences(@NotNull PsiElement scope, @NotNull PsiElement sample, boolean isPhysical, @NotNull PsiElement sampleContext, @NotNull TextRange elementRange, @NotNull PhpIntroduceContext introduceContext) {
        if (scope == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(17);
        }
        if (sample == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(18);
        }
        if (sampleContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(19);
        }
        if (elementRange == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(20);
        }
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(21);
        }
        return this.getOccurrences(scope, sample, isPhysical, sampleContext, elementRange);
    }

    public Collection<PsiElement> getOccurrences(@NotNull PsiElement scope, @NotNull PsiElement sample, boolean isPhysical, @NotNull PsiElement sampleContext, @NotNull TextRange elementRange) {
        if (scope == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(22);
        }
        if (sample == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(23);
        }
        if (sampleContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(24);
        }
        if (elementRange == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(25);
        }
        PhpIntroduceBaseHandler.OccurrencesCollector collector = new PhpIntroduceBaseHandler.OccurrencesCollector(scope, sample, isPhysical, sampleContext, elementRange){

            @Override
            protected boolean processContext(PsiElement element) {
                return !(element instanceof PhpClass) && !(element instanceof Function) && !(element instanceof Field);
            }
        };
        return collector.getOccurrences();
    }

    @Override
    @NotNull
    protected PhpIntroduceVariablePresenter getPresenter(PhpIntroduceContext introduceContext) {
        return new PhpIntroduceVariablePresenter(new PhpIntroduceVariableDialog(introduceContext.getProject()), this, introduceContext);
    }

    @Nullable
    public static PsiElement findAnchor(PhpIntroduceContext introduceContext, OccurrencesChooser.BaseReplaceChoice replaceChoice) {
        Statement anchor;
        block6: {
            Statement commonStatement;
            if (replaceChoice != OccurrencesChooser.ReplaceChoice.NO) {
                PsiElement[] introducedExpressions = (PsiElement[])ArrayUtil.append((Object[])PsiUtilCore.toPsiElementArray(introduceContext.getOccurrences(replaceChoice)), (Object)introduceContext.getPhysicalElement());
                commonStatement = PhpIntroduceVariableHandler.getParentStatement(Objects.requireNonNull(PsiTreeUtil.findCommonParent((PsiElement[])introducedExpressions)));
            } else {
                commonStatement = PhpIntroduceVariableHandler.getParentStatement(introduceContext.getPhysicalElement());
            }
            if (commonStatement instanceof GroupStatement) {
                ArrayList<PsiElement> introducedExpressions = new ArrayList<PsiElement>(introduceContext.getOccurrences(replaceChoice));
                introducedExpressions.add(introduceContext.getPhysicalElement());
                for (anchor = commonStatement.getFirstPsiChild(); anchor != null; anchor = anchor.getNextPsiSibling()) {
                    for (PsiElement curExpression : introducedExpressions) {
                        if (!PsiTreeUtil.isAncestor((PsiElement)anchor, (PsiElement)curExpression, (boolean)false)) continue;
                        break block6;
                    }
                }
            } else {
                anchor = commonStatement;
            }
        }
        return anchor;
    }

    @Override
    protected void chooseTargetBlockAndPerformIntroduce(final PhpIntroduceContext introduceContext, final Consumer<PhpIntroduceContext> performIntroduceCallback) {
        Function function = (Function)ObjectUtils.tryCast((Object)introduceContext.getContext(), Function.class);
        if (function != null && FunctionImpl.isShortArrowFunction(function) && PhpSideEffectDetector.canContainSideEffect(introduceContext.getPhysicalElement())) {
            PsiElement anchor = PhpIntroduceVariableHandler.findAnchor(introduceContext, (OccurrencesChooser.BaseReplaceChoice)OccurrencesChooser.ReplaceChoice.NO);
            final PhpExpression bodyExpression = (PhpExpression)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
            if (anchor != null && !ApplicationManager.getApplication().isUnitTestMode()) {
                List<PsiElement> expressions = Arrays.asList(bodyExpression, anchor.getParent());
                IntroduceTargetChooser.showChooser((Editor)introduceContext.getEditor(), expressions, (Pass)new Pass<PsiElement>(){

                    public void pass(PsiElement element) {
                        introduceContext.setTransformArrowFunction(element == bodyExpression);
                        performIntroduceCallback.accept(introduceContext);
                    }
                }, element -> element == bodyExpression ? PhpBundle.message("popup.select.target.code.block.closure", new Object[0]) : PhpBundle.message("popup.select.target.code.block.containing.block", new Object[0]), (String)PhpBundle.message("popup.title.select.target.code.block", new Object[0]));
                return;
            }
            introduceContext.setTransformArrowFunction(true);
        }
        super.chooseTargetBlockAndPerformIntroduce(introduceContext, performIntroduceCallback);
    }

    @Override
    @Nullable
    public PhpIntroduceBaseHandler.PhpIntroduceResult doRefactoring(@NotNull PhpIntroduceContext introduceContext, @NotNull PhpIntroduceVariableSettings settings) {
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(26);
        }
        if (settings == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(27);
        }
        super.doRefactoring(introduceContext, settings);
        Function function = (Function)ObjectUtils.tryCast((Object)introduceContext.getContext(), Function.class);
        if (function != null && introduceContext.isTransformArrowFunction()) {
            introduceContext = this.replaceShortArrowFunctionWithClosure(introduceContext, function);
        }
        PsiElement deleteSelf = PhpIntroduceVariableHandler.isDeleteSelf(introduceContext, settings);
        Statement assignStatement = PhpIntroduceVariableHandler.getVariableDeclaration(introduceContext, settings, introduceContext.getElementDeclarationText());
        if (deleteSelf != null) {
            return new PhpIntroduceBaseHandler.PhpIntroduceResult(introduceContext, deleteSelf.replace((PsiElement)assignStatement), null, null);
        }
        PsiElement expressionForOriginalElement = PhpIntroduceVariableHandler.getNewExpressionForOriginalElement(introduceContext, settings);
        PsiElement anchor = PhpIntroduceVariableHandler.replaceAnchor(introduceContext, expressionForOriginalElement, PhpIntroduceVariableHandler.findAnchor(introduceContext, settings.getReplaceChoice()));
        if (anchor != null) {
            Statement result = PhpCodeEditUtil.putStatementBefore(anchor, assignStatement);
            PhpIntroduceVariableHandler.replaceOccurrences(introduceContext, settings, expressionForOriginalElement);
            return new PhpIntroduceBaseHandler.PhpIntroduceResult(introduceContext, (PsiElement)result, null, null);
        }
        this.showErrorHint(introduceContext.getProject(), introduceContext.getEditor(), PhpBundle.message("refactoring.common.not.supported.expression.in.scope", this.getRefactoringName()));
        return null;
    }

    @NotNull
    private PhpIntroduceContext replaceShortArrowFunctionWithClosure(@NotNull PhpIntroduceContext introduceContext, @NotNull Function function) {
        block8: {
            if (introduceContext == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(28);
            }
            if (function == null) {
                PhpIntroduceVariableHandler.$$$reportNull$$$0(29);
            }
            PsiElement physicalElement = introduceContext.getPhysicalElement();
            Function closure = PhpConvertShortArrowFunctionToClosureIntention.convertArrowFunctionToClosure(introduceContext.getProject(), function);
            GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)closure, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            assert (body != null);
            PsiElement returnStatement = body.getOnlyStatement();
            if (returnStatement instanceof PhpReturn) {
                PhpIntroduceContext phpIntroduceContext;
                PsiElement element = (PsiElement)ContainerUtil.find((Iterable)PsiTreeUtil.findChildrenOfAnyType((PsiElement)returnStatement, (Class[])new Class[]{physicalElement.getClass()}), e -> e.getText().equals(physicalElement.getText()));
                try {
                    phpIntroduceContext = this.getIntroduceContext(introduceContext.getEditor(), element);
                }
                catch (PhpIntroduceBaseHandler.RefactoringErrorException e2) {
                    if ($assertionsDisabled) break block8;
                    throw new AssertionError((Object)"Failed to update introduce context after short-arrow function -> closure conversion");
                }
                if (phpIntroduceContext == null) {
                    PhpIntroduceVariableHandler.$$$reportNull$$$0(30);
                }
                return phpIntroduceContext;
            }
        }
        PhpIntroduceContext phpIntroduceContext = introduceContext;
        if (phpIntroduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(31);
        }
        return phpIntroduceContext;
    }

    @Nullable
    public static PsiElement replaceAnchor(PhpIntroduceContext introduceContext, PsiElement expressionForOriginalElement, @Nullable PsiElement anchor) {
        if (anchor == null) {
            return null;
        }
        PsiElement physicalElement = introduceContext.getPhysicalElement();
        if (anchor == physicalElement) {
            anchor = physicalElement.replace(expressionForOriginalElement);
        } else {
            physicalElement.replace(expressionForOriginalElement);
        }
        return anchor;
    }

    @Override
    protected boolean canPerformInplaceIntroduce(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(32);
        }
        return !PhpRefactoringUtil.isEmbedVariableAllowed(context);
    }

    @Override
    @NotNull
    protected PhpBaseInplaceIntroducer<? extends PhpNamedElement, PhpIntroduceVariableSettings> getInplaceIntroducer(@NotNull PhpIntroduceContext context, @NotNull PhpIntroduceVariableSettings settings) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(33);
        }
        if (settings == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(34);
        }
        return new PhpVariableInplaceIntroducer(this, context, settings);
    }

    @Override
    @NotNull
    protected PhpIntroduceVariableSettings getInplaceIntroduceSettings(final @NotNull PhpIntroduceContext introduceContext, final OccurrencesChooser.BaseReplaceChoice choice) {
        if (introduceContext == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(35);
        }
        return new PhpIntroduceVariableSettings(){

            @Override
            public OccurrencesChooser.BaseReplaceChoice getReplaceChoice() {
                return choice;
            }

            @Override
            public boolean isEmbedVariable() {
                return false;
            }

            @Override
            public String getName() {
                String[] names = new PhpIntroduceVariableNameSuggestionProvider(introduceContext, PhpIntroduceVariableHandler.getOccupiedElements(introduceContext)).getSuggestedNames();
                return names.length > 0 ? names[0] : "x";
            }
        };
    }

    @NotNull
    public static Set<? extends PhpNamedElement> getOccupiedElements(@NotNull PhpIntroduceContext context) {
        if (context == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(36);
        }
        Set<? extends PhpNamedElement> set = VariableImpl.collectDeclarations(context.getPhysicalElement(), true, null);
        if (set == null) {
            PhpIntroduceVariableHandler.$$$reportNull$$$0(37);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 32, 33, 34, 35, 36 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpIntroduceVariableHandler";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 21: 
            case 26: 
            case 28: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "introduceContext";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: 
            case 32: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logicalExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physicalExpression";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleContext";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementRange";
                break;
            }
            case 27: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOccurrences";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewExpressionForOriginalElement";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/introduce/introduceVariable/PhpIntroduceVariableHandler";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectIntroducibleElements";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceShortArrowFunctionWithClosure";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccupiedElements";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getParentStatement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDeleteSelf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findScope";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedExpression";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedScope";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedContext";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrences";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "replaceShortArrowFunctionWithClosure";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canPerformInplaceIntroduce";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroducer";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getInplaceIntroduceSettings";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getOccupiedElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 32, 33, 34, 35, 36 -> new IllegalArgumentException(string);
        };
    }
}

