/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodParameterInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpParametersFolder {
    private final Map<PhpExtractMethodParameterInfo, PhpExpression> myParameterToReplacement = new HashMap<PhpExtractMethodParameterInfo, PhpExpression>();
    private boolean myIsFoldingSelected = true;

    void foldParametersIfNeeded(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull List<PhpExtractMethodParameterInfo> parameterItems) {
        if (fragment == null) {
            PhpParametersFolder.$$$reportNull$$$0(0);
        }
        if (inputVariables == null) {
            PhpParametersFolder.$$$reportNull$$$0(1);
        }
        if (parameterItems == null) {
            PhpParametersFolder.$$$reportNull$$$0(2);
        }
        if (!this.myIsFoldingSelected) {
            return;
        }
        for (PhpExtractMethodParameterInfo parameterInfo : parameterItems) {
            this.foldParameter(fragment, inputVariables, parameterInfo);
        }
    }

    private void foldParameter(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, PhpExtractMethodParameterInfo parameterInfo) {
        PhpPsiElement parameter;
        if (fragment == null) {
            PhpParametersFolder.$$$reportNull$$$0(3);
        }
        if (inputVariables == null) {
            PhpParametersFolder.$$$reportNull$$$0(4);
        }
        if ((parameter = parameterInfo.getInputVariable()) == null) {
            return;
        }
        PhpScopeHolder scopeHolder = fragment.getScopeHolder();
        LocalSearchScope searchScope = new LocalSearchScope((PsiElement)scopeHolder);
        ArrayAccessExpression expressionForFolding = PhpParametersFolder.findCommonUsagePattern(parameter, inputVariables, (SearchScope)searchScope, fragment, scopeHolder);
        if (expressionForFolding == null) {
            return;
        }
        String suggestedName = PhpParametersFolder.suggestParameterName(parameter, expressionForFolding);
        if (suggestedName != null && suggestedName != parameterInfo.getName()) {
            parameterInfo.setNewName(suggestedName);
        }
        parameterInfo.updateType("");
        this.myParameterToReplacement.put(parameterInfo, (PhpExpression)expressionForFolding);
    }

    public void foldParameterUsagesInBodyIfNeeded(@Nullable PsiElement definition, @NotNull Set<PhpPsiElement> inputVariables) {
        Parameter[] parameters;
        if (inputVariables == null) {
            PhpParametersFolder.$$$reportNull$$$0(5);
        }
        if (!this.myIsFoldingSelected) {
            return;
        }
        if (!(definition instanceof Function)) {
            return;
        }
        Function function = (Function)definition;
        for (Parameter parameter : parameters = function.getParameters()) {
            ArrayAccessExpression expressionForFolding = PhpParametersFolder.findCommonUsagePattern((PhpPsiElement)parameter, inputVariables, parameter.getUseScope(), null, (PhpScopeHolder)function);
            if (expressionForFolding == null) continue;
            Variable refExpression = PhpPsiElementFactory.createVariable(expressionForFolding.getProject(), parameter.getName(), true);
            ArrayList<ArrayAccessExpression> expressionsToReplace = new ArrayList<ArrayAccessExpression>();
            for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)parameter.getUseScope()).asIterable()) {
                ArrayAccessExpression expression = PhpParametersFolder.findEquivalentAncestor(reference.getElement(), expressionForFolding);
                if (expression == null) continue;
                expressionsToReplace.add(expression);
            }
            for (ArrayAccessExpression accessExpression : expressionsToReplace) {
                accessExpression.replace((PsiElement)refExpression);
            }
        }
    }

    @NotNull
    public List<CharSequence> generateCallArguments(@NotNull List<PhpExtractMethodParameterInfo> parameters) {
        if (parameters == null) {
            PhpParametersFolder.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.map(parameters, parameter -> {
            PhpExpression expression = this.myParameterToReplacement.get(parameter);
            if (expression != null) {
                return expression.getText();
            }
            return "$" + String.valueOf(parameter.getName());
        });
        if (list == null) {
            PhpParametersFolder.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setFoldingSelected(boolean foldingSelected) {
        this.myIsFoldingSelected = foldingSelected;
        this.myParameterToReplacement.clear();
    }

    public boolean isParametersFoldable() {
        return !this.myParameterToReplacement.isEmpty();
    }

    public boolean isParameterSafeToDelete(@NotNull PhpExtractMethodCodeFragment fragment, @NotNull PhpExtractMethodParameterInfo parameter) {
        PhpPsiElement sourceVariable;
        if (fragment == null) {
            PhpParametersFolder.$$$reportNull$$$0(8);
        }
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(9);
        }
        if ((sourceVariable = parameter.getInputVariable()) == null) {
            return false;
        }
        for (PsiReference reference : ReferencesSearch.search((PsiElement)sourceVariable, (SearchScope)new LocalSearchScope((PsiElement)fragment.getScopeHolder())).asIterable()) {
            PsiElement element = reference.getElement();
            if (!fragment.contains(element.getTextRange()) || this.isUsedInExpressionsForFolding(element, parameter)) continue;
            return false;
        }
        return true;
    }

    private boolean isUsedInExpressionsForFolding(@NotNull PsiElement referenceElement, @NotNull PhpExtractMethodParameterInfo parameter) {
        PhpExpression parameterReplacement;
        if (referenceElement == null) {
            PhpParametersFolder.$$$reportNull$$$0(10);
        }
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(11);
        }
        return PhpPsiUtil.getParentByCondition(referenceElement, false, (Condition<? super PsiElement>)((Condition)arg_0 -> this.lambda$isUsedInExpressionsForFolding$1(parameterReplacement = this.myParameterToReplacement.get(parameter), arg_0)), (Condition<? super PsiElement>)Statement.INSTANCEOF) != null;
    }

    private boolean isEquivalentToExpressionForFolding(PsiElement element, PhpExpression parameterReplacement) {
        return this.myParameterToReplacement.values().stream().anyMatch(replacement -> replacement != parameterReplacement && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)element, (PsiElement)replacement));
    }

    private static String suggestParameterName(@NotNull PhpPsiElement parameter, @NotNull ArrayAccessExpression expressionForFolding) {
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(12);
        }
        if (expressionForFolding == null) {
            PhpParametersFolder.$$$reportNull$$$0(13);
        }
        Set<? extends PhpNamedElement> declarations = VariableImpl.collectDeclarations((PsiElement)parameter, false, null);
        Set<String> occupiedNames = declarations.stream().map(element -> element.getName()).collect(Collectors.toSet());
        List<String> suggestedNames = PhpNameSuggestionUtil.variableNameByValue((PsiElement)expressionForFolding);
        if (suggestedNames.isEmpty()) {
            suggestedNames = PhpNameSuggestionUtil.variableNameByPlace((PsiElement)expressionForFolding);
        }
        suggestedNames = new ArrayList<String>(suggestedNames);
        PhpNameUtil.unique(suggestedNames, occupiedNames);
        return (String)ContainerUtil.getFirstItem(suggestedNames);
    }

    @Nullable
    private static ArrayAccessExpression findCommonUsagePattern(@NotNull PhpPsiElement parameter, @NotNull Collection<PhpPsiElement> inputParameters, @NotNull SearchScope scope, @Nullable PhpExtractMethodCodeFragment fragment, @NotNull PhpScopeHolder scopeHolder) {
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(14);
        }
        if (inputParameters == null) {
            PhpParametersFolder.$$$reportNull$$$0(15);
        }
        if (scope == null) {
            PhpParametersFolder.$$$reportNull$$$0(16);
        }
        if (scopeHolder == null) {
            PhpParametersFolder.$$$reportNull$$$0(17);
        }
        if (PhpParametersFolder.isAccessedForWriting(parameter, scopeHolder, fragment)) {
            return null;
        }
        SmartList arrayAccessExpressions = PhpParametersFolder.findArrayAccessUsages(parameter, scope, fragment);
        ArrayAccessExpression commonPattern = null;
        ArrayAccessExpression candidate = (ArrayAccessExpression)ContainerUtil.getFirstItem(arrayAccessExpressions);
        while (candidate != null) {
            if (PhpParametersFolder.dependsOnLocals(candidate, inputParameters) || PhpSideEffectDetector.canContainSideEffect((PsiElement)candidate.getIndex())) {
                return commonPattern;
            }
            for (int i = 1; i < arrayAccessExpressions.size(); ++i) {
                if (PhpParametersFolder.findEquivalentAncestor((PsiElement)candidate, arrayAccessExpressions.get(i)) != null) continue;
                return commonPattern;
            }
            commonPattern = candidate;
            SmartList parentArrayAccessExpressions = new SmartList();
            for (ArrayAccessExpression expression : arrayAccessExpressions) {
                ArrayAccessExpression parentAccess = (ArrayAccessExpression)ObjectUtils.tryCast((Object)PhpParametersFolder.getParentSkipParentheses((PsiElement)expression), ArrayAccessExpression.class);
                if (parentAccess == null) {
                    return commonPattern;
                }
                parentArrayAccessExpressions.add(parentAccess);
            }
            arrayAccessExpressions = parentArrayAccessExpressions;
            candidate = (ArrayAccessExpression)ContainerUtil.getFirstItem((List)arrayAccessExpressions);
        }
        return commonPattern;
    }

    @NotNull
    private static List<ArrayAccessExpression> findArrayAccessUsages(@NotNull PhpPsiElement parameter, @NotNull SearchScope scope, @Nullable PhpExtractMethodCodeFragment fragment) {
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            PhpParametersFolder.$$$reportNull$$$0(19);
        }
        ArrayList<ArrayAccessExpression> usages = new ArrayList<ArrayAccessExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)parameter, (SearchScope)scope).asIterable()) {
            PsiElement element = reference.getElement();
            if (fragment != null && !fragment.contains(element.getTextRange())) continue;
            ArrayAccessExpression expression = PhpPsiUtil.getParentOfClass(element, ArrayAccessExpression.class);
            if (expression == null) {
                List<ArrayAccessExpression> list = Collections.emptyList();
                if (list == null) {
                    PhpParametersFolder.$$$reportNull$$$0(20);
                }
                return list;
            }
            if (!PhpParametersFolder.isArrayAccessToParameter(parameter, expression)) {
                List<ArrayAccessExpression> list = Collections.emptyList();
                if (list == null) {
                    PhpParametersFolder.$$$reportNull$$$0(21);
                }
                return list;
            }
            usages.add(expression);
        }
        ArrayList<ArrayAccessExpression> arrayList = usages;
        if (arrayList == null) {
            PhpParametersFolder.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static boolean isAccessedForWriting(final @NotNull PhpPsiElement parameter, @NotNull PhpScopeHolder scopeHolder, final @Nullable PhpExtractMethodCodeFragment fragment) {
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(23);
        }
        if (scopeHolder == null) {
            PhpParametersFolder.$$$reportNull$$$0(24);
        }
        final Ref hasWriteAccessRef = new Ref((Object)false);
        PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                PhpPsiElement expression = instruction.getAnchor();
                if (!(expression instanceof VariableImpl)) {
                    return true;
                }
                if (fragment != null && !fragment.contains(expression.getTextRange())) {
                    return true;
                }
                if (!Objects.equals(expression.getName(), parameter.getName())) {
                    return true;
                }
                if (PhpWorkaroundUtil.getArrayAccess(instruction).isRead()) {
                    return true;
                }
                hasWriteAccessRef.set((Object)true);
                return false;
            }
        });
        return (Boolean)hasWriteAccessRef.get();
    }

    @Nullable
    private static ArrayAccessExpression findEquivalentAncestor(@NotNull PsiElement element, @NotNull ArrayAccessExpression expressionToFind) {
        if (element == null) {
            PhpParametersFolder.$$$reportNull$$$0(25);
        }
        if (expressionToFind == null) {
            PhpParametersFolder.$$$reportNull$$$0(26);
        }
        return (ArrayAccessExpression)PhpPsiUtil.getParentByCondition(element, false, (Condition<? super PsiElement>)((Condition)psiElement -> PsiEquivalenceUtil.areElementsEquivalent((PsiElement)expressionToFind, (PsiElement)psiElement)), (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    @Nullable
    public static PsiElement getParentSkipParentheses(@NotNull PsiElement element) {
        if (element == null) {
            PhpParametersFolder.$$$reportNull$$$0(27);
        }
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)((Condition)psiElement -> !(psiElement instanceof ParenthesizedExpression)), (Condition<? super PsiElement>)Statement.INSTANCEOF);
    }

    private static boolean isArrayAccessToParameter(@NotNull PhpPsiElement parameter, @NotNull ArrayAccessExpression expression) {
        VariableImpl value;
        if (parameter == null) {
            PhpParametersFolder.$$$reportNull$$$0(28);
        }
        if (expression == null) {
            PhpParametersFolder.$$$reportNull$$$0(29);
        }
        return (value = (VariableImpl)((Object)ObjectUtils.tryCast((Object)expression.getValue(), VariableImpl.class))) != null && value.getName().equals(parameter.getName());
    }

    private static boolean dependsOnLocals(@NotNull ArrayAccessExpression expression, @NotNull Collection<PhpPsiElement> inputParameters) {
        if (expression == null) {
            PhpParametersFolder.$$$reportNull$$$0(30);
        }
        if (inputParameters == null) {
            PhpParametersFolder.$$$reportNull$$$0(31);
        }
        final Set inputVariables = inputParameters.stream().map(NavigationItem::getName).collect(Collectors.toSet());
        final Ref localVarsUsed = new Ref((Object)false);
        ArrayIndex index = expression.getIndex();
        if (index == null || index.getValue() == null) {
            return false;
        }
        index.getValue().accept((PsiElementVisitor)new PhpElementVisitor(){

            public void visitPhpVariable(Variable variable) {
                if (!inputVariables.contains(variable.getName())) {
                    localVarsUsed.set((Object)true);
                    return;
                }
                super.visitPhpVariable(variable);
            }
        });
        return (Boolean)localVarsUsed.get();
    }

    private /* synthetic */ boolean lambda$isUsedInExpressionsForFolding$1(PhpExpression parameterReplacement, PsiElement element) {
        return this.isEquivalentToExpressionForFolding(element, parameterReplacement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterItems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpParametersFolder";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 14: 
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionForFolding";
                break;
            }
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputParameters";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToFind";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpParametersFolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCallArguments";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findArrayAccessUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foldParametersIfNeeded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "foldParameter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "foldParameterUsagesInBodyIfNeeded";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateCallArguments";
                break;
            }
            case 7: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isParameterSafeToDelete";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUsedInExpressionsForFolding";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestParameterName";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findCommonUsagePattern";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findArrayAccessUsages";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isAccessedForWriting";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findEquivalentAncestor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParentSkipParentheses";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isArrayAccessToParameter";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnLocals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

