/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extractMethod;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameSuggestionUtil;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodCodeFragment;
import com.jetbrains.php.refactoring.introduce.PhpIntroduceBaseHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractMethodExpressionCodeFragment
extends PhpExtractMethodCodeFragment {
    private final PhpExpression myExpression;
    private boolean myPassOutputByRefParam;
    private final TextRange myRange;

    public PhpExtractMethodExpressionCodeFragment(@NotNull PsiFile file, @NotNull PhpScopeHolder scopeHolder, @NotNull PhpExpression expression) {
        if (file == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(0);
        }
        if (scopeHolder == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(2);
        }
        super(file, scopeHolder);
        this.myExpression = expression;
        this.myRange = this.myExpression.getTextRange();
    }

    @Override
    public int getStartOffset() {
        return this.myRange.getStartOffset();
    }

    @Override
    public int getEndOffset() {
        return this.myRange.getEndOffset();
    }

    public void setPassOutputByRefParam(boolean passOutputByRefParam) {
        this.myPassOutputByRefParam = passOutputByRefParam;
    }

    @Override
    @NotNull
    public String generateCodeText() {
        if (this.myPassOutputByRefParam) {
            String string = this.extractText() + ";";
            if (string == null) {
                PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (PhpType.VOID.equals((Object)this.myExpression.getGlobalType())) {
            String string = this.extractText() + ";";
            if (string == null) {
                PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = "return " + this.extractText() + ";";
        if (string == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public PsiElement getStartStatement() {
        PhpExpression phpExpression = this.myExpression;
        if (phpExpression == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(6);
        }
        return phpExpression;
    }

    @Override
    @NotNull
    public PsiElement getEndStatement() {
        PhpExpression phpExpression = this.myExpression;
        if (phpExpression == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(7);
        }
        return phpExpression;
    }

    @Override
    @NotNull
    public Collection<String> suggestMethodNames() {
        Project project = this.myExpression.getProject();
        ArrayList<String> methodNames = new ArrayList<String>(PhpExtractMethodExpressionCodeFragment.getMethodNames(project, (PhpPsiElement)this.myExpression));
        PhpNameUtil.unique(methodNames, CollectionFactory.createCaseInsensitiveStringSet(this.getOccupiedNames()));
        ArrayList<String> arrayList = methodNames;
        if (arrayList == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    private Set<String> getOccupiedNames() {
        PhpScopeHolder parentHolder;
        PhpClass containingClass;
        PhpScopeHolder scope = this.getScopeHolder();
        if (scope instanceof Method && (containingClass = ((Method)scope).getContainingClass()) != null) {
            Set<String> set = Arrays.stream(containingClass.getOwnMethods()).map(PhpNamedElement::getName).collect(Collectors.toSet());
            if (set == null) {
                PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(9);
            }
            return set;
        }
        if (scope instanceof Function && (parentHolder = (PhpScopeHolder)PsiTreeUtil.getParentOfType((PsiElement)scope, PhpScopeHolder.class, (boolean)true, (Class[])new Class[]{PhpClass.class})) != null) {
            return PhpExtractMethodExpressionCodeFragment.getFunctionNamesInScope(parentHolder);
        }
        return PhpExtractMethodExpressionCodeFragment.getFunctionNamesInScope(scope);
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = this.myRange;
        if (textRange == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    @Nullable
    public PsiElement getPlace() {
        return null;
    }

    @NotNull
    public String render() {
        String string = PhpIntroduceBaseHandler.getTrimmedText((PsiElement)this.myExpression);
        if (string == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    private static Set<String> getFunctionNamesInScope(@Nullable PhpScopeHolder scope) {
        if (scope == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(12);
            }
            return set;
        }
        final HashSet<String> functionNames = new HashSet<String>();
        PhpControlFlowUtil.processFlow(scope.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
                functionNames.add(instruction.getFunctionDeclaration().getName());
                return true;
            }
        });
        HashSet<String> hashSet = functionNames;
        if (hashSet == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    public static List<String> getMethodNames(Project project, PhpPsiElement expression) {
        SmartList variableNames = new SmartList();
        variableNames.addAll(PhpNameSuggestionUtil.variableNameByValue((PsiElement)expression));
        if (expression instanceof PhpTypedElement) {
            variableNames.addAll(PhpNameSuggestionUtil.variableNameByType((PhpTypedElement)expression, project, true));
        }
        variableNames.addAll(PhpNameSuggestionUtil.variableNameByPlace((PsiElement)expression));
        boolean isBoolean = expression instanceof PhpTypedElement && ((PhpTypedElement)expression).getType().isBoolean();
        List<String> list = variableNames.stream().map(name -> PhpExtractMethodExpressionCodeFragment.createField(project, name)).map(field -> field.getName()).distinct().map(name -> PhpExtractMethodExpressionCodeFragment.convertFieldNameToGetterName(name, isBoolean)).collect(Collectors.toList());
        if (list == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static Field createField(Project project, String name) {
        return (Field)PhpPsiUtil.getChildByCondition((PsiElement)PhpPsiElementFactory.createClassField(project, PhpModifier.PUBLIC_FINAL_DYNAMIC, false, name, "", null), (Condition<? super PsiElement>)Field.INSTANCEOF);
    }

    @Override
    @Nullable
    public PhpExtractMethodExpressionCodeFragment restoreFragment(@NotNull PsiFile file) {
        PhpExpression expression;
        if (file == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(15);
        }
        if ((expression = (PhpExpression)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)this.getStartOffset(), (int)this.getEndOffset(), PhpExpression.class)) == null) {
            return null;
        }
        PhpScopeHolder scopeHolder = (PhpScopeHolder)PhpPsiUtil.getParentByCondition((PsiElement)expression, (Condition<? super PsiElement>)PhpScopeHolder.INSTANCE_OF);
        if (scopeHolder == null) {
            return null;
        }
        return new PhpExtractMethodExpressionCodeFragment(file, scopeHolder, expression);
    }

    @NotNull
    private static String convertFieldNameToGetterName(String name, boolean isBoolean) {
        String trimmed = StringUtil.trimStart((String)name, (String)(isBoolean ? "is" : "get"));
        String string = (isBoolean ? "is" : "get") + StringUtil.capitalize((String)trimmed);
        if (string == null) {
            PhpExtractMethodExpressionCodeFragment.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodExpressionCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/extractMethod/PhpExtractMethodExpressionCodeFragment";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateCodeText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndStatement";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestMethodNames";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOccupiedNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "render";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionNamesInScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convertFieldNameToGetterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "restoreFragment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

