/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.extract.extractInterface;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpMemberInfo;
import com.jetbrains.php.refactoring.extract.extractInterface.PhpExtractInterfaceDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExtractInterfaceHandler
implements RefactoringActionHandler {
    private static final String HELP_ID = "refactoring.extractInterface";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        int offset;
        PsiElement element;
        if (project == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(0);
        }
        if ((element = file.findElementAt(offset = editor.getCaretModel().getOffset())) != null) {
            PhpClass clazz = PhpExtractInterfaceHandler.extractClassToMove(element);
            if (clazz == null) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PhpBundle.message("refactoring.extract.interface.invalid.caret.location", new Object[0]), (String)PhpExtractInterfaceHandler.getRefactoringName(), (String)HELP_ID);
                return;
            }
            PhpExtractInterfaceHandler.handleInvoke(project, editor, clazz);
        }
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(2);
        }
        if (elements.length == 1 && elements[0] instanceof PhpClass) {
            PhpExtractInterfaceHandler.handleInvoke(project, null, (PhpClass)elements[0]);
        }
    }

    private static void handleInvoke(@NotNull Project project, @Nullable Editor editor, @NotNull PhpClass clazz) {
        if (project == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(3);
        }
        if (clazz == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(4);
        }
        if (clazz.isTrait()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PhpBundle.message("refactoring.extract.interface.invalide.extract.from.trait", new Object[0]), (String)PhpExtractInterfaceHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatusRecursively((Project)project, Collections.singletonList(clazz), (boolean)true)) {
            return;
        }
        Collection methods = clazz.getMethods();
        if (methods.isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)PhpBundle.message("refactoring.extract.interface.no.methods", new Object[0]), (String)PhpExtractInterfaceHandler.getRefactoringName(), (String)HELP_ID);
            return;
        }
        List<PhpMemberInfo> memberInfos = PhpExtractInterfaceHandler.collectMemberInfos(clazz, methods);
        PhpExtractInterfaceDialog dialog = new PhpExtractInterfaceDialog(project, clazz, memberInfos);
        dialog.show();
    }

    public static List<PhpMemberInfo> collectMemberInfos(@NotNull PhpClass clazz, @NotNull Collection<? extends Method> methods) {
        if (clazz == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(5);
        }
        if (methods == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(6);
        }
        ArrayList<PhpMemberInfo> memberInfos = new ArrayList<PhpMemberInfo>();
        ArrayList<? extends Method> list = new ArrayList<Method>(methods);
        for (int i = list.size() - 1; i >= 0; --i) {
            PhpClass containingClass;
            Method method = list.get(i);
            PhpMemberInfo info = new PhpMemberInfo((PhpClassMember)method);
            if (!PhpLangUtil.isMagicMethod(method.getNameCS()) && !method.isStatic() && method.getMethodType(false) == Method.MethodType.REGULAR_METHOD && (containingClass = method.getContainingClass()) == clazz) {
                info.setChecked(method.getAccess().isPublic());
            }
            memberInfos.add(info);
        }
        return memberInfos;
    }

    @Nullable
    private static PhpClass extractClassToMove(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PhpExtractInterfaceHandler.$$$reportNull$$$0(7);
        }
        if ((parent = element.getParent()) instanceof PhpClass) {
            PsiElement identifier = ((PhpClass)parent).getNameIdentifier();
            return identifier == element || identifier == element.getPrevSibling() || identifier == element.getNextSibling() ? (PhpClass)parent : null;
        }
        return null;
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return PhpBundle.message("refactoring.extract.interface.name", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methods";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/extract/extractInterface/PhpExtractInterfaceHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInvoke";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "collectMemberInfos";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "extractClassToMove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

