/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.codesmells;

import com.intellij.psi.PsiElement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.codesmells.DependencyMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class DistanceCalculator {
    DistanceCalculator() {
    }

    public static double similarity(@NotNull Method method, @NotNull PhpClass clazz, DependencyMap<? super PhpClassMember, PhpClassMember> dependencies) {
        if (method == null) {
            DistanceCalculator.$$$reportNull$$$0(0);
        }
        if (clazz == null) {
            DistanceCalculator.$$$reportNull$$$0(1);
        }
        Method[] clazzOwnMethods = clazz.getOwnMethods();
        double similarity = Arrays.stream(clazzOwnMethods).filter(it -> method != it).mapToDouble(it -> DistanceCalculator.getDistance(dependencies.getDependency(method).usedEntries.keySet(), dependencies.getDependency(it).usedEntries.keySet())).sum();
        if (method.getContainingClass() == clazz) {
            return similarity / (double)(clazzOwnMethods.length - 1);
        }
        return similarity / (double)clazzOwnMethods.length;
    }

    public static double getDistance(@NotNull Set<PhpClassMember> set1, @NotNull Set<PhpClassMember> set2) {
        if (set1 == null) {
            DistanceCalculator.$$$reportNull$$$0(2);
        }
        if (set2 == null) {
            DistanceCalculator.$$$reportNull$$$0(3);
        }
        if (set1.isEmpty() && set2.isEmpty()) {
            return 1.0;
        }
        return 1.0 - (double)DistanceCalculator.intersection(set1, set2).size() / (double)DistanceCalculator.union(set1, set2).size();
    }

    private static Set<PsiElement> union(Set<PhpClassMember> set1, Set<PhpClassMember> set2) {
        HashSet<PsiElement> set = new HashSet<PsiElement>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    public static Set<PsiElement> intersection(Set<PhpClassMember> set1, Set<PhpClassMember> set2) {
        HashSet<PhpClassMember> set = new HashSet<PhpClassMember>(set1);
        set.retainAll(set2);
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/refactoring/codesmells/DistanceCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "similarity";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDistance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

