/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.changeSignature;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.CommonProcessors;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.lang.PhpDocRefReferenceContributor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeInfo;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeSignatureUsageSearcher {
    private static final Condition<PsiElement> ARRAY_VALUE = element -> PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE);
    private final PhpChangeInfo myChangeInfo;

    public PhpChangeSignatureUsageSearcher(PhpChangeInfo changeInfo) {
        this.myChangeInfo = changeInfo;
    }

    public UsageInfo @NotNull [] findUsages() {
        Function method = this.myChangeInfo.getMethod();
        if (method == null) {
            if (UsageInfo.EMPTY_ARRAY == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(0);
            }
            return UsageInfo.EMPTY_ARRAY;
        }
        List<UsageInfo> result = this.findUsages(method, false);
        Set<Function> propagation = this.myChangeInfo.getFunctionsToPropagation();
        for (Function function : propagation) {
            if (!this.myChangeInfo.isConstructor() && PhpChangeSignatureUsageSearcher.isReferenceFromGoalMethod(function, method)) continue;
            result.addAll(this.findUsages(function, true));
        }
        UsageInfo[] usageInfos = result.toArray(UsageInfo.EMPTY_ARRAY);
        UsageInfo[] usageInfoArray = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos);
        if (usageInfoArray == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    @NotNull
    private List<UsageInfo> findUsages(@NotNull Function function, final boolean isPropagationUsage) {
        if (function == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(2);
        }
        final ArrayList<UsageInfo> usages = new ArrayList<UsageInfo>();
        CommonProcessors.FindProcessor<PsiReference> finder = new CommonProcessors.FindProcessor<PsiReference>(){

            protected boolean accept(PsiReference reference) {
                if (reference instanceof PhpDocRefReferenceContributor.PhpDocElementReference) {
                    usages.add(PhpChangeSignatureUsageSearcher.constructDocUsageInfo((PhpDocRefReferenceContributor.PhpDocElementReference)reference));
                }
                if (reference instanceof MethodReference && ((MethodReference)reference).getParent() instanceof PhpTraitUseRule) {
                    ReferencesSearch.search((PsiElement)((MethodReference)reference).getParent()).filtering(MethodReference.class::isInstance).asIterable().forEach(r -> usages.add(new PhpChangeSignatureUsageProcessor.PhpTraitUseRuleUsage((ParameterListOwner)((MethodReference)r), PhpChangeSignatureUsageSearcher.this.myChangeInfo)));
                }
                if (reference instanceof FunctionReference) {
                    usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)((FunctionReference)reference), PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                } else if (reference instanceof ClassReference) {
                    PsiElement parent = ((ClassReference)reference).getParent();
                    if (parent instanceof NewExpression || parent instanceof PhpAttribute) {
                        usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)parent, PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                    }
                } else if (reference instanceof Variable) {
                    PsiElement grandParent;
                    PsiElement parent = ((Variable)reference).getParent();
                    if (parent instanceof FunctionReference) {
                        usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)((FunctionReference)parent), PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                    }
                    if (parent instanceof PhpUseList && (grandParent = parent.getParent()) instanceof Function) {
                        PhpControlFlow phpControlFlow = ((Function)grandParent).getControlFlow();
                        PhpControlFlowUtil.processFlow(phpControlFlow, PhpChangeSignatureUsageSearcher.createReadAccessProcessorForClosure((Variable)reference, instruction -> {
                            PhpPsiElement anchor = instruction.getAnchor();
                            PsiElement anchorParent = anchor.getParent();
                            if (anchorParent instanceof FunctionReference) {
                                usages.add(PhpChangeSignatureUsageSearcher.constructCallUsageInfo((ParameterListOwner)((FunctionReference)anchorParent), PhpChangeSignatureUsageSearcher.this.myChangeInfo, isPropagationUsage));
                            }
                        }));
                    }
                }
                return false;
            }
        };
        Collection<Function> allFunctions = PhpChangeSignatureUsageSearcher.processAllUsages(function, this.myChangeInfo.isConstructor(), (CommonProcessors.FindProcessor<? super PsiReference>)finder);
        for (Function curFunction : allFunctions) {
            usages.add(this.constructDeclarationUsageInfo(curFunction, isPropagationUsage));
        }
        ArrayList<UsageInfo> arrayList = usages;
        if (arrayList == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    private static PhpInstructionProcessor createReadAccessProcessorForClosure(final Variable reference, final Consumer<PhpAccessVariableInstruction> readUsagesConsumer) {
        return new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(reference.getNameCS(), instruction.getVariableName())) {
                    if (instruction.getAccess().isWrite()) {
                        return false;
                    }
                    readUsagesConsumer.accept(instruction);
                }
                return true;
            }
        };
    }

    @NotNull
    private PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo constructDeclarationUsageInfo(@NotNull Function function, boolean isPropagationUsage) {
        PhpClass clazz;
        if (function == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(4);
        }
        if (isPropagationUsage) {
            return new PhpChangeSignatureUsageProcessor.FunctionPropagationDeclarationUsageInfo(function);
        }
        if (function instanceof Method && (clazz = ((Method)function).getContainingClass()) != null && clazz.isAbstract()) {
            return new PhpChangeSignatureUsageProcessor.FunctionDeclarationUsageInfo(function);
        }
        return new PhpChangeSignatureUsageProcessor.FunctionBodyUsageInfo(function, this.myChangeInfo);
    }

    @NotNull
    public static PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo constructCallUsageInfo(@NotNull ParameterListOwner parameterOwner, @NotNull PhpChangeInfo changeInfo, boolean isPropagationUsage) {
        if (parameterOwner == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(5);
        }
        if (changeInfo == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(6);
        }
        if (isPropagationUsage) {
            return new PhpChangeSignatureUsageProcessor.FunctionPropagationCallUsageInfo(parameterOwner, changeInfo);
        }
        return new PhpChangeSignatureUsageProcessor.FunctionCallUsageInfo(parameterOwner, changeInfo);
    }

    @NotNull
    public static PhpChangeSignatureUsageProcessor.PhpChangeSignatureUsageInfo constructDocUsageInfo(@NotNull PhpDocRefReferenceContributor.PhpDocElementReference seeTag) {
        if (seeTag == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(7);
        }
        return new PhpChangeSignatureUsageProcessor.PhpSeeTagInfo(seeTag);
    }

    @NotNull
    public static Collection<Function> processAllUsages(@NotNull Function rootFunction, boolean isConstructor, @NotNull CommonProcessors.FindProcessor<? super PsiReference> finder) {
        if (rootFunction == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(8);
        }
        if (finder == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)rootFunction.getName())) {
            PhpPsiElement variable = PhpChangeSignatureUsageSearcher.getVariableFromAssignment((PsiElement)rootFunction);
            if (variable instanceof Variable) {
                PhpAccessVariableInstruction assignmentInstruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
                assert (assignmentInstruction != null);
                PhpControlFlowUtil.processSuccessors((PhpInstruction)assignmentInstruction, false, PhpChangeSignatureUsageSearcher.createReadAccessProcessorForClosure((Variable)variable, instruction -> finder.process((Object)((PsiReference)instruction.getAnchor()))));
            }
            Set<Function> set = Collections.singleton(rootFunction);
            if (set == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(10);
            }
            return set;
        }
        GlobalSearchScope scope = GlobalSearchScope.projectScope((Project)rootFunction.getProject());
        Collection<Function> overridingFunctions = PhpChangeSignatureUsageSearcher.getOverridingMembers(rootFunction, isConstructor);
        for (Function function : overridingFunctions) {
            ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)function, (SearchScope)scope, false);
            ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters).forEach(finder);
        }
        Collection<Function> collection = overridingFunctions;
        if (collection == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Nullable
    public static PhpPsiElement getVariableFromAssignment(@NotNull PsiElement element) {
        List values;
        int index;
        PsiElement arrayCreation;
        Object value;
        AssignmentExpression assignment;
        if (element == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(12);
        }
        if ((assignment = PhpPsiUtil.getParentOfClass(element, true, AssignmentExpression.class)) instanceof MultiassignmentExpression && (value = PhpPsiUtil.getParentByCondition(element, ARRAY_VALUE, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null && (arrayCreation = value.getParent()) instanceof ArrayCreationExpression && (index = (values = PhpPsiUtil.getChildren(arrayCreation, ARRAY_VALUE)).indexOf(value)) != -1) {
            List variables = ((MultiassignmentExpression)assignment).getVariables();
            return variables.size() == values.size() ? (PhpPsiElement)variables.get(index) : null;
        }
        return assignment == null ? null : assignment.getVariable();
    }

    @Nullable
    public static Method findDeepestSuperMethod(@NotNull Method method, boolean isConstructor) {
        if (method == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(13);
        }
        if (isConstructor) {
            return null;
        }
        Ref refBaseClass = new Ref();
        Ref refInterface = new Ref();
        PhpClassHierarchyUtils.HierarchyMethodProcessor collect = (classMember, subClass, baseClass) -> {
            boolean isInterface = baseClass.isInterface();
            if (isInterface) {
                refInterface.set((Object)classMember);
            }
            if (!isInterface) {
                refBaseClass.set((Object)classMember);
            }
            return true;
        };
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (PhpClassHierarchyUtils.HierarchyMethodProcessor)collect);
        if (!refBaseClass.isNull()) {
            return PhpChangeSignatureUsageSearcher.getDeepestInterfaceMethod((Method)refBaseClass.get());
        }
        return (Method)refInterface.get();
    }

    @NotNull
    private static Method getDeepestInterfaceMethod(@NotNull Method baseMethod) {
        if (baseMethod == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(14);
        }
        Ref refBaseInterface = new Ref();
        PhpClassHierarchyUtils.processSuperMethods((Method)baseMethod, (classMember, subClass, baseClass) -> {
            refBaseInterface.set((Object)classMember);
            return true;
        });
        Method method = refBaseInterface.isNull() ? baseMethod : (Method)refBaseInterface.get();
        if (method == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(15);
        }
        return method;
    }

    @NotNull
    public static Collection<Function> getOverridingMembers(@Nullable Function function, boolean isConstructor) {
        if (isConstructor || !(function instanceof Method)) {
            Set<Function> set = Collections.singleton(function);
            if (set == null) {
                PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(16);
            }
            return set;
        }
        Method method = (Method)function;
        HashSet<Function> list = new HashSet<Function>();
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (classMember, subClass, baseClass) -> {
            list.add((Function)classMember);
            return true;
        });
        list.add(function);
        HashSet<Function> hashSet = list;
        if (hashSet == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    public static boolean isReferenceFromGoalMethod(@Nullable Function parent, @NotNull Function goalMethod) {
        if (goalMethod == null) {
            PhpChangeSignatureUsageSearcher.$$$reportNull$$$0(18);
        }
        if (goalMethod.equals(parent)) {
            return true;
        }
        if (!(parent instanceof Method) || !(goalMethod instanceof Method)) {
            return false;
        }
        if (((Method)goalMethod).getMethodType(false) == Method.MethodType.CONSTRUCTOR || ((Method)parent).getMethodType(false) == Method.MethodType.CONSTRUCTOR) {
            return false;
        }
        Ref isChild = new Ref((Object)false);
        PhpClassHierarchyUtils.processOverridingMethods((Method)((Method)goalMethod), (classMember, subClass, baseClass) -> {
            if (classMember.equals(parent)) {
                isChild.set((Object)true);
                return false;
            }
            return true;
        });
        return (Boolean)isChild.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 4, 5, 6, 7, 8, 9, 12, 13, 14, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageSearcher";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seeTag";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFunction";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseMethod";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goalMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/changeSignature/PhpChangeSignatureUsageSearcher";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processAllUsages";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeepestInterfaceMethod";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOverridingMembers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "constructDeclarationUsageInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructCallUsageInfo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "constructDocUsageInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processAllUsages";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getVariableFromAssignment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDeepestSuperMethod";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDeepestInterfaceMethod";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceFromGoalMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 4, 5, 6, 7, 8, 9, 12, 13, 14, 18 -> new IllegalArgumentException(string);
        };
    }
}

