/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpNameUtil {
    public static final int HIGH_PRIORITY = 1;
    public static final int MEDIUM_PRIORITY = 2;
    public static final int LOW_PRIORITY = 3;

    private PhpNameUtil() {
    }

    @NotNull
    public static List<String> filterIdentifiers(@NotNull Collection<String> names) {
        if (names == null) {
            PhpNameUtil.$$$reportNull$$$0(0);
        }
        List list = ContainerUtil.filter(names, PhpLangUtil.PHP_IDENTIFIER_CONDITION);
        if (list == null) {
            PhpNameUtil.$$$reportNull$$$0(1);
        }
        return list;
    }

    public static boolean equals(@NotNull List<String> list1, @NotNull List<String> list2, boolean ignoreCase) {
        int cur2;
        if (list1 == null) {
            PhpNameUtil.$$$reportNull$$$0(2);
        }
        if (list2 == null) {
            PhpNameUtil.$$$reportNull$$$0(3);
        }
        int cur1 = 0;
        for (cur2 = 0; cur1 < list1.size() && cur2 < list2.size(); ++cur1, ++cur2) {
            if (ignoreCase && list1.get(cur1).equalsIgnoreCase(list2.get(cur2)) || !ignoreCase && list1.get(cur1).equals(list2.get(cur2))) {
                continue;
            }
            return false;
        }
        return cur1 == list1.size() && cur2 == list2.size();
    }

    @NotNull
    public static List<String> splitName(@NotNull String name) {
        if (name == null) {
            PhpNameUtil.$$$reportNull$$$0(4);
        }
        List<String> list = Arrays.asList(NameUtil.nameToWords((String)name));
        if (list == null) {
            PhpNameUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public static String concatenateNames(@NotNull String name1, @NotNull String name2) {
        if (name1 == null) {
            PhpNameUtil.$$$reportNull$$$0(6);
        }
        if (name2 == null) {
            PhpNameUtil.$$$reportNull$$$0(7);
        }
        if (name1.isEmpty()) {
            String string = name2;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (name2.isEmpty()) {
            String string = name1;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        char lastCharInName1 = name1.charAt(name1.length() - 1);
        char firstCharInName2 = name2.charAt(0);
        if (Character.isDigit(lastCharInName1) && Character.isDigit(firstCharInName2)) {
            String string = name1 + "_" + name2;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (Character.isUpperCase(lastCharInName1) && Character.isUpperCase(firstCharInName2)) {
            if (PhpNameUtil.isUppedCased(name2)) {
                String string = name1 + "_" + name2;
                if (string == null) {
                    PhpNameUtil.$$$reportNull$$$0(11);
                }
                return string;
            }
            String string = name1 + name2;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (Character.isLowerCase(lastCharInName1) && Character.isLowerCase(firstCharInName2)) {
            String string = name1 + StringUtil.capitalize((String)name2);
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = name1 + name2;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean isUppedCased(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(15);
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isUpperCase(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void unique(List<String> names, Set<String> occupiedNames) {
        HashSet<CallSite> alreadyAddedNames = new HashSet<CallSite>();
        for (int i = 0; i < names.size(); ++i) {
            String suggestedName = names.get(i);
            if (!occupiedNames.contains(suggestedName)) continue;
            int numericSuffix = 1;
            String nameBase = suggestedName + numericSuffix;
            while (occupiedNames.contains(nameBase)) {
                nameBase = suggestedName + ++numericSuffix;
            }
            if (!alreadyAddedNames.add((CallSite)((Object)nameBase))) continue;
            names.set(i, nameBase);
        }
    }

    @NotNull
    public static String unique(@NotNull String suggestedName, @NotNull String prefix, @NotNull String suffix, Condition<? super String> isOccupied) {
        if (suggestedName == null) {
            PhpNameUtil.$$$reportNull$$$0(16);
        }
        if (prefix == null) {
            PhpNameUtil.$$$reportNull$$$0(17);
        }
        if (suffix == null) {
            PhpNameUtil.$$$reportNull$$$0(18);
        }
        if (isOccupied.value((Object)suggestedName)) {
            int numericSuffix = 1;
            String nameBase = suggestedName + prefix + numericSuffix + suffix;
            while (isOccupied.value((Object)nameBase)) {
                nameBase = suggestedName + prefix + ++numericSuffix + suffix;
            }
            String string = nameBase;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(19);
            }
            return string;
        }
        String string = suggestedName;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String getFullFileName(@NotNull String fileName, @NotNull String extension) {
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(21);
        }
        if (extension == null) {
            PhpNameUtil.$$$reportNull$$$0(22);
        }
        String string = fileName + "." + extension;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static boolean isValidNameIdentifier(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(24);
        }
        return PhpLangUtil.isPhpIdentifier(str) && !PhpLangUtil.isPhpReservedKeyword(str);
    }

    public static boolean isValidVariableName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(25);
        }
        return PhpLangUtil.isPhpIdentifier(str);
    }

    public static boolean isValidClassName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(26);
        }
        return PhpNameUtil.isValidNameIdentifier(str) && !PhpLangUtil.isPhpReservedClassName(str);
    }

    public static boolean isValidClassConstantName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(27);
        }
        return PhpLangUtil.isPhpIdentifier(str);
    }

    public static boolean isValidConstantName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(28);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    public static boolean isValidFieldName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(29);
        }
        return PhpLangUtil.isPhpIdentifier(str) && !PhpLangUtil.isPhpReservedFieldName(str);
    }

    public static boolean isValidFunctionName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(30);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    public static boolean isValidMethodName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(31);
        }
        return PhpLangUtil.isPhpIdentifier(str);
    }

    public static boolean isValidParameterName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(32);
        }
        return !PhpLangUtil.isThisReference(str) && PhpNameUtil.isValidVariableName(str);
    }

    @Deprecated
    public static boolean isValidNamespaceName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(33);
        }
        return PhpNameUtil.isValidNamespaceName(str, PhpLanguageLevel.DEFAULT);
    }

    public static boolean isValidNamespaceName(@NotNull String str, @NotNull PhpLanguageLevel languageLevel) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(34);
        }
        if (languageLevel == null) {
            PhpNameUtil.$$$reportNull$$$0(35);
        }
        return PhpLangUtil.isPhpIdentifier(str) && (languageLevel.isAtLeast(PhpLanguageLevel.PHP800) || !PhpLangUtil.isPhpReservedKeyword(str));
    }

    public static boolean isValidGotoLabelName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(36);
        }
        return PhpNameUtil.isValidNameIdentifier(str);
    }

    @Deprecated
    public static boolean isValidNamespaceFullName(@NotNull String str) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(37);
        }
        return PhpNameUtil.isValidNamespaceFullName(str, PhpLanguageLevel.DEFAULT);
    }

    public static boolean isValidNamespaceFullName(@NotNull String str, @NotNull PhpLanguageLevel languageLevel) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(38);
        }
        if (languageLevel == null) {
            PhpNameUtil.$$$reportNull$$$0(39);
        }
        return PhpNameUtil.isValidNamespaceFullName(str, false, languageLevel);
    }

    @Deprecated
    public static boolean isValidNamespaceFullName(@NotNull String str, boolean allowFullyQualified) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(40);
        }
        return PhpNameUtil.isValidNamespaceFullName(str, allowFullyQualified, PhpLanguageLevel.DEFAULT);
    }

    public static boolean isValidNamespaceFullName(@NotNull String str, boolean allowFullyQualified, @NotNull PhpLanguageLevel languageLevel) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(41);
        }
        if (languageLevel == null) {
            PhpNameUtil.$$$reportNull$$$0(42);
        }
        if (StringUtil.isEmpty((String)str)) {
            return false;
        }
        for (String s : StringUtil.split((String)str, (String)"\\", (boolean)true, (boolean)allowFullyQualified)) {
            if (PhpNameUtil.isValidNamespaceName(s, languageLevel)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFileName(@NotNull String fileName) {
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(43);
        }
        return !fileName.isEmpty() && fileName.indexOf(47) < 0 && fileName.indexOf(92) < 0;
    }

    public static boolean isPhpIdentifierInDoubleQuotes(@NotNull String identifier) {
        if (identifier == null) {
            PhpNameUtil.$$$reportNull$$$0(44);
        }
        return identifier.length() > 1 && identifier.startsWith("\"") && identifier.endsWith("\"") && PhpLangUtil.isPhpIdentifier(identifier.substring(1, identifier.length() - 1));
    }

    public static boolean isValidHeredocIdentifier(@NotNull String heredocIdentifier, boolean isHereDoc) {
        if (heredocIdentifier == null) {
            PhpNameUtil.$$$reportNull$$$0(45);
        }
        return PhpLangUtil.isPhpIdentifier(heredocIdentifier) || PhpNameUtil.isPhpIdentifierInDoubleQuotes(heredocIdentifier) && isHereDoc;
    }

    @NotNull
    public static String trimEnd(@NotNull String str, char ... chars) {
        int i;
        int length;
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(46);
        }
        if ((length = str.length()) == 0) {
            String string = str;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(47);
            }
            return string;
        }
        char[] value = str.toCharArray();
        block0: for (i = value.length - 1; i > -1; --i) {
            for (char curChar : chars) {
                if (value[i] != curChar) continue;
                continue block0;
            }
        }
        char[] newValue = Arrays.copyOf(value, i + 1);
        return new String(newValue);
    }

    @NotNull
    public static String trimStart(@NotNull String str, char ... chars) {
        int i;
        int length;
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(48);
        }
        if ((length = str.length()) == 0) {
            String string = str;
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        char[] value = str.toCharArray();
        block0: for (i = 0; i < value.length; ++i) {
            for (char curChar : chars) {
                if (value[i] != curChar) continue;
                continue block0;
            }
        }
        char[] newValue = Arrays.copyOfRange(value, i, value.length);
        return new String(newValue);
    }

    @NotNull
    @NlsSafe
    public static String trim(@NotNull @NlsSafe String str, char ... chars) {
        if (str == null) {
            PhpNameUtil.$$$reportNull$$$0(50);
        }
        return PhpNameUtil.trimStart(PhpNameUtil.trimEnd(str, chars), chars);
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int lastIndex;
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(51);
        }
        if ((lastIndex = fileName.lastIndexOf(46)) > -1) {
            String string = fileName.substring(lastIndex + 1);
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(52);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String fileName) {
        int lastIndex;
        if (fileName == null) {
            PhpNameUtil.$$$reportNull$$$0(53);
        }
        if ((lastIndex = fileName.lastIndexOf(46)) > -1) {
            String string = fileName.substring(0, lastIndex);
            if (string == null) {
                PhpNameUtil.$$$reportNull$$$0(54);
            }
            return string;
        }
        String string = fileName;
        if (string == null) {
            PhpNameUtil.$$$reportNull$$$0(55);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 8, 9, 10, 11, 12, 13, 14, 19, 20, 23, 47, 49, 52, 54, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/PhpNameUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name1";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name2";
                break;
            }
            case 15: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 46: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestedName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 21: 
            case 43: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 35: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heredocIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/PhpNameUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIdentifiers";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "splitName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "concatenateNames";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "unique";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullFileName";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtension";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameWithoutExtension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "filterIdentifiers";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 23: 
            case 47: 
            case 49: 
            case 52: 
            case 54: 
            case 55: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "splitName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "concatenateNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isUppedCased";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "unique";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFullFileName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isValidNameIdentifier";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isValidVariableName";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isValidClassConstantName";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isValidConstantName";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isValidFieldName";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isValidFunctionName";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isValidMethodName";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isValidParameterName";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isValidNamespaceName";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isValidGotoLabelName";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isValidNamespaceFullName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isValidFileName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isPhpIdentifierInDoubleQuotes";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isValidHeredocIdentifier";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getExtension";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getNameWithoutExtension";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 8, 9, 10, 11, 12, 13, 14, 19, 20, 23, 47, 49, 52, 54, 55 -> new IllegalStateException(string);
        };
    }

    public static class NameSuggestionsManager {
        private final MultiMap<Integer, String> myNamesMap = new MultiMap();
        private final Set<String> myNamesSet = new HashSet<String>();

        public void add(String name, int priority) {
            if (this.myNamesSet.add(name)) {
                this.myNamesMap.putValue((Object)priority, (Object)name);
            }
        }

        public void add(List<String> names, int priority) {
            for (String name : names) {
                this.add(name, priority);
            }
        }

        public List<String> getSuggestions() {
            Set prioritySet = this.myNamesMap.keySet();
            Object[] priorities = prioritySet.toArray(new Integer[0]);
            Arrays.sort(priorities);
            ArrayList<String> suggestedNames = new ArrayList<String>();
            Object[] objectArray = priorities;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                int priority = (Integer)objectArray[i];
                suggestedNames.addAll(this.myNamesMap.get((Object)priority));
            }
            return suggestedNames;
        }
    }
}

