/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.psalm.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import com.jetbrains.php.lang.psi.resolve.types.generics.PhpGenericTypeProvider;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmParamTypeProvider
implements PhpTypeProvider4 {
    public char getKey() {
        return '\u1892';
    }

    @Nullable
    public PhpType getType(PsiElement element) {
        ParameterImpl parameter;
        if (element instanceof PhpDocType) {
            return PsalmParamTypeProvider.parsePsalmType(element, ((PhpDocType)element).getName(), PhpDocTokenTypes.DOC_LAB, PhpDocTokenTypes.DOC_RAB, PhpDocTokenTypes.DOC_COMMA, (Function<PsiElement, PhpTypedElement>)((Function)e -> (PhpTypedElement)ObjectUtils.tryCast((Object)e, PhpDocType.class)));
        }
        if (element instanceof PhpDocMethodTag) {
            return PsalmParamTypeProvider.parseMethodType(element);
        }
        if (element instanceof ParameterImpl && (parameter = (ParameterImpl)element).isDocMethodParameter()) {
            PhpType type = PsalmParamTypeProvider.parseMethodType(element);
            return !type.isEmpty() && parameter.isVariadic() ? type.pluralise() : type;
        }
        return null;
    }

    @NotNull
    private static PhpType parseMethodType(@NotNull PsiElement element) {
        if (element == null) {
            PsalmParamTypeProvider.$$$reportNull$$$0(0);
        }
        PhpType phpType = PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, (IElementType)PhpDocElementTypes.phpDocMethodType))).stream().map(PsalmParamTypeProvider::parsePsalmTypeFromDocMethod).reduce(new PhpType(), PhpType::add);
        if (phpType == null) {
            PsalmParamTypeProvider.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static PhpType parsePsalmTypeFromDocMethod(PsiElement docMethodType) {
        PsiElement firstChild = docMethodType.getFirstChild();
        if (firstChild == null) {
            return PhpType.EMPTY;
        }
        return PsalmParamTypeProvider.parsePsalmType(docMethodType, firstChild.getText(), PhpTokenTypes.opLESS, PhpTokenTypes.opGREATER, PhpTokenTypes.opCOMMA, (Function<PsiElement, PhpTypedElement>)((Function)PhpGenericTypeProvider::getReferenceFromDocMethodType));
    }

    @Nullable
    private static PhpType parsePsalmType(@NotNull PsiElement docElement, @Nullable String name, IElementType lBrace, IElementType rBrace, IElementType comma, @NotNull Function<PsiElement, PhpTypedElement> typedElementExtractor) {
        if (docElement == null) {
            PsalmParamTypeProvider.$$$reportNull$$$0(2);
        }
        if (typedElementExtractor == null) {
            PsalmParamTypeProvider.$$$reportNull$$$0(3);
        }
        if (!PhpWorkaroundUtil.isGenericArray(docElement, name)) {
            if (PhpWorkaroundUtil.isSpecialArray(name)) {
                return PhpType.ARRAY;
            }
            return null;
        }
        return ((PhpType)PhpWorkaroundUtil.valueDocTypes(docElement, lBrace, rBrace, comma).map(typedElementExtractor).map(xva$0 -> PhpType.from((PsiElement[])new PsiElement[]{xva$0})).reduce((Object)new PhpType(), PhpType::add)).map(t -> PhpKeyTypeProvider.isArrayKeySignature((String)t) ? PsalmParamTypeProvider.signWithSameKey(t) : PhpType.pluralise((String)t, (int)1));
    }

    @NotNull
    private static String signWithSameKey(@NotNull String t) {
        if (t == null) {
            PsalmParamTypeProvider.$$$reportNull$$$0(4);
        }
        String string = t.substring(0, 2) + t;
        if (string == null) {
            PsalmParamTypeProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/psalm/types/PsalmParamTypeProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedElementExtractor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/psalm/types/PsalmParamTypeProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "parseMethodType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "signWithSameKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseMethodType";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parsePsalmType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "signWithSameKey";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

