/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.promotion;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.promotion.PhpBirthdayDiscountPersistentState;
import com.jetbrains.php.promotion.PhpBirthdayDiscountShowNotificationEventTrackerKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\n\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/php/promotion/PhpBirthdayDiscountShowNotificationEventTracker;", "Lcom/intellij/openapi/editor/event/EditorMouseListener;", "Lcom/intellij/openapi/editor/event/EditorMouseMotionListener;", "<init>", "()V", "mouseClicked", "", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "mouseMoved", "checkActivity", "project", "Lcom/intellij/openapi/project/Project;", "showPhpBirthdayDiscountNotification", "intellij.php.impl"})
public final class PhpBirthdayDiscountShowNotificationEventTracker
implements EditorMouseListener,
EditorMouseMotionListener {
    public PhpBirthdayDiscountShowNotificationEventTracker() {
        Application app = ApplicationManager.getApplication();
        if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.checkActivity(event.getEditor().getProject());
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.checkActivity(event.getEditor().getProject());
    }

    private final void checkActivity(Project project) {
        PhpBirthdayDiscountPersistentState.MyState phpBirthdayState;
        if (PhpBirthdayDiscountShowNotificationEventTrackerKt.isDiscountAvailable() && (phpBirthdayState = (PhpBirthdayDiscountPersistentState.MyState)PhpBirthdayDiscountPersistentState.Companion.getInstance().getState()).getNotificationShowedCount() < 2) {
            Instant now = Clock.System.INSTANCE.now();
            if (now.toEpochMilliseconds() >= phpBirthdayState.getNextTimeToShowNotificationEpochMillis()) {
                if (Duration.compareTo-LRDsOJo((long)now.minus-5sfh64U(PhpBirthdayDiscountShowNotificationEventTrackerKt.access$getLastActivityTime$p()), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)) >= 0) {
                    this.showPhpBirthdayDiscountNotification(project);
                    int n = phpBirthdayState.getNotificationShowedCount();
                    phpBirthdayState.setNotificationShowedCount(n + 1);
                    phpBirthdayState.setNextTimeToShowNotificationEpochMillis(now.plus-LRDsOJo(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.DAYS)).toEpochMilliseconds());
                }
            }
            PhpBirthdayDiscountShowNotificationEventTrackerKt.access$setLastActivityTime$p(Clock.System.INSTANCE.now());
        }
    }

    private final void showPhpBirthdayDiscountNotification(Project project) {
        int timesShown = ((PhpBirthdayDiscountPersistentState.MyState)PhpBirthdayDiscountPersistentState.Companion.getInstance().getState()).getNotificationShowedCount();
        Pair pair = timesShown == 0 ? TuplesKt.to((Object)new Notification("PHP Birthday Discount", PhpBundle.message("php.birthday.notification.1.title", new Object[0]), PhpBundle.message("php.birthday.notification.1.content", new Object[0]), NotificationType.INFORMATION), (Object)PhpBundle.message("php.birthday.button.buy", new Object[0])) : TuplesKt.to((Object)new Notification("PHP Birthday Discount", PhpBundle.message("php.birthday.notification.2.title", new Object[0]), PhpBundle.message("php.birthday.notification.2.content", new Object[0]), NotificationType.INFORMATION), (Object)PhpBundle.message("php.birthday.button.save", new Object[0]));
        Notification notification = (Notification)pair.component1();
        Object object = pair.component2();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"component2(...)");
        String buttonName = (String)object;
        notification.setIcon(AllIcons.Ide.Gift).setSuggestionType(true).addAction((AnAction)new DumbAwareAction(buttonName, project, notification){
            final /* synthetic */ Project $project;
            final /* synthetic */ Notification $notification;
            {
                this.$project = $project;
                this.$notification = $notification;
                super($buttonName);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.browse((String)"https://lp.jetbrains.com/php-29/", (Project)this.$project);
                ((PhpBirthdayDiscountPersistentState.MyState)PhpBirthdayDiscountPersistentState.Companion.getInstance().getState()).setNotificationShowedCount(2);
                this.$notification.expire();
            }
        }).notify(project);
    }
}

