/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.ui.xmodel.callTree;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.php.profiler.ui.xmodel.XProfilerView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeTableRowSorter
extends TableRowSorter {
    private final XProfilerView.XProfilerTreeTableView table;
    private List<? extends RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();

    public TreeTableRowSorter(XProfilerView.XProfilerTreeTableView table) {
        super(table.getModel());
        this.table = table;
    }

    @Override
    public List<? extends RowSorter.SortKey> getSortKeys() {
        return this.sortKeys;
    }

    @Override
    public void setSortKeys(List sortKeys) {
        if (sortKeys == null) {
            return;
        }
        this.sortKeys = sortKeys;
        this.sort();
    }

    @Override
    public void sort() {
        if (!this.sortKeys.isEmpty()) {
            this.sortOnKey(this.sortKeys.get(0));
        }
    }

    private void sortOnKey(RowSorter.SortKey key) {
        if (key.getSortOrder() == SortOrder.UNSORTED) {
            return;
        }
        int columnModelIndex = key.getColumn();
        TableColumnModel colModel = this.table.getColumnModel();
        int modelIndex = colModel.getColumn(columnModelIndex).getModelIndex();
        if (modelIndex < 0 || this.getComparator(modelIndex) == null) {
            return;
        }
        ComparatorWrapper<TreeNode> comparator = new ComparatorWrapper<TreeNode>(this.getComparator(modelIndex), key.getSortOrder() == SortOrder.DESCENDING);
        List paths = TreeUtil.collectExpandedPaths((JTree)this.table.getTree());
        if (TreeTableRowSorter.isSorted(paths, comparator, this.table.getTableModel())) {
            return;
        }
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (!(node instanceof DefaultMutableTreeNode)) continue;
            TreeTableRowSorter.sortChildren((DefaultMutableTreeNode)node, comparator, this.table.getTableModel().getChildCount(node));
        }
        this.table.reload();
        TreeUtil.restoreExpandedPaths((JTree)this.table.getTree(), (List)paths);
    }

    private static boolean isSorted(List<TreePath> paths, Comparator<TreeNode> comparator, TreeTableModel model) {
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (!(node instanceof DefaultMutableTreeNode) || TreeTableRowSorter.isSorted((DefaultMutableTreeNode)node, comparator, model)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSorted(DefaultMutableTreeNode node, Comparator<TreeNode> comparator, TreeTableModel model) {
        List<TreeNode> children = TreeTableRowSorter.childrenToArray(node, 0, model.getChildCount((Object)node));
        return TreeTableRowSorter.isNodesSorted(children, comparator);
    }

    private static boolean isNodesSorted(List<TreeNode> nodes, Comparator<TreeNode> comparator) {
        TreeNode prev = null;
        for (TreeNode node : nodes) {
            if (prev != null && comparator.compare(prev, node) > 0) {
                return false;
            }
            prev = node;
        }
        return true;
    }

    private static void sortChildren(DefaultMutableTreeNode node, Comparator<TreeNode> comparator, int maxIndex) {
        List<TreeNode> childrenSorted = TreeTableRowSorter.childrenToArray(node, 0, maxIndex);
        childrenSorted.sort(comparator);
        childrenSorted.addAll(TreeTableRowSorter.childrenToArray(node, maxIndex, node.getChildCount()));
        node.removeAllChildren();
        TreeUtil.addChildrenTo((MutableTreeNode)node, childrenSorted);
    }

    private static List<TreeNode> childrenToArray(DefaultMutableTreeNode node, int l, int r) {
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        while (l < r) {
            result.add(node.getChildAt(l));
            ++l;
        }
        return result;
    }

    private static class ComparatorWrapper<T>
    implements Comparator<T> {
        private final Comparator<T> comparator;
        private final boolean reverse;

        ComparatorWrapper(Comparator<T> comparator, boolean reverse) {
            this.comparator = comparator;
            this.reverse = reverse;
        }

        @Override
        public int compare(T o1, T o2) {
            return this.reverse ? -this.comparator.compare(o1, o2) : this.comparator.compare(o1, o2);
        }
    }
}

