/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.config.PhpClassWithMethodChooserForm;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitTestPatternChooserForm {
    private final PhpClassWithMethodChooserForm myForm;
    private JPanel myPanel;
    private JPanel myClassWithMethodPanel;
    private JBTextField myDataSetTextField;
    private JBLabel myDataSetLabel;

    public PhpUnitTestPatternChooserForm(Project project, Disposable disposable) {
        this.$$$setupUI$$$();
        this.myForm = new PhpClassWithMethodChooserForm(project, disposable){

            @Override
            protected boolean suggestClass(@NotNull PhpClass clazz) {
                if (clazz == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpUnitUtil.isTestClass(clazz);
            }

            @Override
            protected boolean suggestFunction(@NotNull Function function) {
                if (function == null) {
                    1.$$$reportNull$$$0(1);
                }
                return function instanceof Method && PhpUnitUtil.isTestMethod((Method)function);
            }

            @Override
            @NotNull
            protected TextFieldWithCompletion createMethodTextField(Project project, Disposable disposable) {
                final TextFieldWithCompletion field = super.createMethodTextField(project, disposable);
                field.addDocumentListener(new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        boolean methodEmpty = StringUtil.isEmptyOrSpaces((String)field.getText());
                        PhpUnitTestPatternChooserForm.this.myDataSetLabel.setVisible(!methodEmpty);
                        PhpUnitTestPatternChooserForm.this.myDataSetTextField.setVisible(!methodEmpty);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/phpunit/PhpUnitTestPatternChooserForm$1$1", "documentChanged"));
                    }
                });
                field.setPreferredSize(new Dimension(200, field.getHeight()));
                TextFieldWithCompletion textFieldWithCompletion = field;
                if (textFieldWithCompletion == null) {
                    1.$$$reportNull$$$0(2);
                }
                return textFieldWithCompletion;
            }

            @Override
            @Nullable
            public ValidationInfo validate(@NotNull PhpIndex index) {
                ValidationInfo methodTextValidation;
                ValidationInfo classTextValidation;
                if (index == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((classTextValidation = this.validateClassText(index)) != null) {
                    return classTextValidation;
                }
                if (!StringUtil.isEmptyOrSpaces((String)PhpUnitTestPatternChooserForm.this.getMethodName()) && (methodTextValidation = this.validateMethodText(index)) != null) {
                    return methodTextValidation;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "clazz";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "function";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitTestPatternChooserForm$1";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "index";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitTestPatternChooserForm$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createMethodTextField";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "suggestClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "suggestFunction";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "validate";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        };
        this.myDataSetLabel.setVisible(false);
        this.myDataSetTextField.setVisible(false);
        this.myClassWithMethodPanel.add(this.myForm.getPanel());
    }

    @Nullable
    public String getDataSet() {
        return this.myDataSetTextField.isVisible() ? this.myDataSetTextField.getText() : null;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    public ValidationInfo validate(PhpIndex index) {
        return this.myForm.validate(index);
    }

    @Nullable
    public PhpClass getSelectedClass(PhpIndex index) {
        return (PhpClass)DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> this.myForm.selectedClasses(index).findFirst().orElse(null));
    }

    public String getMethodName() {
        return this.myForm.getMethodText();
    }

    public void setClassFqn(String fqn) {
        this.myForm.setClassText(fqn);
    }

    public void setMethodName(String name) {
        this.myForm.setMethodText(name);
    }

    public void setDataSet(String dataSet) {
        this.myDataSetTextField.setText(dataSet);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBTextField jBTextField;
        JBLabel jBLabel;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myClassWithMethodPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDataSetLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitTestPatternChooserForm.class).getString("phpunit.label.data.set"));
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataSetTextField = jBTextField = new JBTextField();
        jBTextField.setText("");
        jPanel3.add((Component)jBTextField, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

