/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpunit.PhpUnitTestRunLineMarkerProvider;
import com.jetbrains.php.testFramework.PhpTestFrameworkFailedLineManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class PhpUnitFailedLineManager
extends PhpTestFrameworkFailedLineManager {
    public PhpUnitFailedLineManager(Project project) {
        super(project);
    }

    @Override
    @Nullable
    public String getTestLocationUrl(@NotNull PsiElement testElement) {
        if (testElement == null) {
            PhpUnitFailedLineManager.$$$reportNull$$$0(0);
        }
        if (testElement instanceof Method) {
            Method method = (Method)testElement;
            PhpClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return PhpUnitTestRunLineMarkerProvider.getLocationHint(containingClass, method);
        }
        return null;
    }

    @Override
    @NotNull
    public @NotNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull TestStateStorage.Record> getRecordsForTest(@NotNull PsiElement testElement) {
        if (testElement == null) {
            PhpUnitFailedLineManager.$$$reportNull$$$0(1);
        }
        Project project = testElement.getProject();
        String testLocationUrl = this.getTestLocationUrl(testElement);
        Method method = (Method)ObjectUtils.tryCast((Object)testElement, Method.class);
        if (method == null || testLocationUrl == null) {
            List<TestStateStorage.Record> list = Collections.emptyList();
            if (list == null) {
                PhpUnitFailedLineManager.$$$reportNull$$$0(2);
            }
            return list;
        }
        TestStateStorage.Record singleState = TestStateStorage.getInstance((Project)project).getState(testLocationUrl);
        if (singleState == null) {
            List<TestStateStorage.Record> list = Collections.emptyList();
            if (list == null) {
                PhpUnitFailedLineManager.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<TestStateStorage.Record> states = new ArrayList<TestStateStorage.Record>();
        states.add(singleState);
        if (singleState.failedLine == -1 && PhpUnitFailedLineManager.hasDataProviders(method)) {
            Collection allStates = TestStateStorage.getInstance((Project)project).getKeys();
            List dataSetStates = ((StreamEx)((StreamEx)((StreamEx)((StreamEx)StreamEx.of((Collection)allStates).filter(st -> st != null)).filter(st -> st.startsWith(testLocationUrl + " with data set "))).map(st -> TestStateStorage.getInstance((Project)project).getState(st)).filter(st -> st != null)).filter(st -> st.failedLine != -1)).toList();
            states.addAll(dataSetStates);
        }
        ArrayList<TestStateStorage.Record> arrayList = states;
        if (arrayList == null) {
            PhpUnitFailedLineManager.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    private static boolean hasDataProviders(@NotNull Method method) {
        if (method == null) {
            PhpUnitFailedLineManager.$$$reportNull$$$0(5);
        }
        return PhpUnitFailedLineManager.hasDataProvidersFromPHPDoc(method) || PhpUnitFailedLineManager.hasDataProvidersFromAttribute(method);
    }

    private static boolean hasDataProvidersFromPHPDoc(@NotNull Method method) {
        PhpDocComment comment;
        if (method == null) {
            PhpUnitFailedLineManager.$$$reportNull$$$0(6);
        }
        if ((comment = method.getDocComment()) == null) {
            return false;
        }
        PhpDocTag[] dataProviderTags = comment.getTagElementsByName("@dataProvider");
        return dataProviderTags.length != 0;
    }

    private static boolean hasDataProvidersFromAttribute(@NotNull Method method) {
        if (method == null) {
            PhpUnitFailedLineManager.$$$reportNull$$$0(7);
        }
        return !method.getAttributes("\\PHPUnit\\Framework\\Attributes\\DataProvider").isEmpty() || !method.getAttributes("\\PHPUnit\\Framework\\Attributes\\DataProviderExternal").isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitFailedLineManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitFailedLineManager";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordsForTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationUrl";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRecordsForTest";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasDataProviders";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasDataProvidersFromPHPDoc";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasDataProvidersFromAttribute";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

