/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.commandLine.PhpCommandLinePathProcessor;
import com.jetbrains.php.config.commandLine.PhpCommandSettings;
import com.jetbrains.php.config.commandLine.PhpCommandSettingsBuilder;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.debug.PhpDebugExtension;
import com.jetbrains.php.debug.common.PhpDebugDriver;
import com.jetbrains.php.debug.common.PhpDebugProcess;
import com.jetbrains.php.debug.common.PhpDebugProcessFactory;
import com.jetbrains.php.debug.connection.PhpDebugConnectionManager;
import com.jetbrains.php.phpunit.PhpUnitConsoleProperties;
import com.jetbrains.php.phpunit.PhpUnitExecutionUtil;
import com.jetbrains.php.phpunit.PhpUnitLocalRunConfiguration;
import com.jetbrains.php.phpunit.PhpUnitRunConfigurationSettings;
import com.jetbrains.php.phpunit.PhpUnitTestRunnerSettings;
import com.jetbrains.php.phpunit.actions.PhpUnitRerunFailedTestsAction;
import com.jetbrains.php.run.PhpDebugRunner;
import com.jetbrains.php.run.PhpRunConfiguration;
import com.jetbrains.php.util.connection.PhpIncomingDebugConnectionServer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PhpUnitDebugRunner
extends PhpDebugRunner<PhpUnitLocalRunConfiguration> {
    public PhpUnitDebugRunner() {
        super(PhpUnitLocalRunConfiguration.class);
    }

    @NotNull
    public String getRunnerId() {
        return "PhpUnitDebugRunner";
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (state == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile runProfile = environment.getRunProfile();
        if (runProfile instanceof PhpUnitRerunFailedTestsAction.PhpUnitRerunProfile) {
            PhpUnitRerunFailedTestsAction.PhpUnitRerunProfile profile = (PhpUnitRerunFailedTestsAction.PhpUnitRerunProfile)runProfile;
            PhpRunConfiguration<PhpUnitRunConfigurationSettings> configuration = profile.getRunConfiguration();
            PhpUnitTestRunnerSettings settings = configuration.getSettings().getTestRunnerSettings();
            settings.setTestPatterns(profile.getFailedTests());
            settings.setScope(PhpUnitTestRunnerSettings.Scope.Pattern);
            return this.doExecute((PhpUnitLocalRunConfiguration)configuration, state, environment);
        }
        return this.doExecute((PhpUnitLocalRunConfiguration)environment.getRunProfile(), state, environment);
    }

    @Override
    protected RunContentDescriptor doExecute(@NotNull PhpUnitLocalRunConfiguration runConfiguration, @NotNull RunProfileState state, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (runConfiguration == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(2);
        }
        if (state == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(3);
        }
        if (env == null) {
            PhpUnitDebugRunner.$$$reportNull$$$0(4);
        }
        final Project project = runConfiguration.getProject();
        final PhpInterpreter interpreter = runConfiguration.getInterpreter();
        if (interpreter == null) {
            throw new ExecutionException(PhpCommandSettingsBuilder.getInterpreterNotFoundError());
        }
        final PhpDebugExtension debugExtension = PhpProjectConfigurationFacade.getInstance(runConfiguration.getProject()).getInterpreterDebugExtension(interpreter);
        if (debugExtension == null) {
            throw new ExecutionException(PhpBundle.message("debug.error.unknown.debugger.id", new Object[0]));
        }
        final PhpIncomingDebugConnectionServer debugServer = debugExtension.startLocalDebugServer(project, interpreter);
        if (debugServer == null) {
            return null;
        }
        final PhpDebugConnectionManager connectionsManager = debugExtension.createDebugConnectionManager();
        final String sessionId = debugServer.registerSessionHandler(false, connectionsManager).getSessionId();
        try {
            Map<String, String> commandLineEnv = debugExtension.getDebugEnv(project, false, sessionId);
            PhpCommandSettings command = runConfiguration.createCommand(interpreter, commandLineEnv, true);
            final ProcessHandler processHandler = runConfiguration.createProcessHandler(project, command, PtyCommandLine.isEnabled());
            ProcessTerminatedListener.attach((ProcessHandler)processHandler, (Project)project);
            final PhpCommandLinePathProcessor pathProcessor = command.getPathProcessor();
            final PhpUnitConsoleProperties properties = runConfiguration.createTestConsoleProperties(env.getExecutor(), pathProcessor);
            final ConsoleView console = PhpUnitExecutionUtil.createConsole(project, processHandler, properties);
            runConfiguration.notifyIfTestSuitIsEmpty(project, console, processHandler);
            XDebugSession debugSession = XDebuggerManager.getInstance((Project)project).startSession(env, new XDebugProcessStarter(){

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PhpUnitDebugRunner.onSessionStart(session, debugServer, sessionId, connectionsManager, project, interpreter, processHandler);
                    PhpDebugDriver driver = debugExtension.getDebugDriver();
                    PhpUnitRerunFailedTestsAction rerunFailedTestsAction = new PhpUnitRerunFailedTestsAction((ComponentContainer)console, properties);
                    rerunFailedTestsAction.setModelProvider(() -> {
                        if (console instanceof SMTRunnerConsoleView) {
                            return ((SMTRunnerConsoleView)console).getResultsViewer();
                        }
                        return null;
                    });
                    XDebugSessionImpl sessionImpl = (XDebugSessionImpl)session;
                    sessionImpl.addRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction()});
                    PhpDebugProcess phpDebugProcess = PhpDebugProcessFactory.forPhpTests(session, sessionId, connectionsManager, driver, console, pathProcessor);
                    if (phpDebugProcess == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return phpDebugProcess;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitDebugRunner$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitDebugRunner$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1 -> new IllegalStateException(string);
                    };
                }
            });
            processHandler.startNotify();
            return debugSession.getRunContentDescriptor();
        }
        catch (ExecutionException e) {
            debugServer.unregisterSessionHandler(sessionId);
            throw e;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "state";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "environment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "runConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "env";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phpunit/PhpUnitDebugRunner";
        objectArray[2] = "doExecute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

