/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpunit;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.statistics.ComposerPackageVersion;
import com.jetbrains.php.composer.statistics.ComposerPackageVersionParser;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.config.interpreters.PhpSdkDependentConfiguration;
import com.jetbrains.php.phpunit.PhpParaTestFileChooserDescriptor;
import com.jetbrains.php.phpunit.PhpParaTestValidationLabel;
import com.jetbrains.php.phpunit.PhpUnitFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitInfoComponent;
import com.jetbrains.php.phpunit.PhpUnitRuntimeConfigurationProducer;
import com.jetbrains.php.phpunit.PhpUnitSettings;
import com.jetbrains.php.phpunit.PhpUnitVersion;
import com.jetbrains.php.phpunit.PhpUnitVersionDetector;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkVersionCache;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkBaseConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurableForm;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkConfigurationInfoComponent;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkVersionComponent;
import com.jetbrains.php.testFramework.ui.PhpTestFrameworkVersionLabel;
import com.jetbrains.php.ui.PhpUiUtil;
import com.jetbrains.php.ui.ResultMessage;
import com.jetbrains.php.util.PhpConfigurationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpUnitConfigurableForm<S extends PhpUnitSettings>
implements PhpTestFrameworkConfigurableForm<S>,
Iconable {
    private static final Logger LOG = Logger.getInstance(PhpTestFrameworkVersionComponent.class);
    @NotNull
    public static final ComposerPackageVersion PARATEST_SUPPORTED_VERSION = Objects.requireNonNull(ComposerPackageVersionParser.parseVersion(">=6.5.0"));
    private JPanel myMainPanel;
    private JBCheckBox myUseConfigurationFileJBCheckBox;
    private JBCheckBox myUseBootstrapFileJBCheckBox;
    private TextFieldWithBrowseButton myConfigurationFileTextField;
    private TextFieldWithBrowseButton myBootstrapFileTextField;
    private JBRadioButton myCustomLoaderRadioButton;
    private TextFieldWithBrowseButton myCustomLoaderPathTextField;
    private JPanel myCustomLoaderPanel;
    private JPanel myPhpUnitPharPanel;
    private JPanel myPhpUnitPharPathPanel;
    private TextFieldWithBrowseButton myPhpUnitPharPathTextField;
    private JBRadioButton myPhpUnitPharRadioButton;
    protected HyperlinkLabel myDownloadPharHyperlinkLabel;
    protected HyperlinkLabel myWarningLabel;
    private JPanel myVersionPanel;
    private JPanel myInfoPanel;
    private TextFieldWithBrowseButton myParaTestPathTextField;
    private final PhpParaTestValidationLabel myPhpParaTestValidationLabel;
    private JPanel myParaTestValidationPanel;
    @Nullable
    private PhpTestFrameworkConfigurationInfoComponent<?> myInfoComponent;
    @Nullable
    protected PhpUnitVersionLabel myVersionLabel;
    private final List<PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener> myExecutionPathChangeListeners;
    @NotNull
    protected final Project myProject;
    protected S mySettings;
    private final DocumentAdapter myConfigurationChangeListener;

    public PhpUnitConfigurableForm(@NotNull Project project, @NotNull S settings) {
        if (project == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(1);
        }
        this.myVersionLabel = null;
        this.$$$setupUI$$$();
        this.myExecutionPathChangeListeners = new SmartList();
        this.myProject = project;
        this.mySettings = settings;
        JBRadioButton loadMethodButton = switch (((PhpUnitSettings)settings).getLoadMethod()) {
            default -> throw new IncompatibleClassChangeError();
            case PhpUnitSettings.LoadMethod.CUSTOM_LOADER -> this.myCustomLoaderRadioButton;
            case PhpUnitSettings.LoadMethod.PHPUNIT_PHAR -> this.myPhpUnitPharRadioButton;
        };
        loadMethodButton.setSelected(true);
        this.myCustomLoaderPathTextField.setText(((PhpUnitSettings)settings).getCustomLoaderPath());
        this.myPhpUnitPharPathTextField.setText(((PhpUnitSettings)settings).getPhpUnitPharPath());
        ActionListener updateStateActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhpUnitConfigurableForm.this.updateState();
                PhpUnitConfigurableForm.this.validateConfiguration();
                if (PhpUnitConfigurableForm.this.myVersionLabel != null) {
                    PhpUnitConfigurableForm.this.myVersionLabel.scheduleInfoComputation();
                }
            }
        };
        this.myCustomLoaderRadioButton.addActionListener(updateStateActionListener);
        this.myPhpUnitPharRadioButton.addActionListener(updateStateActionListener);
        this.myUseConfigurationFileJBCheckBox.addActionListener(updateStateActionListener);
        this.myUseBootstrapFileJBCheckBox.addActionListener(updateStateActionListener);
        this.myDownloadPharHyperlinkLabel.setHyperlinkText(PhpBundle.message("PhpUnitConfigurableForm.download.phpunit.phar.link.text", "https://phar.phpunit.de/phpunit.phar"));
        this.setUpDownloadLink(project, "https://phar.phpunit.de/phpunit.phar", "phpunit.phar");
        this.myConfigurationChangeListener = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpUnitConfigurableForm.this.validateConfiguration();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phpunit/PhpUnitConfigurableForm$2", "textChanged"));
            }
        };
        this.myCustomLoaderPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myConfigurationChangeListener);
        this.myPhpUnitPharPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myConfigurationChangeListener);
        this.myParaTestPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)this.myConfigurationChangeListener);
        this.myConfigurationFileTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (PhpUnitConfigurableForm.this.myInfoComponent != null) {
                    PhpUnitConfigurableForm.this.myInfoComponent.updateConfigurations(PhpUnitConfigurableForm.this.myConfigurationFileTextField.getText());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/phpunit/PhpUnitConfigurableForm$3", "textChanged"));
            }
        });
        if (this.isVersionDetectSupported()) {
            this.myVersionLabel = new PhpUnitVersionLabel();
            this.myVersionPanel.add(this.myVersionLabel);
            this.myVersionLabel.reset((PhpUnitSettings)settings, false);
        }
        this.myPhpParaTestValidationLabel = new PhpParaTestValidationLabel(this.myProject, this.myParaTestPathTextField.getText());
        this.myParaTestValidationPanel.add(this.myPhpParaTestValidationLabel);
        this.setAdditionalInfoComponent(new PhpUnitInfoComponent(project, null));
    }

    public void setUpDownloadLink(final @Nullable Project project, final @NotNull String downloadUrl, final @NotNull String fileName) {
        if (downloadUrl == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(2);
        }
        if (fileName == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(3);
        }
        this.myDownloadPharHyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                VirtualFile file = PhpConfigurationUtil.downloadFile(project, PhpUnitConfigurableForm.this.myMainPanel, null, downloadUrl, fileName);
                if (file == null) {
                    return;
                }
                PhpUnitConfigurableForm.this.myPhpUnitPharPathTextField.setText(file.getPresentableUrl());
                if (PhpUnitConfigurableForm.this.myVersionLabel != null) {
                    PhpUnitConfigurableForm.this.myVersionLabel.scheduleInfoComputation();
                }
            }
        });
    }

    protected boolean isVersionDetectSupported() {
        return true;
    }

    protected void setAdditionalInfoComponent(@NotNull PhpTestFrameworkConfigurationInfoComponent<?> infoComponent) {
        if (infoComponent == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(4);
        }
        if (((PhpUnitSettings)this.mySettings).isLocal()) {
            this.myInfoComponent = infoComponent;
            this.myInfoPanel.add((Component)this.myInfoComponent.getComponent(), "Center");
        } else {
            this.myInfoPanel.setVisible(false);
        }
    }

    protected void validateConfiguration() {
        if (this.myCustomLoaderRadioButton.isSelected()) {
            String path = this.myCustomLoaderPathTextField.getText();
            ((PhpUnitSettings)this.mySettings).setImmediateExecutablePath(path);
            if (StringUtil.isNotEmpty((String)path)) {
                this.setPhpUnitWarning(this.validateAutoloader(path));
            } else {
                this.setPhpUnitWarning(PhpBundle.message("PhpUnitConfigurableForm.custom.loader.is.empty", new Object[0]));
            }
        } else if (this.myPhpUnitPharRadioButton.isSelected()) {
            String path = this.myPhpUnitPharPathTextField.getText();
            ((PhpUnitSettings)this.mySettings).setImmediateExecutablePath(path);
            this.setPhpUnitWarning(StringUtil.isEmpty((String)path) ? PhpBundle.message("PhpUnitConfigurableForm.phpunit.phar.is.empty", new Object[0]) : this.validatePhpUnitPhar(path));
        } else {
            this.setPhpUnitWarning(null);
        }
        this.myParaTestValidationPanel.setVisible(!this.myPhpParaTestValidationLabel.validatePath(this.myParaTestPathTextField.getText()));
    }

    @Override
    @Nullable
    public String getExecutablePath() {
        if (this.myCustomLoaderRadioButton.isSelected()) {
            return this.myCustomLoaderPathTextField.getText();
        }
        if (this.myPhpUnitPharRadioButton.isSelected()) {
            return this.myPhpUnitPharPathTextField.getText();
        }
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(5);
        }
        return project;
    }

    @Override
    @Nullable
    public String getLastDetectedVersion() {
        if (this.myVersionLabel != null) {
            return this.myVersionLabel.getVersion();
        }
        return null;
    }

    @NlsContexts.LinkLabel
    protected String validateAutoloader(@NotNull String path) {
        VirtualFile dir;
        if (path == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(6);
        }
        if ((dir = LocalFileSystem.getInstance().findFileByPath(path)) == null) {
            return PhpBundle.message("PhpUnitConfigurableForm.can.not.find.custom.loader", path);
        }
        if (dir.isDirectory()) {
            return PhpBundle.message("PhpUnitConfigurableForm.custom.loader.is.directory", new Object[0]);
        }
        return null;
    }

    @NlsContexts.LinkLabel
    @Nullable
    protected String validatePhpUnitPhar(@NotNull String path) {
        VirtualFile dir;
        if (path == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(7);
        }
        return (dir = LocalFileSystem.getInstance().findFileByPath(path)) == null ? PhpBundle.message("PhpUnitConfigurableForm.can.not.find.phpunit.phar", path) : null;
    }

    protected void setPhpUnitWarning(@NlsContexts.LinkLabel @Nullable String warning) {
        if (StringUtil.isNotEmpty((String)warning)) {
            this.myWarningLabel.setVisible(true);
            this.myWarningLabel.setHtmlText(warning);
            this.myWarningLabel.setIcon(UIUtil.getBalloonErrorIcon());
            this.myWarningLabel.setHyperlinkTarget(null);
        } else {
            this.myWarningLabel.setVisible(false);
        }
    }

    @Override
    @NotNull
    public S getConfiguration() {
        S s = this.mySettings;
        if (s == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(8);
        }
        return s;
    }

    protected void addBrowseFolderListener(@NotNull Project project, @NotNull TextFieldWithBrowseButton textField, final @NotNull List<PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener> listeners) {
        if (project == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(9);
        }
        if (textField == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(10);
        }
        if (listeners == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(11);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        TextBrowseFolderListener listener = new TextBrowseFolderListener(descriptor, project){

            protected void onFileChosen(@NotNull VirtualFile chosenFile) {
                if (chosenFile == null) {
                    5.$$$reportNull$$$0(0);
                }
                super.onFileChosen(chosenFile);
                for (PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener listener : listeners) {
                    listener.onFileChosen(chosenFile.getPath());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/jetbrains/php/phpunit/PhpUnitConfigurableForm$5", "onFileChosen"));
            }
        };
        textField.addBrowseFolderListener(listener);
    }

    @Nullable
    public JComponent createComponent() {
        this.addBrowseFolderListener(this.myProject, this.myCustomLoaderPathTextField, this.myExecutionPathChangeListeners);
        this.addBrowseFolderListener(this.myProject, this.myPhpUnitPharPathTextField, this.myExecutionPathChangeListeners);
        this.addBrowseFolderListener(this.myProject, this.myConfigurationFileTextField, Collections.emptyList());
        this.addBrowseFolderListener(this.myProject, this.myBootstrapFileTextField, Collections.emptyList());
        this.myParaTestPathTextField.addBrowseFolderListener(this.myProject, (FileChooserDescriptor)new PhpParaTestFileChooserDescriptor());
        return this.myMainPanel;
    }

    public boolean isModified() {
        return this.isModified((PhpUnitSettings)this.getConfiguration());
    }

    protected boolean isModified(@NotNull PhpUnitSettings state) {
        if (state == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(12);
        }
        PhpUnitSettings.LoadMethod loadMethod = state.getLoadMethod();
        return this.myCustomLoaderRadioButton.isSelected() && loadMethod != PhpUnitSettings.LoadMethod.CUSTOM_LOADER || this.myPhpUnitPharRadioButton.isSelected() && loadMethod != PhpUnitSettings.LoadMethod.PHPUNIT_PHAR || PhpConfigurationUtil.isModified(this.myCustomLoaderPathTextField, state.getCustomLoaderPath()) || PhpConfigurationUtil.isModified(this.myPhpUnitPharPathTextField, state.getPhpUnitPharPath()) || this.myUseConfigurationFileJBCheckBox.isSelected() != state.isUseConfigurationFile() || PhpConfigurationUtil.isModified(this.myConfigurationFileTextField, state.getConfigurationFilePath()) || this.myUseBootstrapFileJBCheckBox.isSelected() != state.isUseBootstrapFile() || PhpConfigurationUtil.isModified(this.myBootstrapFileTextField, state.getBootstrapFilePath()) || PhpConfigurationUtil.isModified(this.myParaTestPathTextField, state.getParaTestPath()) || this.myVersionLabel != null && this.myVersionLabel.isModified(state) || this.myInfoComponent != null && this.myInfoComponent.isModified(state);
    }

    public void apply() throws ConfigurationException {
        if (this.myUseConfigurationFileJBCheckBox.isSelected() && StringUtil.isEmpty((String)this.myConfigurationFileTextField.getText())) {
            String name = ((PhpUnitSettings)this.getConfiguration()).getPresentableName(this.myProject);
            throw new ConfigurationException(PhpBundle.message("PhpUnitConfigurableForm.use.configuration.file.validation.warning", name));
        }
        if (this.myUseBootstrapFileJBCheckBox.isSelected() && StringUtil.isEmpty((String)this.myBootstrapFileTextField.getText())) {
            String name = ((PhpUnitSettings)this.getConfiguration()).getPresentableName(this.myProject);
            throw new ConfigurationException(PhpBundle.message("PhpUnitConfigurableForm.use.bootstrap.file.validation.warning", name));
        }
        this.apply((PhpUnitSettings)this.getConfiguration());
    }

    protected void apply(@NotNull PhpUnitSettings state) {
        if (state == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(13);
        }
        if (this.myCustomLoaderRadioButton.isSelected()) {
            state.setLoadMethod(PhpUnitSettings.LoadMethod.CUSTOM_LOADER);
        } else if (this.myPhpUnitPharRadioButton.isSelected()) {
            state.setLoadMethod(PhpUnitSettings.LoadMethod.PHPUNIT_PHAR);
        }
        state.setCustomLoaderPath(this.myCustomLoaderPathTextField.getText());
        state.setPhpUnitPharPath(this.myPhpUnitPharPathTextField.getText());
        state.setUseConfigurationFile(this.myUseConfigurationFileJBCheckBox.isSelected());
        state.setConfigurationFilePath(StringUtil.nullize((String)this.myConfigurationFileTextField.getText()));
        state.setUseBootstrapFile(this.myUseBootstrapFileJBCheckBox.isSelected());
        state.setBootstrapFilePath(StringUtil.nullize((String)this.myBootstrapFileTextField.getText()));
        state.setParaTestPath(StringUtil.nullize((String)this.myParaTestPathTextField.getText()));
        if (this.myVersionLabel != null) {
            this.myVersionLabel.apply(state);
        }
        if (this.myInfoComponent != null) {
            this.myInfoComponent.apply(state);
        }
    }

    public void reset() {
        this.reset((PhpUnitSettings)this.getConfiguration());
    }

    public void disposeUIResources() {
        this.myCustomLoaderPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myConfigurationChangeListener);
        this.myPhpUnitPharPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myConfigurationChangeListener);
        this.myParaTestPathTextField.getTextField().getDocument().removeDocumentListener((DocumentListener)this.myConfigurationChangeListener);
        if (this.myVersionLabel != null) {
            Disposer.dispose((Disposable)this.myVersionLabel);
        }
        if (this.myInfoComponent != null) {
            this.myInfoComponent.disposeUIResources();
        }
    }

    protected void reset(@NotNull PhpUnitSettings state) {
        if (state == null) {
            PhpUnitConfigurableForm.$$$reportNull$$$0(14);
        }
        PhpUnitSettings.LoadMethod loadMethod = state.getLoadMethod();
        JBRadioButton loadMethodButton = switch (loadMethod) {
            default -> throw new IncompatibleClassChangeError();
            case PhpUnitSettings.LoadMethod.CUSTOM_LOADER -> this.myCustomLoaderRadioButton;
            case PhpUnitSettings.LoadMethod.PHPUNIT_PHAR -> this.myPhpUnitPharRadioButton;
        };
        loadMethodButton.setSelected(true);
        this.myCustomLoaderPathTextField.setText(state.getCustomLoaderPath());
        this.myPhpUnitPharPathTextField.setText(state.getPhpUnitPharPath());
        this.myUseConfigurationFileJBCheckBox.setSelected(state.isUseConfigurationFile());
        this.myConfigurationFileTextField.setText(state.getConfigurationFilePath());
        this.myUseBootstrapFileJBCheckBox.setSelected(state.isUseBootstrapFile());
        this.myBootstrapFileTextField.setText(state.getBootstrapFilePath());
        if (state.getParaTestPath() == null) {
            this.myParaTestPathTextField.setText(PhpUnitRuntimeConfigurationProducer.findParaTestExePath(this.myProject, null));
        } else {
            this.myParaTestPathTextField.setText(state.getParaTestPath());
        }
        if (this.myVersionLabel != null) {
            this.myVersionLabel.reset(state, true);
        }
        if (this.myInfoComponent != null) {
            this.myInfoComponent.reset(state);
        }
        this.updateState();
        this.validateConfiguration();
    }

    private void updateState() {
        this.myCustomLoaderPanel.setVisible(this.myCustomLoaderRadioButton.isSelected());
        this.myPhpUnitPharPanel.setVisible(this.myPhpUnitPharRadioButton.isSelected());
        this.myConfigurationFileTextField.setEnabled(this.myUseConfigurationFileJBCheckBox.isSelected());
        this.myBootstrapFileTextField.setEnabled(this.myUseBootstrapFileJBCheckBox.isSelected());
        if (this.myVersionLabel != null) {
            this.myVersionLabel.setVisible(true);
        }
        if (this.myInfoComponent != null) {
            String configurationPath = this.myUseConfigurationFileJBCheckBox.isSelected() ? this.myConfigurationFileTextField.getText() : "";
            this.myInfoComponent.updateConfigurations(configurationPath);
        }
    }

    public Icon getIcon(int flags) {
        return ((PhpUnitSettings)this.getConfiguration()).getFrameworkType().getIcon();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        HyperlinkLabel hyperlinkLabel;
        JPanel jPanel;
        HyperlinkLabel hyperlinkLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        JPanel jPanel3;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel4;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JPanel jPanel5;
        TextFieldWithBrowseButton textFieldWithBrowseButton3;
        JPanel jPanel6;
        JBCheckBox jBCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton4;
        JBCheckBox jBCheckBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton5;
        JPanel jPanel7;
        this.myMainPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 5, 5, 5), -1, -1, false, false));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel8, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel8.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.test.runner"), (int)0, (int)0, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myConfigurationFileTextField = textFieldWithBrowseButton5 = new TextFieldWithBrowseButton();
        jPanel9.add((Component)textFieldWithBrowseButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUseConfigurationFileJBCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.use.configuration.file"));
        jPanel9.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel10, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myBootstrapFileTextField = textFieldWithBrowseButton4 = new TextFieldWithBrowseButton();
        jPanel10.add((Component)textFieldWithBrowseButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myUseBootstrapFileJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.use.bootstrap.file"));
        jPanel10.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myInfoPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel8.add((Component)jPanel6, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel11, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myParaTestPathTextField = textFieldWithBrowseButton3 = new TextFieldWithBrowseButton();
        jPanel11.add((Component)textFieldWithBrowseButton3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myParaTestValidationPanel = jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel11.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, "Center");
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.default.paratest.binary"));
        jPanel11.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel7.add((Component)jPanel12, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel12.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.phpunit.library"), (int)0, (int)0, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel13.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCustomLoaderRadioButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.use.custom.loader"));
        jPanel13.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPhpUnitPharRadioButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.path.to.phpunit.phar"));
        jPanel13.add((Component)jBRadioButton, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        this.myCustomLoaderPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel12.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel14, "Center");
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.path.to.script"));
        jPanel14.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myCustomLoaderPathTextField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel14.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myPhpUnitPharPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPhpUnitPharPathPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel15, "Center");
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/PhpBundle", PhpUnitConfigurableForm.class).getString("PhpUnitConfigurableForm.path.to.phpunit.phar"));
        jPanel15.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myPhpUnitPharPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel15.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel16, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDownloadPharHyperlinkLabel = hyperlinkLabel2 = new HyperlinkLabel();
        jPanel16.add((Component)hyperlinkLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        this.myVersionPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel12.add((Component)jPanel, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel.add((Component)spacer4, "Center");
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel12.add((Component)jPanel17, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myWarningLabel = hyperlinkLabel = new HyperlinkLabel();
        jPanel17.add((Component)hyperlinkLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel17.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)jBRadioButton2);
        buttonGroup.add((AbstractButton)jBRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoComponent";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitConfigurableForm";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitConfigurableForm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUpDownloadLink";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setAdditionalInfoComponent";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validateAutoloader";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validatePhpUnitPhar";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 8 -> new IllegalStateException(string);
        };
    }

    public class PhpUnitVersionLabel
    extends JPanel
    implements Disposable {
        private final PhpTestFrameworkVersionLabel myVersionLabel;
        @NotNull
        private final Alarm myReloadAlarm;
        private boolean myDisposed = false;

        public PhpUnitVersionLabel() {
            this.setLayout(new BorderLayout());
            this.myVersionLabel = new PhpTestFrameworkVersionLabel("PHPUnit");
            this.add((Component)((Object)this.myVersionLabel));
            this.myReloadAlarm = new Alarm();
            AnAction reloadAction = PhpUiUtil.createReloadAction((Computable<ResultMessage>)((Computable)() -> this.reloadVersion()), () -> this.myReloadAlarm.isEmpty());
            PhpUnitConfigurableForm.this.myCustomLoaderPanel.add((Component)PhpUiUtil.createHorizontalActionsToolbar("PhpUnitToolbar", reloadAction), "East");
            PhpUnitConfigurableForm.this.myPhpUnitPharPathPanel.add((Component)PhpUiUtil.createHorizontalActionsToolbar("PhpUnitToolbar", reloadAction), "East");
            PhpUnitConfigurableForm.this.myExecutionPathChangeListeners.add(new PhpTestFrameworkBaseConfigurableForm.PhpFilePathUpdateListener(){

                @Override
                public void onFileChosen(@NotNull String path) {
                    if (path == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    PhpUnitVersionLabel.this.scheduleInfoComputation();
                }

                @Override
                public void onFileUpdated(@NotNull String path) {
                    if (path == null) {
                        1.$$$reportNull$$$0(1);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "path";
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitConfigurableForm$PhpUnitVersionLabel$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFileChosen";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onFileUpdated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Nullable
        public String getVersion() {
            return this.myVersionLabel.getVersion();
        }

        public void setVersion(@Nullable String version) {
            this.myVersionLabel.setVersion(version);
        }

        public void scheduleInfoComputation() {
            if (this.myDisposed) {
                return;
            }
            this.myReloadAlarm.cancelAllRequests();
            this.myReloadAlarm.addRequest(() -> this.reloadVersion(), 200);
        }

        @NotNull
        private ResultMessage reloadVersion() {
            ResultMessage result;
            PhpInterpreter interpreter;
            if (!TrustedProjects.isProjectTrusted((Project)PhpUnitConfigurableForm.this.myProject)) {
                return new ResultMessage(PhpBundle.message("php.test.framework.untrusted.reload", "PHPUnit"), MessageType.WARNING);
            }
            PhpTestFrameworkConfiguration settings = PhpUnitConfigurableForm.this.getConfiguration();
            boolean tryAnotherLocal = false;
            if (settings instanceof PhpSdkDependentConfiguration) {
                String id = ((PhpSdkDependentConfiguration)((Object)settings)).getInterpreterId();
                interpreter = PhpInterpretersManagerImpl.getInstance(PhpUnitConfigurableForm.this.myProject).findInterpreterById(id);
            } else {
                interpreter = PhpProjectConfigurationFacade.getInstance(PhpUnitConfigurableForm.this.myProject).getInterpreter();
                if (interpreter == null || interpreter.isRemote()) {
                    interpreter = (PhpInterpreter)ContainerUtil.find(PhpInterpretersManagerImpl.getInstance(PhpUnitConfigurableForm.this.myProject).getInterpreters(), i -> !i.isRemote());
                    tryAnotherLocal = true;
                }
            }
            if (interpreter == null) {
                return new ResultMessage(PhpBundle.message("php.test.framework.configuration.ui.select.interpreter", "PHPUnit"), MessageType.ERROR);
            }
            String version = null;
            String toolName = PhpUnitFrameworkType.getInstance().getDisplayName();
            try {
                String executable = this.getExecutable();
                assert (interpreter != null);
                version = ((PhpUnitVersion)PhpUnitVersionDetector.getInstance().getVersion(PhpUnitConfigurableForm.this.myProject, interpreter, executable)).getVersion();
                String message = PhpBundle.message("php.test.framework.configuration.updated.version", toolName);
                result = new ResultMessage(message, MessageType.INFO);
            }
            catch (ExecutionException e) {
                String message = StringUtil.notNullize((String)e.getMessage(), (String)PhpBundle.message("php.test.framework.configuration.can.not.update", toolName));
                result = new ResultMessage(message, MessageType.ERROR);
                LOG.warn((Throwable)e);
            }
            if (version == null && tryAnotherLocal) {
                version = PhpBundle.message("php.test.framework.default.interpreter.is.not.local", toolName);
            }
            this.resetVersion(version);
            ResultMessage resultMessage = result;
            if (resultMessage == null) {
                PhpUnitVersionLabel.$$$reportNull$$$0(0);
            }
            return resultMessage;
        }

        private void resetVersion(@Nullable String version) {
            UIUtil.invokeAndWaitIfNeeded(() -> this.myVersionLabel.setVersion(version));
        }

        @NotNull
        private String getExecutable() {
            if (PhpUnitConfigurableForm.this.myPhpUnitPharRadioButton.isSelected()) {
                String string = PhpUnitConfigurableForm.this.myPhpUnitPharPathTextField.getText();
                if (string == null) {
                    PhpUnitVersionLabel.$$$reportNull$$$0(1);
                }
                return string;
            }
            String autoloader = PhpUnitConfigurableForm.this.myCustomLoaderPathTextField.getText();
            if (StringUtil.isEmpty((String)autoloader)) {
                String string = autoloader;
                if (string == null) {
                    PhpUnitVersionLabel.$$$reportNull$$$0(2);
                }
                return string;
            }
            String vendor = PathUtil.getParentPath((String)autoloader);
            String separator = FileUtil.isWindowsAbsolutePath((String)vendor) ? "\\" : "/";
            String string = StringUtil.join((String[])new String[]{vendor, "phpunit", "phpunit", "phpunit"}, (String)separator);
            if (string == null) {
                PhpUnitVersionLabel.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected boolean isModified(@NotNull PhpUnitSettings state) {
            if (state == null) {
                PhpUnitVersionLabel.$$$reportNull$$$0(4);
            }
            return !StringUtil.equals((CharSequence)PhpTestFrameworkVersionCache.getCache(PhpUnitConfigurableForm.this.myProject, state), (CharSequence)this.myVersionLabel.getVersion());
        }

        protected void apply(@NotNull PhpUnitSettings state) {
            if (state == null) {
                PhpUnitVersionLabel.$$$reportNull$$$0(5);
            }
            PhpTestFrameworkVersionCache.setCache(PhpUnitConfigurableForm.this.myProject, state, this.myVersionLabel.isVisible() ? this.myVersionLabel.getVersion() : null);
        }

        protected void reset(@NotNull PhpUnitSettings state, boolean autoUpdate) {
            String version;
            if (state == null) {
                PhpUnitVersionLabel.$$$reportNull$$$0(6);
            }
            if ((version = PhpTestFrameworkVersionCache.getCache(PhpUnitConfigurableForm.this.myProject, state)) == null && autoUpdate && !ApplicationManager.getApplication().isUnitTestMode()) {
                UIUtil.invokeLaterIfNeeded(() -> this.scheduleInfoComputation());
            } else {
                this.resetVersion(version);
            }
        }

        public void dispose() {
            this.myDisposed = true;
            Disposer.dispose((Disposable)this.myReloadAlarm);
            PhpUnitConfigurableForm.this.myExecutionPathChangeListeners.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 4, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpunit/PhpUnitConfigurableForm$PhpUnitVersionLabel";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "reloadVersion";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExecutable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpunit/PhpUnitConfigurableForm$PhpUnitVersionLabel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isModified";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "apply";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "reset";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 4, 5, 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

