/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PhpQualifiedNameProvider
implements QualifiedNameProvider {
    public static final String SEPARATOR = "::";

    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        if (element == null) {
            PhpQualifiedNameProvider.$$$reportNull$$$0(0);
        }
        return element instanceof PhpNamedElement ? element : null;
    }

    public String getQualifiedName(@NotNull PsiElement element) {
        if (element == null) {
            PhpQualifiedNameProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PhpEnumCase) {
            PhpEnumCase enumCase = (PhpEnumCase)element;
            return PhpQualifiedNameProvider.getEnumCaseQualifiedName(enumCase);
        }
        return element instanceof PhpNamedElement ? ((PhpNamedElement)element).getFQN().replace(".", SEPARATOR) : null;
    }

    public static String getEnumCaseQualifiedName(@NotNull PhpEnumCase element) {
        PhpClass containingClass;
        if (element == null) {
            PhpQualifiedNameProvider.$$$reportNull$$$0(2);
        }
        return (containingClass = element.getContainingClass()) != null ? containingClass.getFQN() + SEPARATOR + element.getName() : element.getFQN();
    }

    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        int separator;
        if (fqn == null) {
            PhpQualifiedNameProvider.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpQualifiedNameProvider.$$$reportNull$$$0(4);
        }
        String memberName = (separator = fqn.indexOf(SEPARATOR)) >= 0 ? fqn.substring(separator + SEPARATOR.length()) : null;
        fqn = separator >= 0 ? fqn.substring(0, separator) : fqn;
        Collection classes = PhpIndex.getInstance((Project)project).getClassesByFQN(fqn);
        if (classes.size() == 1) {
            PhpClass aClass = (PhpClass)classes.iterator().next();
            if (memberName == null) {
                return aClass;
            }
            Method member = aClass.findMethodByName((CharSequence)memberName);
            if (member == null) {
                member = aClass.findFieldByName((CharSequence)memberName, false);
            }
            if (member == null) {
                member = aClass.findFieldByName((CharSequence)memberName, true);
            }
            if (member == null && aClass.isEnum()) {
                member = (PhpClassMember)ContainerUtil.find((Iterable)aClass.getEnumCases(), c -> c.getName().equals(memberName));
            }
            return member;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/navigation/PhpQualifiedNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElementToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEnumCaseQualifiedName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNameToElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

