/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.stub_factories;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.PhpFilePathUtils;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStubBase;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStub;
import com.jetbrains.php.lang.psi.stubs.PhpVariableStubImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0007J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\u0012H\u0002J\"\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00032\u0010\u0010\u0017\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0019\u0018\u00010\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0002H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/stub_factories/PhpVariableStubFactory;", "Lcom/intellij/psi/stubs/StubElementFactory;", "Lcom/jetbrains/php/lang/psi/stubs/PhpVariableStub;", "Lcom/jetbrains/php/lang/psi/elements/Variable;", "<init>", "()V", "isApplicableForStub", "", "node", "Lcom/intellij/lang/ASTNode;", "inferredAssignedTypeToGlobalVariable", "Lcom/jetbrains/php/lang/psi/resolve/types/PhpType;", "variable", "collectFilePathsFromLastWriters", "", "Lcom/jetbrains/php/lang/psi/elements/impl/PhpFilePathUtils$PhpFilePathDescriptor;", "doInferredAssignedTypeToGlobalVariable", "isFirstWrite", "Lcom/jetbrains/php/lang/psi/elements/PhpPsiElement;", "resolveFirstWrite", "Lcom/jetbrains/php/lang/psi/elements/PhpNamedElement;", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "shouldCreateStub", "createPsi", "stub", "intellij.php.impl"})
public final class PhpVariableStubFactory
implements StubElementFactory<PhpVariableStub, Variable> {
    @NotNull
    public static final PhpVariableStubFactory INSTANCE = new PhpVariableStubFactory();

    private PhpVariableStubFactory() {
    }

    @JvmStatic
    public static final boolean isApplicableForStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getElementType() != PhpStubElementTypes.VARIABLE) {
            return false;
        }
        for (ASTNode parent = node.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            IElementType type;
            Intrinsics.checkNotNullExpressionValue((Object)parent.getElementType(), (String)"getElementType(...)");
            if (type == PhpElementTypes.WHILE || type == PhpElementTypes.DO_WHILE || type == PhpElementTypes.FOR || type == PhpElementTypes.FOREACH || type == PhpElementTypes.IF || type == PhpElementTypes.CONCATENATION_EXPRESSION || type == PhpElementTypes.METHOD_REFERENCE || type == PhpElementTypes.FIELD_REFERENCE || type == PhpElementTypes.PARAMETER_LIST) {
                return false;
            }
            if (type != PhpStubElementTypes.CLASS_METHOD && type != PhpStubElementTypes.FUNCTION) continue;
            return false;
        }
        PsiElement element = node.getPsi();
        Intrinsics.checkNotNull((Object)element, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.Variable");
        return ((Variable)element).isDeclaration();
    }

    @JvmStatic
    @NotNull
    public static final PhpType inferredAssignedTypeToGlobalVariable(@Nullable Variable variable) {
        PhpVariableStub stub;
        if (variable == null) {
            PhpType phpType = PhpType.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"EMPTY");
            return phpType;
        }
        if (variable instanceof VariableImpl && (stub = (PhpVariableStub)((VariableImpl)variable).getGreenStub()) instanceof PhpVariableStubImpl) {
            PhpType phpType = ((PhpVariableStubImpl)stub).getInferredAssignedType();
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getInferredAssignedType(...)");
            return phpType;
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)variable), () -> PhpVariableStubFactory.inferredAssignedTypeToGlobalVariable$lambda$0(variable));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (PhpType)object;
    }

    private final List<List<PhpFilePathUtils.PhpFilePathDescriptor>> collectFilePathsFromLastWriters(Variable variable) {
        if (!this.isFirstWrite((PhpPsiElement)variable)) {
            List<List<PhpFilePathUtils.PhpFilePathDescriptor>> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            return list;
        }
        PhpScopeHolder phpScopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        if (phpScopeHolder == null) {
            List<List<PhpFilePathUtils.PhpFilePathDescriptor>> list = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList(...)");
            return list;
        }
        PhpScopeHolder scopeHolder = phpScopeHolder;
        List res = new ArrayList();
        PhpControlFlowUtil.processPredecessors((PhpInstruction)scopeHolder.getControlFlow().getExitPoint(), false, new PhpInstructionProcessor(variable, res){
            final /* synthetic */ Variable $variable;
            final /* synthetic */ List<List<PhpFilePathUtils.PhpFilePathDescriptor>> $res;
            {
                this.$variable = $variable;
                this.$res = $res;
            }

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), this.$variable.getName()) && instruction.getAccess().isWrite()) {
                    List<List<PhpFilePathUtils.PhpFilePathDescriptor>> list = PhpFilePathUtils.evaluateLocally((PsiElement)instruction.getAnchor());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"evaluateLocally(...)");
                    this.$res.addAll((Collection<List<PhpFilePathUtils.PhpFilePathDescriptor>>)list);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        return res;
    }

    private final PhpType doInferredAssignedTypeToGlobalVariable(Variable variable) {
        ASTNode aSTNode = variable.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        if (!this.isFirstWrite(aSTNode)) {
            PhpType phpType = PhpType.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"EMPTY");
            return phpType;
        }
        PhpType phpType = variable.getDocType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getDocType(...)");
        PhpType docType = phpType;
        if (!docType.isEmpty()) {
            return docType;
        }
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class);
        PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)variable);
        if (scopeHolder != null && instruction != null) {
            PhpType phpType2;
            boolean originalDeclarationReached;
            PhpExitPointInstruction phpExitPointInstruction = scopeHolder.getControlFlow().getExitPoint();
            Intrinsics.checkNotNullExpressionValue((Object)phpExitPointInstruction, (String)"getExitPoint(...)");
            PhpExitPointInstruction exitPoint = phpExitPointInstruction;
            String string = variable.getName();
            PhpVariableInferredTypeAnalyzerProcessor processor2 = new PhpVariableInferredTypeAnalyzerProcessor(variable, scopeHolder, exitPoint, string){

                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                    Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
                    return this.doProcessArrayAccess(instruction);
                }
            };
            PhpVariableInferredTypeAnalyzerProcessor.inferType(processor2, variable, variable.getName(), scopeHolder, (PhpInstruction)exitPoint);
            PhpType phpType3 = processor2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)phpType3, (String)"getType(...)");
            PhpType inferredType = phpType3;
            PhpType phpType4 = inferredType.filterOut(arg_0 -> PhpVariableStubFactory.doInferredAssignedTypeToGlobalVariable$lambda$1(variable, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)phpType4, (String)"filterOut(...)");
            PhpType typeWithoutVariableSignature = phpType4;
            boolean bl = originalDeclarationReached = typeWithoutVariableSignature.size() != inferredType.size() || inferredType.isEmpty();
            if (originalDeclarationReached) {
                PhpType phpType5 = new PhpType().add(typeWithoutVariableSignature).add(variable.getType());
                phpType2 = phpType5;
                Intrinsics.checkNotNullExpressionValue((Object)phpType5, (String)"add(...)");
            } else {
                phpType2 = typeWithoutVariableSignature;
            }
            return phpType2;
        }
        PhpType phpType6 = variable.getType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType6, (String)"getType(...)");
        return phpType6;
    }

    private final boolean isFirstWrite(ASTNode node) {
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.php.lang.psi.elements.PhpPsiElement");
        return this.isFirstWrite((PhpPsiElement)psiElement);
    }

    private final boolean isFirstWrite(PhpPsiElement variable) {
        return Intrinsics.areEqual((Object)variable, (Object)this.resolveFirstWrite(variable));
    }

    private final PhpNamedElement resolveFirstWrite(PhpPsiElement variable) {
        Set<? extends PhpNamedElement> set = VariableImpl.collectDeclarations((PsiElement)variable, false, variable.getName());
        Intrinsics.checkNotNullExpressionValue(set, (String)"collectDeclarations(...)");
        return (PhpNamedElement)CollectionsKt.firstOrNull((Iterable)set);
    }

    @NotNull
    public PhpVariableStub createStub(@NotNull Variable psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        PhpNamedElement phpNamedElement;
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        PhpType type = PhpVariableStubFactory.inferredAssignedTypeToGlobalVariable(psi);
        String string = psi.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String name = string;
        PhpType phpType = this.isFirstWrite((PhpPsiElement)psi) ? psi.getType() : PhpVariableStubFactory.inferredAssignedTypeToGlobalVariable((phpNamedElement = this.resolveFirstWrite((PhpPsiElement)psi)) instanceof Variable ? (Variable)phpNamedElement : null);
        Intrinsics.checkNotNull((Object)phpType);
        PhpType expressionType = phpType;
        return new PhpVariableStubImpl(parentStub, (IElementType)PhpElementTypes.VARIABLE, StringRef.fromString((String)name), expressionType, type, PhpNamedStubBase.packDocCommentPresence((PhpNamedElement)psi), this.collectFilePathsFromLastWriters(psi));
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return PhpVariableStubFactory.isApplicableForStub(node);
    }

    @NotNull
    public Variable createPsi(@NotNull PhpVariableStub stub) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        return new VariableImpl(stub);
    }

    private static final CachedValueProvider.Result inferredAssignedTypeToGlobalVariable$lambda$0(Variable $variable) {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)INSTANCE.doInferredAssignedTypeToGlobalVariable($variable), (Object[])objectArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean doInferredAssignedTypeToGlobalVariable$lambda$1(Variable $variable, String t) {
        if (!PhpTypeSignatureKey.VARIABLE.isSigned(t)) return false;
        Intrinsics.checkNotNull((Object)t);
        String string = t.substring(2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        if (!PhpLangUtil.equalsVariableNames(string, $variable.getName())) return false;
        return true;
    }
}

