/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.inspections.parameterCountMismatch.PhpFuncGetArgUsageProvider;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpCollectionExternalizer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpConstantNameIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsCollector;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionConstantsFromClassArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionValuesFromConstantArguments;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpMetaRegisteredArgumentsSetCollector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PhpExpectedReturnValuesIndex
extends FileBasedIndexExtension<String, Collection<PhpExpectedFunctionArgument>> {
    @NonNls
    public static final ID<String, Collection<PhpExpectedFunctionArgument>> KEY = ID.create((String)"php.expected.function.return.values");
    private static final String EXPECTED_VALUES_ATTRIBUTE_FQN = "\\JetBrains\\PhpStorm\\ExpectedValues";

    @NotNull
    public ID<String, Collection<PhpExpectedFunctionArgument>> getName() {
        ID<String, Collection<PhpExpectedFunctionArgument>> iD = KEY;
        if (iD == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Collection<PhpExpectedFunctionArgument>, FileContent> getIndexer() {
        return new DataIndexer<String, Collection<PhpExpectedFunctionArgument>, FileContent>(){

            @NotNull
            public Map<String, Collection<PhpExpectedFunctionArgument>> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashMap<String, Collection<PhpExpectedFunctionArgument>> map = new HashMap<String, Collection<PhpExpectedFunctionArgument>>();
                PsiFile file = inputData.getPsiFile();
                if (file instanceof PhpFile && PhpParameterBasedTypeProvider.isMeta(file)) {
                    PhpMetaRegisteredArgumentsSetCollector registeredArgumentsSetCollector = new PhpMetaRegisteredArgumentsSetCollector();
                    PhpControlFlowUtil.processFile((PhpFile)file, registeredArgumentsSetCollector);
                    PhpControlFlowUtil.processFile((PhpFile)file, new PhpExpectedReturnValuesCollector(map, registeredArgumentsSetCollector.getRegisteredArguments()));
                } else {
                    for (Function function : PhpFuncGetArgUsageProvider.findTopLevelFunctions(file)) {
                        PhpExpectedReturnValuesIndex.expectedValuesFromAttributes((PhpAttributesOwner)function, 0).forEach(expectedArgument -> map.computeIfAbsent(function.getFQN(), s -> new ArrayList()).add(expectedArgument));
                    }
                }
                Map map2 = StreamEx.of(map.entrySet()).toMap(Map.Entry::getKey, entry -> ((Collection)entry.getValue()).stream().distinct().collect(Collectors.toList()));
                if (map2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedReturnValuesIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedReturnValuesIndex$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public static Stream<PhpExpectedFunctionArgument> expectedValuesFromAttributes(PhpAttributesOwner attributesOwner, int index) {
        Stream<PhpExpectedFunctionArgument> stream = attributesOwner.getAttributes(EXPECTED_VALUES_ATTRIBUTE_FQN).stream().flatMap(attr -> PhpExpectedReturnValuesIndex.createExpectedArguments(attr, index).stream());
        if (stream == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(1);
        }
        return stream;
    }

    @NotNull
    private static Collection<PhpExpectedFunctionArgument> createExpectedArguments(PhpAttribute attribute, int index) {
        ClassReference classReference;
        boolean flag;
        PsiElement argument = attribute.getParameter(0);
        PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
        String parameterName = nameIdentifier != null ? nameIdentifier.getText() : null;
        boolean bl = flag = parameterName != null && parameterName.equals("flags");
        if (parameterName == null || flag || parameterName.equals("values")) {
            if (argument instanceof ArrayCreationExpression) {
                return PhpExpectedReturnValuesIndex.createExpectedArgumentsFromArray(index, argument, flag);
            }
            if (argument instanceof ConstantReference || argument instanceof ClassConstantReference) {
                List<PhpExpectedFunctionArgument> list = Collections.singletonList(new PhpExpectedFunctionValuesFromConstantArguments(((PhpReference)argument).getSignature(), index, flag, true));
                if (list == null) {
                    PhpExpectedReturnValuesIndex.$$$reportNull$$$0(2);
                }
                return list;
            }
        } else if (argument instanceof ClassConstantReference && (classReference = (ClassReference)ObjectUtils.tryCast((Object)((ClassConstantReference)argument).getClassReference(), ClassReference.class)) != null) {
            List<PhpExpectedFunctionArgument> list = Collections.singletonList(new PhpExpectedFunctionConstantsFromClassArgument(classReference.getFQN(), index, parameterName.equals("flagsFromClass"), true));
            if (list == null) {
                PhpExpectedReturnValuesIndex.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<PhpExpectedFunctionArgument> list = Collections.emptyList();
        if (list == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(4);
        }
        return list;
    }

    @NotNull
    public static List<PhpExpectedFunctionArgument> createExpectedArgumentsFromArray(int index, PsiElement argument, boolean flag) {
        ArrayList<PhpExpectedFunctionArgument> res = new ArrayList<PhpExpectedFunctionArgument>();
        for (PsiElement value : PhpPsiUtil.getChildren(argument, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.ARRAY_VALUE)))) {
            PsiElement child = value.getFirstChild();
            if (child.getTextRange().getLength() > 1000) continue;
            res.add(PhpExpectedFunctionArgumentsIndex.getExpectedArgument(child, index, index, null, flag, true));
        }
        ArrayList<PhpExpectedFunctionArgument> arrayList = res;
        if (arrayList == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(6);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<PhpExpectedFunctionArgument>> getValueExternalizer() {
        PhpCollectionExternalizer<PhpExpectedFunctionArgument> phpCollectionExternalizer = PhpExpectedFunctionArgumentsIndex.VALUE_EXTERNALIZER;
        if (phpCollectionExternalizer == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(7);
        }
        return phpCollectionExternalizer;
    }

    public int getVersion() {
        return 4;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = PhpConstantNameIndex.PHP_INPUT_FILTER;
        if (inputFilter == null) {
            PhpExpectedReturnValuesIndex.$$$reportNull$$$0(8);
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/stubs/indexes/expectedArguments/PhpExpectedReturnValuesIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "expectedValuesFromAttributes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectedArguments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createExpectedArgumentsFromArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static final class PhpExpectedReturnValuesCollector
    extends PhpExpectedFunctionArgumentsCollector {
        private static final String POSSIBLE_RETURN_VALUES_NAME = "expectedReturnValues";

        private PhpExpectedReturnValuesCollector(Map<String, Collection<PhpExpectedFunctionArgument>> map, Map<String, Collection<PhpExpectedFunctionArgument>> arguments) {
            super(map, arguments);
        }

        @Override
        public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
            PsiElement target = this.getMetaFunctionTargetWithName(instruction, POSSIBLE_RETURN_VALUES_NAME);
            String fqn = PhpExpectedReturnValuesCollector.getFQN(target);
            if (fqn == null) {
                return true;
            }
            PsiElement[] parameters = instruction.getFunctionReference().getParameters();
            if (parameters.length < 2) {
                return true;
            }
            Collection<PhpExpectedFunctionArgument> arguments = this.getExpectedArguments(Arrays.copyOfRange(parameters, 1, parameters.length), 0);
            this.myMap.computeIfAbsent(fqn, k -> new SmartList()).addAll(arguments);
            return super.processPhpCallInstruction(instruction);
        }
    }
}

