/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs.indexes;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.io.DataExternalizer;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.stubs.PhpCustomIndexAwareStub;
import com.jetbrains.php.lang.psi.stubs.PhpNamedStub;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpCustomFunctionIndex<T> {
    private static final ExtensionPointName<PhpCustomFunctionIndex<?>> EP_NAME = new ExtensionPointName("com.jetbrains.php.customFunctionIndex");
    @NotNull
    private static final Interner<Int2ObjectMap<Object>> INTERNER = Interner.createWeakInterner();

    @NotNull
    public static Int2ObjectMap<Object> getCustomIndexMapFromAST(@NotNull Function function) {
        if (function == null) {
            PhpCustomFunctionIndex.$$$reportNull$$$0(0);
        }
        List<PhpCustomFunctionIndex<?>> sortedIndexes = PhpCustomFunctionIndex.getSortedIndexes();
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        for (int i = 0; i < sortedIndexes.size(); ++i) {
            Object data = sortedIndexes.get(i).getDataFromAST(function);
            if (data == null) continue;
            res.put(i, data);
        }
        Int2ObjectMap int2ObjectMap = (Int2ObjectMap)INTERNER.intern((Object)res);
        if (int2ObjectMap == null) {
            PhpCustomFunctionIndex.$$$reportNull$$$0(1);
        }
        return int2ObjectMap;
    }

    @NotNull
    private static List<PhpCustomFunctionIndex<?>> getSortedIndexes() {
        ArrayList sorted = new ArrayList(EP_NAME.getExtensionList());
        sorted.sort(Comparator.comparing(o -> o.getClass().getName()));
        ArrayList arrayList = sorted;
        if (arrayList == null) {
            PhpCustomFunctionIndex.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T getData(Function function, Class<? extends PhpCustomFunctionIndex<T>> clazz) {
        if (!(function instanceof FunctionImpl)) {
            return null;
        }
        PhpNamedStub stub = (PhpNamedStub)((FunctionImpl)function).getGreenStub();
        if (stub != null) {
            if (stub instanceof PhpCustomIndexAwareStub) {
                Int2ObjectMap<Object> map = ((PhpCustomIndexAwareStub)stub).getCustomIndexMap();
                int i = -1;
                List<PhpCustomFunctionIndex<?>> list = PhpCustomFunctionIndex.getSortedIndexes();
                int listSize = list.size();
                for (int i1 = 0; i1 < listSize; ++i1) {
                    PhpCustomFunctionIndex<?> t = list.get(i1);
                    if (t.getClass() != clazz) continue;
                    i = i1;
                    break;
                }
                if (map.containsKey(i)) {
                    return (T)map.get(i);
                }
            }
        } else {
            for (PhpCustomFunctionIndex index : EP_NAME.getExtensionList()) {
                if (!index.getClass().equals(clazz)) continue;
                return index.getDataFromAST(function);
            }
        }
        return null;
    }

    @Nullable
    protected abstract T getDataFromAST(@NotNull Function var1);

    protected abstract DataExternalizer<T> getExternalizer();

    public static <T> void writeCustomIndexMap(StubOutputStream dataStream, Int2ObjectMap<T> map) throws IOException {
        List<PhpCustomFunctionIndex<?>> sortedIndexes = PhpCustomFunctionIndex.getSortedIndexes();
        dataStream.writeInt(map.size());
        IntIterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int key = iterator.nextInt();
            dataStream.writeInt(key);
            PhpCustomFunctionIndex.serializeData(sortedIndexes.get(key), map.get(key), dataStream);
        }
    }

    private static <T> void serializeData(PhpCustomFunctionIndex<T> index, T data, StubOutputStream dataStream) throws IOException {
        index.getExternalizer().save((DataOutput)dataStream, data);
    }

    @NotNull
    public static Int2ObjectMap<Object> readCustomIndexMap(StubInputStream stream) throws IOException {
        int size = stream.readInt();
        Int2ObjectOpenHashMap res = new Int2ObjectOpenHashMap();
        List<PhpCustomFunctionIndex<?>> sortedIndexes = PhpCustomFunctionIndex.getSortedIndexes();
        for (int i = 0; i < size; ++i) {
            int key = stream.readInt();
            res.put(key, sortedIndexes.get(key).getExternalizer().read((DataInput)stream));
        }
        Int2ObjectMap int2ObjectMap = (Int2ObjectMap)INTERNER.intern((Object)res);
        if (int2ObjectMap == null) {
            PhpCustomFunctionIndex.$$$reportNull$$$0(3);
        }
        return int2ObjectMap;
    }

    public static <T> Collection<T> getDataHierarchyAware(FunctionReference reference, Class<? extends PhpCustomFunctionIndex<T>> clazz) {
        CachedValuesManager manager;
        if (reference == null) {
            return Collections.emptyList();
        }
        Collection functions = reference.multiResolveStrict(Function.class);
        List data = ContainerUtil.map((Collection)functions, arg_0 -> PhpCustomFunctionIndex.lambda$getDataHierarchyAware$1(clazz, manager = CachedValuesManager.getManager((Project)reference.getProject()), arg_0));
        if (data.isEmpty() || ContainerUtil.exists((Iterable)data, c -> c.isEmpty())) {
            return Collections.emptyList();
        }
        return ContainerUtil.flatten((Iterable)data);
    }

    private static <T> Collection<T> dataCachedData(Class<? extends PhpCustomFunctionIndex<T>> clazz, CachedValuesManager manager, Function function) {
        return (Collection)CachedValuesManager.getCachedValue((PsiElement)function, (Key)manager.getKeyForClass(clazz), () -> CachedValueProvider.Result.create(PhpCustomFunctionIndex.getDataHierarchyAware(function, clazz), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static <T> Collection<T> getDataHierarchyAware(@NotNull Function function, Class<? extends PhpCustomFunctionIndex<T>> clazz) {
        T data;
        if (function == null) {
            PhpCustomFunctionIndex.$$$reportNull$$$0(4);
        }
        if ((data = PhpCustomFunctionIndex.getData(function, clazz)) != null) {
            HashSet res = new HashSet();
            res.add(data);
            if (function instanceof Method) {
                PhpClassHierarchyUtils.processOverridingMethods((Method)((Method)function), (m, s, b) -> {
                    Object d = PhpCustomFunctionIndex.getData((Function)m, clazz);
                    return res.add(d) && d != null;
                });
                if (res.contains(null)) {
                    return Collections.emptyList();
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ Collection lambda$getDataHierarchyAware$1(Class clazz, CachedValuesManager manager, Function function) {
        return PhpCustomFunctionIndex.dataCachedData(clazz, manager, function);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpCustomFunctionIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/stubs/indexes/PhpCustomFunctionIndex";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomIndexMapFromAST";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedIndexes";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "readCustomIndexMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomIndexMapFromAST";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataHierarchyAware";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

