/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.stubs;

import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.io.StringRef;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.impl.PhpEnumCaseImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpEnumCaseStub;
import com.jetbrains.php.lang.psi.stubs.PhpEnumCaseStubImpl;
import com.jetbrains.php.lang.psi.stubs.PhpStubElementType;
import com.jetbrains.php.lang.psi.stubs.PhpStubSerializer;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpEnumCaseIndex;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0015\u001a\u00020\fH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/php/lang/psi/stubs/PhpEnumCaseStubSerializer;", "Lcom/jetbrains/php/lang/psi/stubs/PhpStubSerializer;", "Lcom/jetbrains/php/lang/psi/elements/PhpEnumCase;", "Lcom/jetbrains/php/lang/psi/stubs/PhpEnumCaseStub;", "<init>", "()V", "serialize", "", "stub", "dataStream", "Lcom/intellij/psi/stubs/StubOutputStream;", "deserialize", "Lcom/intellij/psi/stubs/StubInputStream;", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "indexStub", "sink", "Lcom/intellij/psi/stubs/IndexSink;", "writeDefaultValueDescriptor", "stream", "descriptor", "Lcom/jetbrains/php/lang/psi/elements/PhpEnumCase$PhpDefaultValueDescriptor;", "readDefaultValueDescriptor", "intellij.php.impl"})
public final class PhpEnumCaseStubSerializer
extends PhpStubSerializer<PhpEnumCase, PhpEnumCaseStub> {
    public void serialize(@NotNull PhpEnumCaseStub stub, @NotNull StubOutputStream dataStream) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        dataStream.writeName(stub.getName());
        PhpType phpType = stub.getType();
        Intrinsics.checkNotNullExpressionValue((Object)phpType, (String)"getType(...)");
        this.writePhpType(dataStream, phpType);
        this.writeDefaultValueDescriptor(dataStream, stub.getDefaultValueDescriptor());
    }

    @NotNull
    public PhpEnumCaseStub deserialize(@NotNull StubInputStream dataStream, @Nullable StubElement<?> parentStub) {
        Intrinsics.checkNotNullParameter((Object)dataStream, (String)"dataStream");
        StringRef name = dataStream.readName();
        PhpType type = this.readPhpType(dataStream);
        return new PhpEnumCaseStubImpl(parentStub, (IElementType)PhpElementTypes.ENUM_CASE, name, type, this.readDefaultValueDescriptor(dataStream));
    }

    @Override
    @NotNull
    public IElementType getElementType() {
        PhpStubElementType phpStubElementType = PhpElementTypes.ENUM_CASE;
        Intrinsics.checkNotNullExpressionValue((Object)phpStubElementType, (String)"ENUM_CASE");
        return (IElementType)phpStubElementType;
    }

    @Override
    public void indexStub(@NotNull PhpEnumCaseStub stub, @NotNull IndexSink sink) {
        Intrinsics.checkNotNullParameter((Object)stub, (String)"stub");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        String string = stub.getName();
        if (string == null) {
            return;
        }
        String name = string;
        sink.occurrence(PhpEnumCaseIndex.KEY, (Object)name);
    }

    private final void writeDefaultValueDescriptor(StubOutputStream stream, PhpEnumCase.PhpDefaultValueDescriptor descriptor) {
        if (descriptor == null) {
            stream.writeInt(0);
            return;
        }
        PhpEnumCase.PhpDefaultValueDescriptor phpDefaultValueDescriptor = descriptor;
        if (phpDefaultValueDescriptor instanceof PhpEnumCaseImpl.PhpUnknownDefaultValueDescriptor) {
            stream.writeInt(-1);
        } else if (phpDefaultValueDescriptor instanceof PhpEnumCaseImpl.PhpIntDefaultValueDescriptor) {
            stream.writeInt(1);
        } else if (phpDefaultValueDescriptor instanceof PhpEnumCaseImpl.PhpStringDefaultValueDescriptor) {
            stream.writeInt(2);
            stream.writeBoolean(((PhpEnumCaseImpl.PhpStringDefaultValueDescriptor)descriptor).isSingleQuote());
        }
        stream.writeUTF(descriptor.getValue());
    }

    private final PhpEnumCase.PhpDefaultValueDescriptor readDefaultValueDescriptor(StubInputStream stream) {
        int type = stream.readInt();
        return switch (type) {
            case 0 -> null;
            case -1 -> {
                String value = stream.readUTF();
                yield new PhpEnumCaseImpl.PhpUnknownDefaultValueDescriptor(value);
            }
            case 1 -> {
                String value = stream.readUTF();
                yield new PhpEnumCaseImpl.PhpIntDefaultValueDescriptor(value);
            }
            case 2 -> {
                boolean singleQuote = stream.readBoolean();
                String value = stream.readUTF();
                yield new PhpEnumCaseImpl.PhpStringDefaultValueDescriptor(value, singleQuote);
            }
            default -> throw new IllegalArgumentException("Unknown descriptor type: " + type);
        };
    }
}

