/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpCharBasedTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeProvider4;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpNativeArrayKeyTypeProvider
extends PhpCharBasedTypeKey
implements PhpTypeProvider4 {
    public static final char KEY = '\u3232';

    @Override
    public char getKey() {
        return '\u3232';
    }

    public Collection<? extends PhpNamedElement> getBySignature(String expression, Set<String> visited, int depth, Project project) {
        return null;
    }

    @NotNull
    public PhpType getType(PsiElement array) {
        PhpAccessVariableInstruction instruction;
        final Ref isInt = new Ref((Object)false);
        final Ref isString = new Ref((Object)false);
        if (array instanceof ArrayCreationExpression) {
            PhpNativeArrayKeyTypeProvider.processTypes((ArrayCreationExpression)array, (Ref<Boolean>)isInt, (Ref<Boolean>)isString);
        } else if (array instanceof Variable && !(array.getParent() instanceof PhpExpression) && (instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)((Variable)array), PhpAccessVariableInstruction.class)) != null) {
            final Ref ambiguity = new Ref((Object)false);
            final CharSequence variableName = instruction.getVariableName();
            PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction1) {
                    if (PhpLangUtil.equalsVariableNames(instruction1.getVariableName(), variableName) && instruction1.getAccess().isWrite() && !PhpNativeArrayKeyTypeProvider.processTypes((ArrayCreationExpression)ObjectUtils.tryCast((Object)((PhpAccessVariableInstructionImpl)instruction1).getAssignedValue(), ArrayCreationExpression.class), (Ref<Boolean>)isInt, (Ref<Boolean>)isString)) {
                        ambiguity.set((Object)true);
                        return false;
                    }
                    return super.processAccessVariableInstruction(instruction1);
                }

                public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction1) {
                    if (PhpLangUtil.equalsVariableNames(instruction1.getVariableName(), variableName) && instruction1.getAccess().isWrite()) {
                        PsiElement key = instruction1.getKey();
                        if (key == null) {
                            isInt.set((Object)true);
                        } else if (!PhpPsiUtil.isOfType(key, PhpElementTypes.SCALARS) || !PhpNativeArrayKeyTypeProvider.processTypes((Ref<Boolean>)isInt, (Ref<Boolean>)isString, new PhpType().add(key))) {
                            ambiguity.set((Object)true);
                            return false;
                        }
                    }
                    return super.processArrayAccessInstruction(instruction1);
                }
            });
            if (((Boolean)ambiguity.get()).booleanValue()) {
                PhpType phpType = PhpType.EMPTY;
                if (phpType == null) {
                    PhpNativeArrayKeyTypeProvider.$$$reportNull$$$0(0);
                }
                return phpType;
            }
        }
        PhpType phpType = this.processTypes((Ref<Boolean>)isInt, (Ref<Boolean>)isString);
        if (phpType == null) {
            PhpNativeArrayKeyTypeProvider.$$$reportNull$$$0(1);
        }
        return phpType;
    }

    private static boolean processTypes(@Nullable ArrayCreationExpression array, Ref<Boolean> isInt, Ref<Boolean> isString) {
        if (array == null) {
            isInt.set((Object)false);
            isString.set((Object)false);
            return false;
        }
        for (PhpPsiElement child : ArrayCreationExpressionImpl.children(array).limit(PhpTypeAnalyserVisitor.MAX_ARRAY_VALUES)) {
            if (child instanceof ArrayHashElement) {
                PhpType keyType = new PhpType().add((PsiElement)((ArrayHashElement)child).getKey());
                PhpNativeArrayKeyTypeProvider.processTypes(isInt, isString, keyType);
                continue;
            }
            isInt.set((Object)true);
        }
        return true;
    }

    private PhpType processTypes(Ref<Boolean> isInt, Ref<Boolean> isString) {
        if (((Boolean)isInt.get()).booleanValue() && !((Boolean)isString.get()).booleanValue()) {
            return this.getKeys("\\int");
        }
        if (((Boolean)isString.get()).booleanValue() && !((Boolean)isInt.get()).booleanValue()) {
            return this.getKeys("\\string");
        }
        if (((Boolean)isInt.get()).booleanValue()) {
            return PhpType.or((PhpType)this.getKeys("\\string"), (PhpType)this.getKeys("\\int"));
        }
        return PhpType.EMPTY;
    }

    @NotNull
    private PhpType getKeys(String keyType) {
        PhpType phpType = new PhpType().add(this.sign(keyType));
        if (phpType == null) {
            PhpNativeArrayKeyTypeProvider.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    private static boolean processTypes(Ref<Boolean> isInt, Ref<Boolean> isString, PhpType keyType) {
        if (PhpType.INT.equals((Object)keyType)) {
            isInt.set((Object)true);
            return true;
        }
        if (PhpType.STRING.equals((Object)keyType)) {
            isString.set((Object)true);
            return true;
        }
        isString.set((Object)false);
        isInt.set((Object)false);
        return false;
    }

    @Nullable
    public PhpType complete(String expression, Project project) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpNativeArrayKeyTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

